/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.TransformationAnalysis2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TracePropertyRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractTransformationAnalysis
extends QVTbaseHelper
implements Nameable {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Transformation transformation;
    protected final @NonNull RootRegion rootRegion;
    protected final @NonNull Property oclContainerProperty;
    private final @NonNull Map<@NonNull ClassDatum, @NonNull TraceClassRegionAnalysis> classDatum2traceClassAnalysis = new HashMap<ClassDatum, TraceClassRegionAnalysis>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull TracePropertyRegionAnalysis> propertyDatum2tracePropertyAnalysis = new HashMap<PropertyDatum, TracePropertyRegionAnalysis>();
    private @Nullable CyclicRegionsAnalysis cyclesRegionAnalysis = null;
    private @Nullable TransformationAnalysis2TracePackage transformationAnalysis2tracePackage = null;
    private final @NonNull Map<@NonNull Rule, @NonNull RuleAnalysis> rule2ruleAnalysis = new HashMap<Rule, RuleAnalysis>();
    private @NonNull Map<@NonNull Region, @NonNull RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Property, @NonNull List<@NonNull Region>> corollaryProperty2regions = new HashMap<Property, List<Region>>();
    private @Nullable RootPartitionAnalysis rootPartitionAnalysis = null;

    protected AbstractTransformationAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull Transformation transformation, @NonNull RootRegion rootRegion) {
        super(scheduleManager.getEnvironmentFactory());
        this.scheduleManager = scheduleManager;
        this.transformation = transformation;
        this.rootRegion = rootRegion;
        this.oclContainerProperty = scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)transformation)) {
            RuleAnalysis ruleAnalysis = scheduleManager.createRuleAnalysis(this, asRule);
            this.rule2ruleAnalysis.put(asRule, ruleAnalysis);
        }
    }

    public void addCorollary(@NonNull NavigableEdge edge) {
        assert (edge.isRealized());
        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
        assert (targetNode.isRealized());
        Region region = QVTscheduleUtil.getOwningRegion((ConnectionEnd)edge);
        Property property = QVTscheduleUtil.getProperty((NavigableEdge)edge);
        List<@NonNull Region> regions = this.corollaryProperty2regions.get(property);
        if (regions == null) {
            regions = new ArrayList<Region>();
            this.corollaryProperty2regions.put(property, regions);
        }
        if (!regions.contains(region)) {
            regions.add(region);
        }
    }

    public @NonNull TraceClassRegionAnalysis addConsumer(@NonNull ClassDatum classDatum, @NonNull RegionAnalysis consumer) {
        TraceClassRegionAnalysis traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
        traceClassAnalysis.addConsumer(consumer);
        return traceClassAnalysis;
    }

    public @NonNull TracePropertyRegionAnalysis addConsumer(@NonNull PropertyDatum tracePropertyDatum, @NonNull RegionAnalysis consumer) {
        TracePropertyRegionAnalysis tracePropertyAnalysis = this.lazyCreateTracePropertyAnalysis(tracePropertyDatum);
        tracePropertyAnalysis.addConsumer(consumer);
        return tracePropertyAnalysis;
    }

    public @NonNull TraceClassRegionAnalysis addProducer(@NonNull ClassDatum classDatum, @NonNull RegionAnalysis producer) {
        TraceClassRegionAnalysis traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
        traceClassAnalysis.addProducer(producer);
        return traceClassAnalysis;
    }

    public @NonNull TracePropertyRegionAnalysis addProducer(@NonNull PropertyDatum tracePropertyDatum, @NonNull RegionAnalysis producer) {
        TracePropertyRegionAnalysis tracePropertyAnalysis = this.lazyCreateTracePropertyAnalysis(tracePropertyDatum);
        tracePropertyAnalysis.addProducer(producer);
        return tracePropertyAnalysis;
    }

    public void analyzeMappingRegions() {
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)this.transformation)) {
            RuleAnalysis ruleAnalysis = this.getRuleAnalysis(asRule);
            ruleAnalysis.analyzeMappingRegion();
        }
        CompleteModel completeModel = this.environmentFactory.getCompleteModel();
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)this.transformation)) {
            for (Package asPackage : QVTbaseUtil.getUsedPackages((TypedModel)typedModel)) {
                CompletePackage completePackage = completeModel.getCompletePackage(asPackage);
                this.scheduleManager.analyzeCompletePackage(typedModel, completePackage);
            }
        }
    }

    public void analyzeSourceModel() {
        for (RuleAnalysis ruleAnalysis : this.rule2ruleAnalysis.values()) {
            ruleAnalysis.analyzeSourceModel();
        }
    }

    public @Nullable TraceClassRegionAnalysis basicGetTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        return this.classDatum2traceClassAnalysis.get(classDatum);
    }

    public @Nullable RootPartitionAnalysis basicGetRootPartitionAnalysis() {
        return this.rootPartitionAnalysis;
    }

    public @Nullable TracePropertyRegionAnalysis basicGetTracePropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        assert (QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum) != this.oclContainerProperty);
        return this.propertyDatum2tracePropertyAnalysis.get(propertyDatum);
    }

    protected void computeCyclicRegionsAnalysis(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        this.cyclesRegionAnalysis = new CyclicRegionsAnalysis(regionAnalyses);
    }

    protected void computeTraceClassDiscrimination() throws CompilerChainException {
        for (TraceClassRegionAnalysis traceClassAnalysis : this.classDatum2traceClassAnalysis.values()) {
            traceClassAnalysis.discriminate();
        }
    }

    public void computeTraceClassInheritance() {
        TraceClassRegionAnalysis superTraceClassRegionAnalysis;
        ClassDatum classDatum;
        HashSet<@NonNull ClassDatum> missingClassDatums = new HashSet<ClassDatum>();
        for (TraceClassRegionAnalysis subTraceClassRegionAnalysis : this.classDatum2traceClassAnalysis.values()) {
            classDatum = subTraceClassRegionAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum || (superTraceClassRegionAnalysis = this.classDatum2traceClassAnalysis.get(superClassDatum)) != null) continue;
                missingClassDatums.add(superClassDatum);
            }
        }
        for (ClassDatum missingClassDatum : missingClassDatums) {
            this.lazyCreateTraceClassAnalysis(missingClassDatum);
        }
        for (TraceClassRegionAnalysis subTraceClassRegionAnalysis : this.classDatum2traceClassAnalysis.values()) {
            classDatum = subTraceClassRegionAnalysis.getClassDatum();
            for (ClassDatum superClassDatum : QVTscheduleUtil.getSuperClassDatums((ClassDatum)classDatum)) {
                if (superClassDatum == classDatum) continue;
                superTraceClassRegionAnalysis = this.classDatum2traceClassAnalysis.get(superClassDatum);
                assert (superTraceClassRegionAnalysis != null);
                superTraceClassRegionAnalysis.addSubTraceClassAnalysis(subTraceClassRegionAnalysis);
                subTraceClassRegionAnalysis.addSuperTraceClassAnalysis(superTraceClassRegionAnalysis);
            }
        }
    }

    protected @NonNull TraceClassRegionAnalysis createTraceClassAnalysis(@NonNull ClassDatum traceClassDatum) {
        return new TraceClassRegionAnalysis(this, traceClassDatum);
    }

    protected @NonNull TracePropertyRegionAnalysis createTracePropertyAnalysis(@NonNull TraceClassRegionAnalysis traceClassAnalysis, @NonNull PropertyDatum tracePropertyDatum) {
        return new TracePropertyRegionAnalysis(this, traceClassAnalysis, tracePropertyDatum);
    }

    public @Nullable RegionAnalysis basicGetRegionAnalysis(@NonNull Region region) {
        return this.region2regionAnalysis.get(region);
    }

    public @NonNull Iterable<@NonNull RuleRegion> gatherRuleRegions() {
        ArrayList<@NonNull RuleRegion> ruleRegions = new ArrayList<RuleRegion>();
        for (RuleAnalysis ruleAnalysis : this.rule2ruleAnalysis.values()) {
            ruleAnalysis.gatherRuleRegions(ruleRegions);
        }
        Collections.sort(ruleRegions, NameUtil.NAMEABLE_COMPARATOR);
        return ruleRegions;
    }

    public @Nullable List<@NonNull Region> getCorollaryOf(@NonNull NavigableEdge edge) {
        return this.corollaryProperty2regions.get(edge.getProperty());
    }

    public String getName() {
        return this.transformation.getName();
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = new RegionAnalysis(this, region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull RootPartitionAnalysis getRootPartitionAnalysis() {
        return (RootPartitionAnalysis)ClassUtil.nonNullState((Object)this.rootPartitionAnalysis);
    }

    public @NonNull RuleAnalysis getRuleAnalysis(@NonNull Rule rule) {
        return (RuleAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)this.rule2ruleAnalysis.get(rule))));
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull RootRegion getRootRegion() {
        return this.rootRegion;
    }

    public @NonNull TraceClassRegionAnalysis getTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        return (TraceClassRegionAnalysis)ClassUtil.nonNullState((Object)this.classDatum2traceClassAnalysis.get(classDatum));
    }

    public @NonNull TracePropertyRegionAnalysis getTracePropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        assert (QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum) != this.oclContainerProperty);
        return (TracePropertyRegionAnalysis)ClassUtil.nonNullState((Object)this.propertyDatum2tracePropertyAnalysis.get(propertyDatum));
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull TransformationAnalysis2TracePackage getTransformationAnalysis2TracePackage() {
        TransformationAnalysis2TracePackage transformationAnalysis2tracePackage2 = this.transformationAnalysis2tracePackage;
        if (transformationAnalysis2tracePackage2 == null) {
            this.transformationAnalysis2tracePackage = transformationAnalysis2tracePackage2 = this.scheduleManager.createTransformationAnalysis2TracePackage(this);
        }
        return transformationAnalysis2tracePackage2;
    }

    public boolean isCorollary(@NonNull Node node) {
        block3: {
            block2: {
                if (!node.isPredicated()) break block2;
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    List<Region> corollaryOf;
                    if (!edge.isPredicated() || edge.isSecondary() || !(edge instanceof NavigableEdge) || (corollaryOf = this.getCorollaryOf((NavigableEdge)edge)) == null) continue;
                    return true;
                }
                break block3;
            }
            if (!node.isRealized()) break block3;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                List<Region> corollaryOf;
                if (!edge.isRealized() || edge.isSecondary() || !(edge instanceof NavigableEdge) || (corollaryOf = this.getCorollaryOf((NavigableEdge)edge)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic(@NonNull TraceClassRegionAnalysis traceClassAnalysis) {
        assert (this.cyclesRegionAnalysis != null);
        return this.cyclesRegionAnalysis.isCyclic(traceClassAnalysis);
    }

    public boolean isCyclic(@NonNull RegionAnalysis regionAnalysis) {
        assert (this.cyclesRegionAnalysis != null);
        return this.cyclesRegionAnalysis.isCyclic(regionAnalysis);
    }

    public boolean isCyclic(@NonNull ClassDatum traceClassDatum) {
        TraceClassRegionAnalysis traceClassAnalysis = this.basicGetTraceClassAnalysis(traceClassDatum);
        if (traceClassAnalysis == null) {
            return false;
        }
        return traceClassAnalysis.isCyclic();
    }

    private @NonNull TraceClassRegionAnalysis lazyCreateTraceClassAnalysis(@NonNull ClassDatum classDatum) {
        TraceClassRegionAnalysis traceClassAnalysis = this.classDatum2traceClassAnalysis.get(classDatum);
        if (traceClassAnalysis == null) {
            traceClassAnalysis = this.createTraceClassAnalysis(classDatum);
            this.classDatum2traceClassAnalysis.put(classDatum, traceClassAnalysis);
        }
        return traceClassAnalysis;
    }

    private @NonNull TracePropertyRegionAnalysis lazyCreateTracePropertyAnalysis(@NonNull PropertyDatum tracePropertyDatum) {
        TracePropertyRegionAnalysis tracePropertyAnalysis = this.propertyDatum2tracePropertyAnalysis.get(tracePropertyDatum);
        if (tracePropertyAnalysis == null) {
            ClassDatum classDatum = QVTscheduleUtil.getOwningClassDatum((PropertyDatum)tracePropertyDatum);
            TraceClassRegionAnalysis traceClassAnalysis = this.lazyCreateTraceClassAnalysis(classDatum);
            tracePropertyAnalysis = this.createTracePropertyAnalysis(traceClassAnalysis, tracePropertyDatum);
            this.propertyDatum2tracePropertyAnalysis.put(tracePropertyDatum, tracePropertyAnalysis);
        }
        return tracePropertyAnalysis;
    }

    public @NonNull PartitionedTransformationAnalysis partition(@NonNull ProblemHandler problemHandler, @NonNull Iterable<? extends @NonNull Region> activeRegions) throws CompilerChainException {
        assert (this.rootPartitionAnalysis == null);
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = TransformationPartitioner.partition(this, problemHandler, activeRegions);
        this.rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        return partitionedTransformationAnalysis;
    }

    public void prePartition() throws CompilerChainException {
        if (this.scheduleManager.needsDiscrimination()) {
            this.computeTraceClassDiscrimination();
        }
        this.computeTraceClassInheritance();
        this.computeCyclicRegionsAnalysis(this.region2regionAnalysis.values());
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }
}

