/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class GlobalPredicatePartitionFactory
extends AbstractSimplePartitionFactory {
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public GlobalPredicatePartitionFactory(@NonNull MappingPartitioner mappingPartitioner) {
        super(mappingPartitioner);
    }

    @Override
    public @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        String name = this.computeName("global");
        Iterable<@NonNull Node> executionNodes = this.mappingPartitioner.getExecutionNodes();
        List<@NonNull Node> headNodes = this.mappingPartitioner.getTraceNodes();
        BasicPartition partition = this.createBasicPartition(name, headNodes);
        int partitionNumber = ((RuleRegion)this.region).getNextPartitionNumber();
        BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, partition, reachabilityForest, "\u00abglobal\u00bb", "_p" + partitionNumber);
        this.initializePartition(basicPartitionAnalysis, executionNodes);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)partition, null);
        }
        return basicPartitionAnalysis;
    }

    protected void initializePartition(@NonNull BasicPartitionAnalysis partitionAnalysis, @NonNull Iterable<@NonNull Node> executionNodes) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        if (this.hasSynthesizedTrace) {
            for (Node traceNode : executionNodes) {
                this.addNode(partition, traceNode, Role.PREDICATED);
            }
            Node dispatchNode = this.mappingPartitioner.basicGetDispatchNode();
            if (dispatchNode != null) {
                assert (dispatchNode.isPredicated());
                this.addNode(partition, dispatchNode);
            }
        } else {
            this.resolveTraceNodes(partition);
        }
        if (this.hasSynthesizedTrace) {
            for (Node whenNode : this.mappingPartitioner.getPredicatedWhenNodes()) {
                if (this.mappingPartitioner.hasCheckedNode(whenNode)) continue;
                this.addNode(partition, whenNode);
            }
        } else {
            this.resolvePredicatedMiddleNodes(partition);
            this.resolvePredicatedOutputNodes(partitionAnalysis);
        }
        this.resolveSuccessNodes(partition, executionNodes);
        this.resolveConstantOutputNodes(partition);
        this.resolvePrecedingNodes(partitionAnalysis);
        this.resolveEdges(partitionAnalysis);
    }

    private boolean isDownstreamFromCorollary(@NonNull BasicPartitionAnalysis partitionAnalysis, @NonNull Node node) {
        if (this.transformationAnalysis.isCorollary(node)) {
            return true;
        }
        if (node.isOperation()) {
            boolean allReachable = true;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Node sourceNode;
                if (!edge.isComputation() || !this.isDownstreamFromCorollary(partitionAnalysis, sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) continue;
                allReachable = false;
                break;
            }
            if (allReachable) {
                return false;
            }
        }
        for (Node precedingNode : partitionAnalysis.getPredecessors(node)) {
            if (this.isDownstreamFromCorollary(partitionAnalysis, precedingNode)) continue;
            return false;
        }
        return true;
    }

    protected void resolveConstantOutputNodes(@NonNull BasicPartition partition) {
        for (Node constantOutputNode : this.mappingPartitioner.getConstantOutputNodes()) {
            if (this.mappingPartitioner.hasCheckedNode(constantOutputNode)) continue;
            this.addNode(partition, constantOutputNode);
        }
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        boolean hasRealizedEdge;
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) {
            if (this.mappingPartitioner.hasRealizedEdge(edge)) {
                edgeRole = Role.PREDICATED;
            }
        } else if (edgeRole == Role.PREDICATED && edge instanceof SuccessEdge && !(hasRealizedEdge = this.mappingPartitioner.hasRealizedEdge(edge))) {
            edgeRole = Role.SPECULATED;
        }
        return edgeRole;
    }

    protected void resolvePredicatedMiddleNodes(@NonNull BasicPartition partition) {
        for (Node node : this.mappingPartitioner.getPredicatedMiddleNodes()) {
            if (partition.hasNode(node) || !node.isMatched()) continue;
            Role nodeRole = QVTscheduleUtil.getNodeRole((Node)node);
            this.addNode(partition, node, nodeRole);
        }
    }

    protected void resolvePredicatedOutputNodes(@NonNull BasicPartitionAnalysis partitionAnalysis) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        for (Node node : this.mappingPartitioner.getPredicatedOutputNodes()) {
            if (partition.hasNode(node) || this.transformationAnalysis.isCorollary(node) || this.isDownstreamFromCorollary(partitionAnalysis, node)) continue;
            this.addNode(partition, node, QVTscheduleUtil.getNodeRole((Node)node));
        }
    }

    protected void resolveSuccessNodes(@NonNull BasicPartition partition, @NonNull Iterable<@NonNull Node> executionNodes) {
        for (Node traceNode : executionNodes) {
            Node localSuccessNode = this.mappingPartitioner.basicGetLocalSuccessNode(traceNode);
            if (localSuccessNode != null) {
                this.addNode(partition, localSuccessNode, Role.CONSTANT_SUCCESS_TRUE);
            } else {
                this.scheduleManager.addPartitionError((Partition)partition, "Missing localSuccess", new Object[0]);
            }
            Node globalSuccessNode = this.mappingPartitioner.basicGetGlobalSuccessNode(traceNode);
            if (globalSuccessNode != null) {
                this.addNode(partition, globalSuccessNode, Role.REALIZED);
                continue;
            }
            this.scheduleManager.addPartitionError((Partition)partition, "Missing globalSuccess", new Object[0]);
        }
    }

    protected void resolveTraceNodes(@NonNull BasicPartition partition) {
        List<@NonNull Node> traceNodes = this.mappingPartitioner.getTraceNodes();
        for (Node traceNode : traceNodes) {
            this.addNode(partition, traceNode, Role.SPECULATED);
        }
        for (Node traceNode : traceNodes) {
            for (NavigableEdge edge : traceNode.getNavigableEdges()) {
                if (!this.mappingPartitioner.hasRealizedEdge((Edge)edge)) continue;
                this.tracedInputNodes.add(edge.getEdgeTarget());
            }
            Node globalSuccessNode = this.mappingPartitioner.basicGetGlobalSuccessNode(traceNode);
            if (globalSuccessNode == null) continue;
            this.addNode(partition, globalSuccessNode, Role.REALIZED);
        }
    }
}

