/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.KeyPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class HeadNodeGroup
implements Nameable {
    private final @NonNull List<@NonNull Node> headGroupNodes;
    private Set<@NonNull Node> uniqueNodes = null;

    public HeadNodeGroup(@NonNull List<@NonNull Node> headGroupNodes) {
        assert (!headGroupNodes.isEmpty());
        this.headGroupNodes = headGroupNodes;
    }

    private boolean accumulateReachableTargets(@NonNull Deque<@NonNull Node> workList) {
        Node targetNode;
        Node sourceNode = workList.removeFirst();
        assert (sourceNode.isMatched());
        boolean gotOne = false;
        for (Edge source2targetEdge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
            targetNode = QVTscheduleUtil.getTargetNode((Edge)source2targetEdge);
            if (!targetNode.isMatched() || !this.canBeSameGroup(sourceNode, source2targetEdge) || this.uniqueNodes.contains(targetNode)) continue;
            if (source2targetEdge.isCast()) {
                this.uniqueNodes.add(targetNode);
                workList.add(targetNode);
                gotOne = true;
                continue;
            }
            if (source2targetEdge.isPredicate()) {
                this.uniqueNodes.add(targetNode);
                gotOne = true;
                continue;
            }
            if (source2targetEdge.isNavigation()) {
                if (source2targetEdge.isPartial()) continue;
                this.uniqueNodes.add(targetNode);
                workList.add(targetNode);
                gotOne = true;
                continue;
            }
            if (!source2targetEdge.isComputation()) continue;
            boolean allArgumentsReachable = true;
            for (Edge argumentEdge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                Node argumentNode;
                if (argumentEdge == source2targetEdge || !argumentEdge.isComputation() || !(argumentNode = QVTscheduleUtil.getSourceNode((Edge)argumentEdge)).isMatched() || argumentNode.isConstant() || this.uniqueNodes.contains(argumentNode)) continue;
                allArgumentsReachable = false;
                break;
            }
            if (!allArgumentsReachable) continue;
            this.uniqueNodes.add(targetNode);
            workList.add(targetNode);
            gotOne = true;
        }
        for (Edge target2sourceEdge : QVTscheduleUtil.getIncomingEdges((Node)sourceNode)) {
            if (!(target2sourceEdge instanceof KeyPartEdge)) continue;
            targetNode = QVTscheduleUtil.getSourceNode((Edge)target2sourceEdge);
            this.uniqueNodes.add(targetNode);
            if (targetNode.isMatched()) {
                workList.add(targetNode);
            }
            gotOne = true;
        }
        return gotOne;
    }

    private void accumulateReachables() {
        ArrayDeque<@NonNull Node> workList = new ArrayDeque<Node>(this.headGroupNodes);
        this.uniqueNodes = new HashSet<Node>(this.headGroupNodes);
        while (!workList.isEmpty()) {
            this.accumulateReachableTargets(workList);
        }
    }

    public void appendTo(@NonNull StringBuilder s) {
        s.append("heads:");
        ArrayList<@NonNull Node> nodeList1 = new ArrayList<Node>(this.headGroupNodes);
        Collections.sort(nodeList1, NameUtil.NAMEABLE_COMPARATOR);
        for (Node node : nodeList1) {
            s.append(" ");
            s.append(node.getName());
        }
        if (this.uniqueNodes != null) {
            ArrayList<@NonNull Node> nodeList2 = new ArrayList<Node>(this.uniqueNodes);
            nodeList2.removeAll(this.headGroupNodes);
            if (nodeList2.size() > 0) {
                Collections.sort(nodeList2, NameUtil.NAMEABLE_COMPARATOR);
                s.append(", to-ones:");
                for (Node node : nodeList2) {
                    s.append(" ");
                    s.append(node.getName());
                }
            }
        }
    }

    protected abstract boolean canBeSameGroup(@NonNull Node var1, @NonNull Edge var2);

    public @NonNull Iterable<@NonNull Node> getHeadNodes() {
        return this.headGroupNodes;
    }

    public @NonNull Node getPreferredHeadNode(@Nullable Iterable<@NonNull Node> preferredHeadNodes) {
        if (preferredHeadNodes != null) {
            for (Node node : this.headGroupNodes) {
                if (!Iterables.contains(preferredHeadNodes, (Object)node)) continue;
                return node;
            }
        }
        return this.headGroupNodes.get(0);
    }

    private @NonNull Set<@NonNull Node> getToOneSet() {
        Set<@NonNull Node> toOneSet2 = this.uniqueNodes;
        if (toOneSet2 == null) {
            this.accumulateReachables();
            toOneSet2 = this.uniqueNodes;
            assert (toOneSet2 != null);
        }
        return toOneSet2;
    }

    public boolean isDeriveableFrom(@NonNull HeadNodeGroup thatHeadNodeGroup) {
        return thatHeadNodeGroup.getToOneSet().containsAll(this.headGroupNodes);
    }

    public boolean isThis() {
        for (Node headNode : this.headGroupNodes) {
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)headNode);
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            if (!typedModel.isIsThis()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.headGroupNodes.iterator().next().getOwningRegion());
        s.append("\n\theads:");
        for (Node node : this.headGroupNodes) {
            s.append("\n\t\t");
            s.append(node);
        }
        if (this.uniqueNodes != null) {
            s.append("\n\tto-ones:");
            for (Node node : this.uniqueNodes) {
                s.append("\n\t\t");
                s.append(node);
            }
        }
        return s.toString();
    }
}

