/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.expressions.LiteralExp;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.IParseResult;

public abstract class CommonDocumentationProvider
implements IDocumentationProvider,
ILanguageService {
    public static String getSubstring(IParseResult parseResult, CSTNode cstNode) {
        return parseResult.getTextRange(cstNode.getStartOffset(), cstNode.getEndOffset() - cstNode.getStartOffset() + 1);
    }

    protected String getASTDocumentation(Object node) {
        if (node instanceof LiteralExp) {
            return String.valueOf(EcoreUtils.formatName((Object)((EObject)node).eClass())) + " : " + node.toString();
        }
        if (node instanceof EObject) {
            return String.valueOf(EcoreUtils.formatName((Object)((EObject)node).eClass())) + " : " + EcoreUtils.formatQualifiedName((Object)node);
        }
        return null;
    }

    protected String getCSTDocumentation(CSTNode cstNode, ICommonParseResult parseResult) {
        ICommonParseController.TokenKind tokenKind = parseResult.getParseController().getTokenKind(this.getTokenKindForNode(cstNode));
        switch (tokenKind) {
            case IDENTIFIER: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is an identifier";
            }
            case INTEGER: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is an integer number";
            }
            case REAL: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is a floating point number";
            }
            case KEYWORD: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is a keyword";
            }
            case LINE_COMMENT: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is a line comment";
            }
            case PARAGRAPH_COMMENT: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is a paragraph comment";
            }
            case STRING: {
                return "'" + CommonDocumentationProvider.getSubstring(parseResult, cstNode) + "' is a string";
            }
        }
        return null;
    }

    public String getDocumentation(Object node, IParseController controller) {
        if (node == null) {
            return null;
        }
        if (node instanceof CSTNode) {
            CommonParseResult parseResult = ((CommonParseController)controller).getCurrentResult();
            if (parseResult == null) {
                return null;
            }
            return this.getCSTDocumentation((CSTNode)node, parseResult);
        }
        return this.getASTDocumentation(node);
    }

    public int getTokenKindForNode(CSTNode node) {
        return node.getEndToken().getKind();
    }
}

