/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.operations;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.IUndoableOperationHelper;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.operations.AbstractUndoableOperationHelper;
import org.eclipse.qvt.declarative.editor.ui.paged.PagedEditor;

public abstract class OperationHistoryListener
implements IOperationHistoryListener {
    public static TracingOption showApplicableOperation = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "operation/show/applicable");
    public static TracingOption showInapplicableOperation = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "operation/show/inapplicable");
    public static TracingOption showDirty = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "operation/show/dirty");
    protected IUndoableOperationHelper undoableOperationHelper = new AbstractUndoableOperationHelper();
    protected final PagedEditor pagedEditor;
    protected final ObjectUndoContext undoContext;
    private boolean isDirty = false;
    private boolean isDirtyPage = false;

    public static String getEventTypeString(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 1: {
                return "ABOUT_TO_EXECUTE";
            }
            case 3: {
                return "ABOUT_TO_UNDO";
            }
            case 6: {
                return "OPERATION_CHANGED";
            }
            case 7: {
                return "OPERATION_NOT_OK";
            }
            case 5: {
                return "OPERATION_ADDED";
            }
            case 2: {
                return "ABOUT_TO_REDO";
            }
            case 8: {
                return "OPERATION_REMOVED";
            }
            case 10: {
                return "UNDONE";
            }
            case 4: {
                return "DONE";
            }
            case 9: {
                return "REDONE";
            }
        }
        return "UNKNOWN";
    }

    public static String getOperationString(OperationHistoryEvent event) {
        IUndoableOperation operation = event.getOperation();
        StringBuilder s = new StringBuilder();
        s.append(OperationHistoryListener.getEventTypeString(event));
        s.append(" '");
        s.append(operation.getLabel());
        String separator = "' ";
        IUndoContext[] iUndoContextArray = operation.getContexts();
        int n = iUndoContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoContext undoContext = iUndoContextArray[n2];
            s.append(separator);
            s.append("[");
            s.append(undoContext.toString());
            s.append("]");
            separator = "+";
            ++n2;
        }
        String operationText = s.toString();
        return operationText;
    }

    public OperationHistoryListener(PagedEditor pagedEditor) {
        this.pagedEditor = pagedEditor;
        this.undoableOperationHelper = this.createUndoableOperationHelper();
        this.undoContext = this.createUndoContext();
    }

    protected ObjectUndoContext createUndoContext() {
        return new ObjectUndoContext((Object)this.pagedEditor, this.pagedEditor.toString());
    }

    protected IUndoableOperationHelper createUndoableOperationHelper() {
        return new AbstractUndoableOperationHelper();
    }

    public ObjectUndoContext getUndoContext() {
        return this.undoContext;
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoableOperation operation = event.getOperation();
        if (!operation.hasContext((IUndoContext)this.undoContext)) {
            if (showInapplicableOperation.isActive()) {
                showInapplicableOperation.println(String.valueOf(this.pagedEditor.toString()) + " " + OperationHistoryListener.getOperationString(event));
            }
            return;
        }
        if (showApplicableOperation.isActive()) {
            showApplicableOperation.println(OperationHistoryListener.getOperationString(event));
        }
        switch (event.getEventType()) {
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 5: {
                if (this.isDirtyPage || !this.undoableOperationHelper.isDirty(operation)) break;
                this.setDirtyPage();
                break;
            }
            case 8: 
            case 10: {
                if (this.isDirty && this.undoableOperationHelper.isDirty(operation)) {
                    this.refreshDirty(event);
                    break;
                }
                if (!this.isDirtyPage || !this.undoableOperationHelper.isPageChange(operation)) break;
                this.refreshDirty(event);
                break;
            }
            case 4: 
            case 9: {
                this.setDone(operation);
                if (this.isDirty && this.undoableOperationHelper.isPageSave(operation)) {
                    this.resetDirty();
                    break;
                }
                if (!this.isDirtyPage || !this.undoableOperationHelper.isPageChange(operation)) break;
                this.resetDirtyPage();
            }
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isDirtyPage() {
        return this.isDirtyPage;
    }

    protected void refreshDirty(OperationHistoryEvent event) {
        boolean stillDirty = false;
        boolean gotPageCommand = false;
        IOperationHistory operationHistory = event.getHistory();
        IUndoableOperation[] operations = operationHistory.getUndoHistory((IUndoContext)this.getUndoContext());
        int i = operations.length;
        while (--i >= 0) {
            IUndoableOperation op = operations[i];
            if (this.undoableOperationHelper.isPageSave(op)) break;
            if (this.undoableOperationHelper.isPageChange(op)) {
                gotPageCommand = true;
            }
            if (op.canUndo() && !this.undoableOperationHelper.isDirty(op)) continue;
            stillDirty = true;
            break;
        }
        if (!stillDirty) {
            this.resetDirty();
        } else if (gotPageCommand) {
            this.resetDirtyPage();
        }
    }

    protected void resetDirty() {
        if (this.isDirty && showDirty.isActive()) {
            showDirty.println(String.valueOf(this.pagedEditor.toString()) + " resetDirty");
        }
        this.isDirty = false;
        this.isDirtyPage = false;
    }

    protected void resetDirtyPage() {
        this.isDirtyPage = false;
    }

    protected void setDirtyPage() {
        if (!this.isDirty && showDirty.isActive()) {
            showDirty.println(String.valueOf(this.pagedEditor.toString()) + " setDirty");
        }
        this.isDirty = true;
        this.isDirtyPage = true;
    }

    protected void setDone(IUndoableOperation operation) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + String.valueOf((Object)this.pagedEditor) + ")";
    }
}

