/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtrelation.environment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.qvt.declarative.ecore.QVTBase.Function;
import org.eclipse.qvt.declarative.ecore.QVTBase.FunctionParameter;
import org.eclipse.qvt.declarative.ecore.QVTBase.QVTBaseFactory;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.parser.AbstractQVTAnalyzer;
import org.eclipse.qvt.declarative.parser.plugin.QVTParserPlugin;
import org.eclipse.qvt.declarative.parser.qvtrelation.cst.QueryCS;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrEnvironment;
import org.eclipse.qvt.declarative.parser.qvtrelation.environment.QVTrTransformationEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTrQueryEnvironment
extends QVTrEnvironment<QVTrTransformationEnvironment, Function, QueryCS> {
    private Function query = null;
    private final String name;
    private final List<FunctionParameter> parameters = new ArrayList<FunctionParameter>();

    public QVTrQueryEnvironment(QVTrTransformationEnvironment env, QueryCS queryCS) {
        super(env, null, queryCS);
        EList names = AbstractQVTAnalyzer.createSequenceOfNames((PathNameCS)queryCS.getPathName(), null);
        if (names.size() != 1) {
            this.analyzerError("Unqualified name expected for query", "pathNameCS", queryCS.getPathName());
        }
        this.name = (String)names.get(names.size() - 1);
    }

    public void addParameter(FunctionParameter parameter) {
        this.parameters.add(parameter);
        this.addElement(parameter.getName(), (Variable)parameter, true);
    }

    protected void addedVariable(String name, Variable<EClassifier, EParameter> variable, boolean isExplicit) {
        if (variable == null) {
            return;
        }
        if (!(variable instanceof FunctionParameter)) {
            QVTParserPlugin.logError((String)("non-derived FunctionParameter in " + this.getClass().getName() + ".addedVariable"), null);
        }
    }

    public Function getQuery() {
        return this.query;
    }

    public Function resolveQuery(EClassifier returnType) {
        String message;
        RelationalTransformation transformation = this.getRelationalTransformation();
        Function match = this.findMatchingQuery((Transformation)transformation, this.name, this.parameters);
        if (match == null) {
            this.query = QVTBaseFactory.eINSTANCE.createFunction();
            this.initASTMapping(this.query, this.cst);
            ((QueryCS)this.cst).getPathName().setAst((Object)this.query);
            this.query.setName(this.name);
            this.query.setEType(returnType);
            this.query.getEParameters().addAll(this.parameters);
            transformation.getEOperations().add((Object)this.query);
            return this.query;
        }
        CSTNode cstNode = this.getCSTNode();
        if (match.getEType() != returnType) {
            message = "Inconsistent return type previously '" + this.formatType(match.getEType()) + "'";
            this.analyzerError(message, "queryCS", cstNode);
        }
        this.query = match;
        this.initASTMapping(this.query, this.cst);
        ((QueryCS)this.cst).getPathName().setAst((Object)this.query);
        if (((QueryCS)cstNode).getOclExpression() != null) {
            if (this.query.getQueryExpression() != null) {
                message = "Redefinition of '" + this.formatName(this.query) + "' ignored";
                this.analyzerError(message, "queryCS", cstNode);
            } else {
                this.query.getEParameters().clear();
                this.query.getEParameters().addAll(this.parameters);
            }
        }
        return null;
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        return ((QVTrTransformationEnvironment)this.getParentEnvironment()).tryLookupClassifier(names);
    }
}

