/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTBase.operations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.AbstractQVTBaseOperations;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.QVTBaseMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedModelOperations
extends AbstractQVTBaseOperations {
    public static TypedModelOperations INSTANCE = new TypedModelOperations();

    public boolean checkDependsOnIsAcyclic(TypedModel typedModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<TypedModel> allDependsOn = this.getAllDependsOn(typedModel);
        if (!allDependsOn.contains(typedModel)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)typedModel, context)};
        this.appendError(diagnostics, typedModel, QVTBaseMessages._UI_TypedModel_DependsOnContainsACycle, messageSubstitutions);
        return false;
    }

    public boolean checkDependsOnAreModelParameters(TypedModel typedModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Transformation transformation = typedModel.getTransformation();
        if (transformation == null) {
            return true;
        }
        boolean allOk = true;
        EList<TypedModel> modelParameters = transformation.getModelParameter();
        for (TypedModel dependsOn : typedModel.getDependsOn()) {
            if (modelParameters.contains(dependsOn)) continue;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)dependsOn, context), this.getObjectLabel((EObject)transformation, context)};
            this.appendError(diagnostics, typedModel, QVTBaseMessages._UI_TypedModel_DependsOnIsNotAModelParameter, messageSubstitutions);
            allOk = false;
        }
        return allOk;
    }

    public Set<TypedModel> computeAllDependsOn(List<TypedModel> typedModels, Set<TypedModel> allDependsOn) {
        for (TypedModel typedModel : typedModels) {
            if (!allDependsOn.add(typedModel)) continue;
            this.computeAllDependsOn((List<TypedModel>)typedModel.getDependsOn(), allDependsOn);
        }
        return allDependsOn;
    }

    public Set<TypedModel> getAllDependsOn(TypedModel typedModel) {
        return this.computeAllDependsOn((List<TypedModel>)typedModel.getDependsOn(), (Set<TypedModel>)new HashSet<TypedModel>());
    }

    public Set<EPackage> getDeclaredPackages(TypedModel typedModel) {
        HashSet<EPackage> declaredPackages = new HashSet<EPackage>((Collection<EPackage>)typedModel.getUsedPackage());
        Set<TypedModel> allDependsOn = this.getAllDependsOn(typedModel);
        for (TypedModel dependsOn : allDependsOn) {
            declaredPackages.addAll((Collection<EPackage>)dependsOn.getUsedPackage());
        }
        return declaredPackages;
    }
}

