/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.unparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.ecore.AssociationClassCallExp;
import org.eclipse.ocl.ecore.BooleanLiteralExp;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionItem;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.CollectionLiteralPart;
import org.eclipse.ocl.ecore.CollectionRange;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.FeatureCallExp;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.InvalidLiteralExp;
import org.eclipse.ocl.ecore.IterateExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.MessageExp;
import org.eclipse.ocl.ecore.NullLiteralExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.RealLiteralExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.StateExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TupleLiteralExp;
import org.eclipse.ocl.ecore.TupleLiteralPart;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.ecore.UnspecifiedValueExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.ecore.util.EcoreSwitch;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.qvt.declarative.ecore.utils.ClassUtils;
import org.eclipse.qvt.declarative.parser.unparser.UnparserWithReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCLExpressionUnparser
extends UnparserWithReflection<EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> {
    public static final String IF = "if";
    public static final String AT_PRE = "@pre";
    public static final String DOT_OR_ARROW = ". or ->";
    public static final String UNARY = "unary";
    public static final String IMPLIES = "implies";
    public static final String LOGICAL = "logical";
    public static final String CONDITIONAL = "conditional";
    public static final String RELATIONAL = "relational";
    public static final String ADDITIVE = "additive";
    public static final String MULTIPLICATIVE = "multiplicative";
    private EcoreSwitch<Object> expressionSwitch = null;
    private Stack<String> precedenceStack = new Stack();
    private Map<String, Integer> precedenceIndexes = new HashMap<String, Integer>();
    protected Map<String, String> infixOperators;
    protected Map<String, String> prefixOperators;

    public OCLExpressionUnparser(Resource resource, UMLReflection<?, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml) {
        super(resource, uml);
        List<String> precedenceKeys = this.buildPrecedenceMap();
        int precedence = 0;
        for (String precedenceKey : precedenceKeys) {
            this.precedenceIndexes.put(precedenceKey, precedence++);
        }
        this.precedenceIndexes.put(null, precedence);
        this.infixOperators = this.buildInfixOperators();
        this.prefixOperators = this.buildPrefixOperators();
    }

    protected Map<String, String> buildInfixOperators() {
        HashMap<String, String> inFixOperators = new HashMap<String, String>();
        inFixOperators.put("*", MULTIPLICATIVE);
        inFixOperators.put("/", MULTIPLICATIVE);
        inFixOperators.put("+", ADDITIVE);
        inFixOperators.put("-", ADDITIVE);
        inFixOperators.put("<", RELATIONAL);
        inFixOperators.put(">", RELATIONAL);
        inFixOperators.put("<=", RELATIONAL);
        inFixOperators.put(">=", RELATIONAL);
        inFixOperators.put("=", CONDITIONAL);
        inFixOperators.put("<>", CONDITIONAL);
        inFixOperators.put("and", LOGICAL);
        inFixOperators.put("or", LOGICAL);
        inFixOperators.put("xor", LOGICAL);
        inFixOperators.put(IMPLIES, IMPLIES);
        return inFixOperators;
    }

    protected Map<String, String> buildPrefixOperators() {
        HashMap<String, String> preFixOperators = new HashMap<String, String>();
        preFixOperators.put("-", UNARY);
        preFixOperators.put("not", UNARY);
        return preFixOperators;
    }

    protected List<String> buildPrecedenceMap() {
        ArrayList<String> precedenceKeys = new ArrayList<String>();
        precedenceKeys.add(AT_PRE);
        precedenceKeys.add(DOT_OR_ARROW);
        precedenceKeys.add(UNARY);
        precedenceKeys.add(MULTIPLICATIVE);
        precedenceKeys.add(ADDITIVE);
        precedenceKeys.add(IF);
        precedenceKeys.add(RELATIONAL);
        precedenceKeys.add(CONDITIONAL);
        precedenceKeys.add(LOGICAL);
        precedenceKeys.add(IMPLIES);
        return precedenceKeys;
    }

    protected EcoreSwitch<Object> createExpressionSwitch() {
        return new OCLExpressionUnparserSwitch();
    }

    protected Object doExpressionSwitch(EObject oclExpression) {
        if (oclExpression != null) {
            return this.expressionSwitch.doSwitch(oclExpression);
        }
        this.append("_null_expression_");
        return this;
    }

    protected Object doExpressionSwitch(ETypedElement oclExpression) {
        if (oclExpression != null) {
            return this.expressionSwitch.doSwitch((EObject)oclExpression);
        }
        this.append("_null_typed_element_");
        return this;
    }

    protected Object doExpressionsSwitch(List<org.eclipse.ocl.ecore.OCLExpression> oclExpressions, String separator) {
        if (oclExpressions != null && oclExpressions.size() > 0) {
            boolean first = true;
            for (org.eclipse.ocl.ecore.OCLExpression oclExpression : oclExpressions) {
                if (!first) {
                    this.append(separator);
                }
                this.doExpressionSwitch((ETypedElement)oclExpression);
                first = false;
            }
        }
        return this;
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.expressionSwitch == null) {
            this.expressionSwitch = this.createExpressionSwitch();
        }
    }

    protected String initialLower(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuffer result = new StringBuffer(name);
        result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        return result.toString();
    }

    protected void popPrecedence(String precedenceKey) {
        String innerKey = this.precedenceStack.pop();
        assert (innerKey == precedenceKey || innerKey.equals(precedenceKey));
        String outerKey = this.precedenceStack.isEmpty() ? null : this.precedenceStack.peek();
        Integer outerIndex = this.precedenceIndexes.get(outerKey);
        Integer innerIndex = this.precedenceIndexes.get(innerKey);
        if (outerKey != null && innerKey != null && (outerIndex == null || innerIndex == null || innerIndex >= outerIndex)) {
            this.append(")");
        }
    }

    protected void pushPrecedence(String precedenceKey) {
        String outerKey = this.precedenceStack.isEmpty() ? null : this.precedenceStack.peek();
        Integer outerIndex = this.precedenceIndexes.get(outerKey);
        Integer innerIndex = this.precedenceIndexes.get(precedenceKey);
        this.precedenceStack.push(precedenceKey);
        if (outerKey != null && precedenceKey != null && (outerIndex == null || innerIndex == null || innerIndex >= outerIndex)) {
            this.append("(");
        }
    }

    protected Object unparseAssociationClassCallExp(AssociationClassCallExp object) {
        if (object == null) {
            this.append("_null_association_class_");
        } else {
            this.pushPrecedence(".");
            this.doExpressionSwitch((EObject)object.getSource());
            this.append(".");
            this.appendName(this.initialLower(this.formatName(object.getReferredAssociationClass())));
            this.unparseIsMarkedPre((FeatureCallExp)object);
            List qualifiers = (List)ClassUtils.asClassUnchecked((Object)object.getQualifier(), null);
            if (qualifiers.size() > 0) {
                this.append("[");
                this.doExpressionSwitch((ETypedElement)qualifiers.get(0));
                this.append("]");
            }
            this.popPrecedence(".");
        }
        return this;
    }

    protected Object unparseBooleanLiteralExp(BooleanLiteralExp object) {
        if (object == null) {
            this.append("_null_boolean_");
        } else {
            this.append(object.getBooleanSymbol().toString());
        }
        return this;
    }

    protected Object unparseCollectionItem(CollectionItem object) {
        if (object == null) {
            this.append("_null_collection_item_");
        } else {
            this.doExpressionSwitch((EObject)object.getItem());
        }
        return this;
    }

    protected Object unparseCollectionLiteralExp(CollectionLiteralExp object) {
        if (object == null) {
            this.append("_null_collection_");
        } else {
            this.pushPrecedence(null);
            this.append(object.getKind().getLiteral());
            this.append("{");
            List parts = (List)ClassUtils.asClassUnchecked((Object)object.getPart(), null);
            if (parts.size() > 0) {
                this.append("\n");
                this.indent();
                boolean first = true;
                for (CollectionLiteralPart part : parts) {
                    if (!first) {
                        this.append(",\n");
                    }
                    this.doExpressionSwitch((ETypedElement)part);
                    first = false;
                }
                this.exdent();
                this.append("\n");
            }
            this.append("}");
            this.popPrecedence(null);
        }
        return this;
    }

    protected Object unparseCollectionRange(CollectionRange object) {
        if (object == null) {
            this.append("_null_collection_item_");
        } else {
            this.doExpressionSwitch((EObject)object.getFirst());
            this.append(" .. ");
            this.doExpressionSwitch((EObject)object.getLast());
        }
        return this;
    }

    protected Object unparseEnumLiteralExp(EnumLiteralExp object) {
        if (object == null) {
            this.append("_null_enum_");
        } else {
            this.appendQualifiedName(object.getReferredEnumLiteral());
        }
        return this;
    }

    protected Object unparseIfExp(IfExp object) {
        if (object == null) {
            this.append("_null_if_");
        } else {
            this.pushPrecedence(IF);
            this.append("if ");
            this.doExpressionSwitch((EObject)object.getCondition());
            this.append(" then ");
            this.doExpressionSwitch((EObject)object.getThenExpression());
            this.append(" else ");
            this.doExpressionSwitch((EObject)object.getElseExpression());
            this.append(" endif");
            this.popPrecedence(IF);
        }
        return this;
    }

    protected Object unparseIntegerLiteralExp(IntegerLiteralExp object) {
        if (object == null) {
            this.append("_null_integer_");
        } else {
            this.append(object.getIntegerSymbol().toString());
        }
        return this;
    }

    protected Object unparseInvalidLiteralExp(InvalidLiteralExp object) {
        if (object == null) {
            this.append("_null_invalid_");
        } else {
            this.append("OclInvalid");
        }
        return this;
    }

    protected void unparseIsMarkedPre(FeatureCallExp object) {
        if (object.isMarkedPre()) {
            this.append(AT_PRE);
        }
    }

    protected Object unparseIterateExp(IterateExp object) {
        if (object == null) {
            this.append("_null_iterate_");
        } else {
            this.pushPrecedence("->");
            this.doExpressionSwitch((EObject)object.getSource());
            this.append("->iterate(");
            this.pushPrecedence(null);
            List iterators = (List)ClassUtils.asClassUnchecked((Object)object.getIterator(), null);
            if (iterators != null && iterators.size() > 0) {
                boolean first = true;
                for (Variable iterator : iterators) {
                    if (!first) {
                        this.append(", ");
                    }
                    this.unparseVariable(iterator);
                    first = false;
                }
            }
            this.append("; ");
            this.unparseVariable((Variable)object.getResult());
            this.append(" |\n");
            this.indent();
            this.doExpressionSwitch((EObject)object.getBody());
            this.append(")");
            this.popPrecedence(null);
            this.exdent();
            this.popPrecedence("->");
        }
        return this;
    }

    protected Object unparseIteratorExp(IteratorExp object) {
        if (object == null) {
            this.append("_null_iterator_");
        } else {
            this.pushPrecedence("->");
            this.doExpressionSwitch((EObject)object.getSource());
            this.append("->");
            this.appendName(object);
            this.pushPrecedence(null);
            this.append("(");
            List iterators = (List)ClassUtils.asClassUnchecked((Object)object.getIterator(), null);
            if (iterators != null && iterators.size() > 0) {
                boolean first = true;
                for (Variable iterator : iterators) {
                    if (!first) {
                        this.append(", ");
                    }
                    this.unparseVariable(iterator);
                    first = false;
                }
            }
            this.append(" |\n");
            this.indent();
            this.doExpressionSwitch((EObject)object.getBody());
            this.append(")");
            this.popPrecedence(null);
            this.exdent();
            this.popPrecedence("->");
        }
        return this;
    }

    protected Object unparseLetExp(LetExp object) {
        if (object == null) {
            this.append("_null_let_");
        } else {
            this.pushPrecedence("let");
            this.append("let ");
            this.unparseVariable((Variable)object.getVariable());
            this.append(" in ");
            this.doExpressionSwitch((EObject)object.getIn());
            this.popPrecedence("let");
        }
        return this;
    }

    protected Object unparseMessageExp(MessageExp object) {
        if (object == null) {
            this.append("_null_message_");
        } else {
            this.doExpressionSwitch((EObject)object.getTarget());
            this.append(object.getType() instanceof CollectionType ? "^^" : "^");
            CallOperationAction calledOperation = (CallOperationAction)object.getCalledOperation();
            SendSignalAction sentSignal = (SendSignalAction)object.getSentSignal();
            if (calledOperation != null) {
                this.appendName(this.getOperation(calledOperation));
            } else if (sentSignal != null) {
                this.appendName(this.getSignal(sentSignal));
            }
            this.append("(");
            this.doExpressionsSwitch((List)ClassUtils.asClassUnchecked((Object)object.getArgument(), null), ", ");
            this.append(")");
        }
        return this;
    }

    protected Object unparseNullLiteralExp(NullLiteralExp object) {
        if (object == null) {
            this.append("_null_null_");
        } else {
            this.append("null");
        }
        return this;
    }

    protected Object unparseOperationCallExp(OperationCallExp object) {
        if (object == null) {
            this.append("'_null_operation_call_'");
        } else {
            org.eclipse.ocl.ecore.OCLExpression source = (org.eclipse.ocl.ecore.OCLExpression)object.getSource();
            EClassifier sourceType = source != null ? (EClassifier)source.getType() : null;
            boolean isCollection = sourceType instanceof CollectionType;
            EOperation eOperation = (EOperation)object.getReferredOperation();
            String operationName = eOperation != null ? eOperation.getName() : null;
            int operationArity = eOperation != null ? eOperation.getEParameters().size() : 0;
            boolean doneIt = false;
            if (!object.isMarkedPre()) {
                String precedenceKey;
                if (operationArity == 0) {
                    precedenceKey = this.prefixOperators.get(operationName);
                    if (precedenceKey != null) {
                        this.pushPrecedence(precedenceKey);
                        this.append(operationName);
                        if (source != null) {
                            this.append(" ");
                            this.doExpressionSwitch((ETypedElement)source);
                        }
                        this.popPrecedence(precedenceKey);
                        doneIt = true;
                    }
                } else if (operationArity == 1 && (precedenceKey = this.infixOperators.get(operationName)) != null) {
                    this.pushPrecedence(precedenceKey);
                    if (source != null) {
                        this.doExpressionSwitch((ETypedElement)source);
                        this.append(" ");
                    }
                    this.append(operationName);
                    this.append(" ");
                    this.doExpressionsSwitch((List)ClassUtils.asClassUnchecked((Object)object.getArgument(), null), ", ");
                    this.popPrecedence(precedenceKey);
                    doneIt = true;
                }
            }
            if (!doneIt) {
                String operationPrefixKey = isCollection ? "->" : ".";
                this.pushPrecedence(operationPrefixKey);
                if (source != null) {
                    this.doExpressionSwitch((ETypedElement)source);
                    this.append(operationPrefixKey);
                }
                this.appendName(eOperation);
                this.append("(");
                this.doExpressionsSwitch((List)ClassUtils.asClassUnchecked((Object)object.getArgument(), null), ", ");
                this.append(")");
                this.unparseIsMarkedPre((FeatureCallExp)object);
                this.popPrecedence(operationPrefixKey);
            }
        }
        return this;
    }

    protected Object unparsePropertyCallExp(PropertyCallExp object) {
        if (object == null) {
            this.append("_null_property_call_");
        } else {
            org.eclipse.ocl.ecore.OCLExpression source = (org.eclipse.ocl.ecore.OCLExpression)object.getSource();
            if (source != null) {
                this.doExpressionSwitch((ETypedElement)source);
                this.append(".");
            }
            this.appendName(object.getReferredProperty());
            this.unparseIsMarkedPre((FeatureCallExp)object);
            List qualifiers = (List)ClassUtils.asClassUnchecked((Object)object.getQualifier(), null);
            if (qualifiers != null && qualifiers.size() > 0) {
                this.append("[");
                this.doExpressionsSwitch(qualifiers, ", ");
                this.append("]");
            }
        }
        return this;
    }

    protected Object unparseRealLiteralExp(RealLiteralExp object) {
        if (object == null) {
            this.append("_null_real_");
        } else {
            this.append("'" + object.getRealSymbol().toString() + "'");
        }
        return this;
    }

    protected Object unparseStateExp(StateExp object) {
        if (object == null) {
            this.append("_null_state_");
        } else {
            this.appendName(object);
        }
        return this;
    }

    protected Object unparseStringLiteralExp(StringLiteralExp object) {
        if (object == null) {
            this.append("_null_string_");
        } else {
            this.append("'" + object.getStringSymbol().toString() + "'");
        }
        return this;
    }

    protected Object unparseTupleLiteralExp(TupleLiteralExp object) {
        if (object == null) {
            this.append("_null_tuple_");
        } else {
            this.pushPrecedence(null);
            this.append("Tuple{");
            boolean first = true;
            for (TupleLiteralPart part : (List)ClassUtils.asClassUnchecked((Object)object.getPart(), null)) {
                if (!first) {
                    this.append(", ");
                }
                this.unparseTupleLiteralPart(part);
                first = false;
            }
            this.append("}");
            this.popPrecedence(null);
        }
        return this;
    }

    protected Object unparseTupleLiteralPart(TupleLiteralPart object) {
        if (object == null) {
            this.append("_null_tuple_part_");
        } else {
            org.eclipse.ocl.ecore.OCLExpression value;
            Object type = object.getType();
            this.appendName(object);
            if (type != null) {
                this.append(" : ");
                this.appendName(type);
            }
            if ((value = (org.eclipse.ocl.ecore.OCLExpression)object.getValue()) != null) {
                this.append(" = ");
                this.doExpressionSwitch((ETypedElement)value);
            }
        }
        return this;
    }

    protected Object unparseTypeExp(TypeExp object) {
        if (object == null) {
            this.append("_null_type_");
        } else {
            this.appendQualifiedName(object.getReferredType());
        }
        return this;
    }

    protected Object unparseUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp object) {
        if (object == null) {
            this.append("_null_unlimited_natural_");
        } else if (object.isUnlimited()) {
            this.append("*");
        } else {
            this.append(object.getIntegerSymbol().toString());
        }
        return this;
    }

    protected Object unparseUnspecifiedValueExp(UnspecifiedValueExp object) {
        if (object == null) {
            this.append("_null_unspecified_");
        } else {
            this.append("?");
            Object type = object.getType();
            if (type != null && !(type instanceof VoidType)) {
                this.append(" : ");
                this.appendName(type);
            }
            this.append("OclInvalid");
        }
        return this;
    }

    protected Object unparseVariable(Variable variable) {
        if (variable == null) {
            this.append("_null_variable_");
        } else {
            OCLExpression init;
            this.appendName(variable);
            Object type = variable.getType();
            if (type instanceof EObject && ((EObject)type).eIsProxy()) {
                type = variable.getType();
            }
            if (type != null && !(type instanceof VoidType)) {
                this.append(" : ");
                this.appendQualifiedName(type);
            }
            if ((init = variable.getInitExpression()) != null) {
                this.append(" = ");
                this.doExpressionSwitch((EObject)init);
            }
        }
        return this;
    }

    protected Object unparseVariableExp(VariableExp object) {
        if (object == null) {
            this.append("_null_variable_exp_");
        } else {
            Variable variable = (Variable)object.getReferredVariable();
            if (variable != null) {
                this.appendName(variable);
            } else {
                this.appendName(object);
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OCLExpressionUnparserSwitch
    extends EcoreSwitch<Object> {
        protected OCLExpressionUnparserSwitch() {
        }

        public Object caseAssociationClassCallExp(AssociationClassCallExp object) {
            return OCLExpressionUnparser.this.unparseAssociationClassCallExp(object);
        }

        public Object caseBooleanLiteralExp(BooleanLiteralExp object) {
            return OCLExpressionUnparser.this.unparseBooleanLiteralExp(object);
        }

        public Object caseCollectionItem(CollectionItem object) {
            return OCLExpressionUnparser.this.unparseCollectionItem(object);
        }

        public Object caseCollectionLiteralExp(CollectionLiteralExp object) {
            return OCLExpressionUnparser.this.unparseCollectionLiteralExp(object);
        }

        public Object caseCollectionRange(CollectionRange object) {
            return OCLExpressionUnparser.this.unparseCollectionRange(object);
        }

        public Object caseEnumLiteralExp(EnumLiteralExp object) {
            return OCLExpressionUnparser.this.unparseEnumLiteralExp(object);
        }

        public Object caseIfExp(IfExp object) {
            return OCLExpressionUnparser.this.unparseIfExp(object);
        }

        public Object caseIntegerLiteralExp(IntegerLiteralExp object) {
            return OCLExpressionUnparser.this.unparseIntegerLiteralExp(object);
        }

        public Object caseInvalidLiteralExp(InvalidLiteralExp object) {
            return OCLExpressionUnparser.this.unparseInvalidLiteralExp(object);
        }

        public Object caseIterateExp(IterateExp object) {
            return OCLExpressionUnparser.this.unparseIterateExp(object);
        }

        public Object caseIteratorExp(IteratorExp object) {
            return OCLExpressionUnparser.this.unparseIteratorExp(object);
        }

        public Object caseLetExp(LetExp object) {
            return OCLExpressionUnparser.this.unparseLetExp(object);
        }

        public Object caseMessageExp(MessageExp object) {
            return OCLExpressionUnparser.this.unparseMessageExp(object);
        }

        public Object caseNullLiteralExp(NullLiteralExp object) {
            return OCLExpressionUnparser.this.unparseNullLiteralExp(object);
        }

        public Object caseOperationCallExp(OperationCallExp object) {
            return OCLExpressionUnparser.this.unparseOperationCallExp(object);
        }

        public Object casePropertyCallExp(PropertyCallExp object) {
            return OCLExpressionUnparser.this.unparsePropertyCallExp(object);
        }

        public Object caseRealLiteralExp(RealLiteralExp object) {
            return OCLExpressionUnparser.this.unparseRealLiteralExp(object);
        }

        public Object caseStateExp(StateExp object) {
            return OCLExpressionUnparser.this.unparseStateExp(object);
        }

        public Object caseStringLiteralExp(StringLiteralExp object) {
            return OCLExpressionUnparser.this.unparseStringLiteralExp(object);
        }

        public Object caseTupleLiteralExp(TupleLiteralExp object) {
            return OCLExpressionUnparser.this.unparseTupleLiteralExp(object);
        }

        public Object caseTupleLiteralPart(TupleLiteralPart object) {
            return OCLExpressionUnparser.this.unparseTupleLiteralPart(object);
        }

        public Object caseTypeExp(TypeExp object) {
            return OCLExpressionUnparser.this.unparseTypeExp(object);
        }

        public Object caseUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp object) {
            return OCLExpressionUnparser.this.unparseUnlimitedNaturalLiteralExp(object);
        }

        public Object caseUnspecifiedValueExp(UnspecifiedValueExp object) {
            return OCLExpressionUnparser.this.unparseUnspecifiedValueExp(object);
        }

        public Object caseVariable(Variable object) {
            return OCLExpressionUnparser.this.unparseVariable(object);
        }

        public Object caseVariableExp(VariableExp object) {
            return OCLExpressionUnparser.this.unparseVariableExp(object);
        }

        public Object defaultCase(EObject object) {
            OCLExpressionUnparser.this.append("\n***" + ((Object)((Object)this)).getClass().getSimpleName() + "-Unsupported-" + object.getClass().getSimpleName() + "***\n");
            return this;
        }
    }
}

