/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.NumericLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.BasicPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionRangeNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EnumLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.IfNode;
import org.eclipse.qvtd.pivot.qvtschedule.IteratorNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NullLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.NumericLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationParameterEdge;
import org.eclipse.qvtd.pivot.qvtschedule.OperationSelfEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PatternTypedNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternVariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowNode;
import org.eclipse.qvtd.pivot.qvtschedule.ShadowPartEdge;
import org.eclipse.qvtd.pivot.qvtschedule.StringLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessNode;
import org.eclipse.qvtd.pivot.qvtschedule.TypeLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeLibraryHelper;

public class QVTs2QVTiNodeVisitor
extends AbstractExtendingQVTscheduleVisitor<OCLExpression, BasicPartition2Mapping> {
    private static int depth = 0;
    protected final @NonNull QVTimperativeHelper helper;
    protected final @NonNull QVTruntimeLibraryHelper qvtruntimeLibraryHelper;
    protected final @NonNull Set<@NonNull Edge> resultEdges = new HashSet<Edge>();

    public QVTs2QVTiNodeVisitor(@NonNull BasicPartition2Mapping context) {
        super((Object)context);
        this.helper = context.getHelper();
        this.qvtruntimeLibraryHelper = context.getQVTruntimeLibraryHelper();
    }

    protected @NonNull CollectionRange doCollectionRangeNode(@NonNull CollectionRangeNode node) {
        Parameter rangeFirstParameter = this.qvtruntimeLibraryHelper.getRangeFirstParameter();
        Parameter rangeLastParameter = this.qvtruntimeLibraryHelper.getRangeLastParameter();
        OCLExpression asFirst = null;
        OCLExpression asLast = null;
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            Node expNode;
            if (!(edge instanceof OperationParameterEdge)) continue;
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            Parameter referredParameter = operationParameterEdge.getReferredParameter();
            if (referredParameter == rangeFirstParameter) {
                expNode = operationParameterEdge.getEdgeSource();
                asFirst = this.getExpressionInternal(expNode);
                continue;
            }
            if (referredParameter != rangeLastParameter) continue;
            expNode = operationParameterEdge.getEdgeSource();
            asLast = this.getExpressionInternal(expNode);
        }
        assert (asFirst != null && asLast != null);
        return this.helper.createCollectionRange(asFirst, asLast);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull LoopExp doIterationCallNode(@NonNull OperationCallNode node) {
        OperationParameterEdge operationParameterEdge;
        Parameter referredParameter;
        Parameter loopSourceParameter = this.qvtruntimeLibraryHelper.getLoopSourceParameter();
        Parameter loopBodyParameter = this.qvtruntimeLibraryHelper.getLoopBodyParameter();
        Parameter loopIteratorsParameter = this.qvtruntimeLibraryHelper.getLoopIteratorsParameter();
        Iteration referredIteration = (Iteration)QVTscheduleUtil.getReferredOperation((OperationCallNode)node);
        OCLExpression sourceExp = null;
        OCLExpression bodyExp = null;
        @NonNull List iterators = QVTbaseUtil.Internal.getOwnedIteratorsList((Iteration)referredIteration);
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            OperationParameterEdge operationParameterEdge2;
            Parameter referredParameter2;
            if (!(edge instanceof OperationParameterEdge) || (referredParameter2 = (operationParameterEdge2 = (OperationParameterEdge)edge).getReferredParameter()) != loopSourceParameter) continue;
            Node expNode = operationParameterEdge2.getEdgeSource();
            sourceExp = this.getExpressionInternal(expNode);
        }
        assert (sourceExp != null);
        Type sourceType = PivotUtil.getElementType((CollectionType)((CollectionType)PivotUtil.getType(sourceExp)));
        ArrayList<@NonNull IteratorVariable> variables = new ArrayList<IteratorVariable>(iterators.size());
        int i = 0;
        while (i < iterators.size()) {
            Parameter iterator = (Parameter)iterators.get(i);
            IteratorVariable variable = this.helper.createIteratorVariable(PivotUtil.getName((NamedElement)iterator), sourceType, sourceExp.isIsRequired());
            variables.add(variable);
            ++i;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopIteratorsParameter) continue;
            int index = operationParameterEdge.getParameterIndex();
            Node expNode = operationParameterEdge.getEdgeSource();
            ((BasicPartition2Mapping)this.context).addVariable(expNode, (VariableDeclaration)variables.get(index));
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopBodyParameter) continue;
            Node expNode = operationParameterEdge.getEdgeSource();
            bodyExp = this.getExpressionInternal(expNode);
        }
        assert (bodyExp != null);
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopIteratorsParameter) continue;
            Node expNode = operationParameterEdge.getEdgeSource();
            ((BasicPartition2Mapping)this.context).removeVariable(expNode);
        }
        return this.helper.createIteratorExp(sourceExp, referredIteration, variables, bodyExp);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull OperationCallExp doOperationCallNode(@NonNull OperationCallNode node) {
        Operation referredOperation = QVTscheduleUtil.getReferredOperation((OperationCallNode)node);
        VariableExp sourceExp = null;
        @NonNull List parameters = QVTbaseUtil.Internal.getOwnedParametersList((Operation)referredOperation);
        ArrayList<@Nullable OCLExpression> argExps = new ArrayList<OCLExpression>(parameters.size());
        int i = 0;
        while (i < parameters.size()) {
            argExps.add(null);
            ++i;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            QVTs2QVTiNodeVisitor expressionCreator;
            Node expNode;
            if (edge.isExpression() && edge instanceof OperationSelfEdge) {
                OperationSelfEdge operationSelfEdge = (OperationSelfEdge)edge;
                expNode = operationSelfEdge.getEdgeSource();
                expressionCreator = new QVTs2QVTiNodeVisitor((BasicPartition2Mapping)this.context);
                sourceExp = expressionCreator.getExpressionInternal(expNode);
                continue;
            }
            if (!(edge instanceof OperationParameterEdge)) continue;
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            expNode = operationParameterEdge.getEdgeSource();
            expressionCreator = new QVTs2QVTiNodeVisitor((BasicPartition2Mapping)this.context);
            OCLExpression nestedExp = expressionCreator.getExpressionInternal(expNode);
            int index = parameters.indexOf(operationParameterEdge.getReferredParameter());
            if (index < 0) continue;
            OCLExpression oldExpression = argExps.set(index, nestedExp);
            assert (oldExpression == null);
        }
        for (OCLExpression exp : argExps) {
            assert (exp != null);
        }
        if (sourceExp == null && referredOperation instanceof Function) {
            sourceExp = ((BasicPartition2Mapping)this.context).createContextVariableExp();
        }
        OperationCallExp operationCallExp = this.helper.createOperationCallExp(sourceExp, referredOperation, ClassUtil.nullFree(argExps));
        ((BasicPartition2Mapping)this.context).addTrace((Element)operationCallExp, (GraphStringBuilder.GraphElement)node);
        return operationCallExp;
    }

    protected @NonNull OCLExpression doPatternNode(@NonNull Node node) {
        Partition partition = ((BasicPartition2Mapping)this.context).getPartition();
        Role nodeRole = partition.getRole(node);
        assert (nodeRole != null);
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            VariableDeclaration referredVariable;
            OCLExpression clonedElement;
            if (!edge.isExpression() || !this.resultEdges.add(edge)) continue;
            Node expNode = edge.getEdgeSource();
            if (edge.isNavigable()) {
                Node sourceNode = expNode;
                Node targetNode = edge.getEdgeTarget();
                ReachabilityForest reachabilityForest = ((BasicPartition2Mapping)this.context).getReachabilityForest();
                int sourceCost = reachabilityForest.getCost(sourceNode);
                int targetCost = reachabilityForest.getCost(targetNode);
                if (targetCost < sourceCost) {
                    expNode = targetNode;
                }
            }
            if ((clonedElement = this.getExpressionInternal(expNode)) instanceof VariableExp && (referredVariable = ((VariableExp)clonedElement).getReferredVariable()) instanceof Variable) {
                ((BasicPartition2Mapping)this.context).addVariable(node, referredVariable);
            }
            return clonedElement;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            NavigationEdge navigationEdge;
            NavigationEdge oppositeEdge;
            assert (!edge.isCast());
            if (!edge.isNavigation() || !this.resultEdges.add(edge) || (oppositeEdge = (navigationEdge = (NavigationEdge)edge).getOppositeEdge()) != null && !this.resultEdges.add((Edge)oppositeEdge)) continue;
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
            Role edgeRole = partition.getRole(edge);
            if (!property.isIsMany() && edgeRole != Role.LOADED && edgeRole != Role.PREDICATED && edgeRole != Role.SPECULATED) continue;
            OCLExpression source = this.getExpressionInternal(edge.getEdgeSource());
            NavigationCallExp navigationCallExp = this.helper.createNavigationCallExp(source, property);
            ((BasicPartition2Mapping)this.context).addTrace((Element)navigationCallExp, (GraphStringBuilder.GraphElement)navigationEdge);
            return navigationCallExp;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isExpression()) continue;
            OCLExpression source = this.getExpressionInternal(edge.getEdgeSource());
            return source;
        }
        StringBuilder s = new StringBuilder();
        s.append("Unsupported pattern node without useable input edges");
        s.append("\n\tcontext: " + this.context);
        s.append("\n\tpartition: " + partition);
        s.append("\n\tnode: " + node);
        s.append("\n\tnodeRole: " + nodeRole);
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            s.append("\n\tincomingEdge: " + edge);
        }
        for (Edge edge : this.resultEdges) {
            s.append("\n\tresultEdge: " + edge);
        }
        throw new IllegalStateException(s.toString());
    }

    public @NonNull OCLExpression getExpression(@NonNull Node node) {
        assert (this.resultEdges.isEmpty());
        OCLExpression expression = this.getExpressionInternal(node);
        this.resultEdges.clear();
        return expression;
    }

    private @NonNull OCLExpression getExpressionInternal(@NonNull Node node) {
        if (++depth > 50) {
            throw new IllegalStateException();
        }
        try {
            VariableDeclaration variable = ((BasicPartition2Mapping)this.context).basicGetVariable(node);
            if (variable != null) {
                assert (!node.isNullLiteral());
                VariableExp variableExp = PivotUtil.createVariableExp((VariableDeclaration)variable);
                return variableExp;
            }
            if (node.isThis()) {
                VariableExp variableExp = ((BasicPartition2Mapping)this.context).createContextVariableExp();
                return variableExp;
            }
            OCLExpression expression = (OCLExpression)node.accept((Visitor)this);
            ((BasicPartition2Mapping)this.context).addTrace((Element)expression, (GraphStringBuilder.GraphElement)node);
            OCLExpression oCLExpression = expression;
            return oCLExpression;
        }
        finally {
            --depth;
        }
    }

    public @NonNull OCLExpression visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
    }

    public @NonNull BooleanLiteralExp visitBooleanLiteralNode(@NonNull BooleanLiteralNode node) {
        return this.helper.createBooleanLiteralExp(node.isBooleanValue());
    }

    public @NonNull CollectionLiteralExp visitCollectionLiteralNode(@NonNull CollectionLiteralNode node) {
        CollectionType asType = (CollectionType)node.getClassDatum().getPrimaryClass();
        final HashMap<@NonNull CollectionLiteralPart, @NonNull Integer> part2index = new HashMap<CollectionLiteralPart, Integer>();
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof CollectionPartEdge)) continue;
            CollectionPartEdge collectionPartEdge = (CollectionPartEdge)edge;
            CollectionLiteralPart oldCollectionLiteralPart = collectionPartEdge.getReferredPart();
            CollectionLiteralExp oldCollectionLiteralExp = (CollectionLiteralExp)oldCollectionLiteralPart.eContainer();
            int index = oldCollectionLiteralExp.getOwnedParts().indexOf(oldCollectionLiteralPart);
            Node expNode = collectionPartEdge.getEdgeSource();
            Object typedElement = expNode instanceof CollectionRangeNode ? this.doCollectionRangeNode((CollectionRangeNode)expNode) : this.getExpressionInternal(expNode);
            Object collectionLiteralPart = null;
            collectionLiteralPart = typedElement instanceof CollectionLiteralPart ? (CollectionLiteralPart)typedElement : this.helper.createCollectionItem(typedElement);
            part2index.put((CollectionLiteralPart)collectionLiteralPart, index);
            ((BasicPartition2Mapping)this.context).addTrace((Element)collectionLiteralPart, (GraphStringBuilder.GraphElement)expNode);
        }
        ArrayList<@NonNull K> asParts = new ArrayList(part2index.keySet());
        Collections.sort(asParts, new Comparator<CollectionLiteralPart>(){

            @Override
            public int compare(@NonNull CollectionLiteralPart o1, @NonNull CollectionLiteralPart o2) {
                Integer i1 = (Integer)part2index.get(o1);
                Integer i2 = (Integer)part2index.get(o2);
                if (!($assertionsDisabled || i1 != null && i2 != null)) {
                    throw new AssertionError();
                }
                return i1 - i2;
            }
        });
        return this.helper.createCollectionLiteralExp(asType, asParts);
    }

    public @NonNull OCLExpression visitCollectionRangeNode(@NonNull CollectionRangeNode node) {
        throw new IllegalStateException("CollectionRangeNode must be handled by caller");
    }

    public @NonNull OCLExpression visitEnumLiteralNode(@NonNull EnumLiteralNode node) {
        return this.helper.createEnumLiteralExp(QVTscheduleUtil.getEnumValue((EnumLiteralNode)node));
    }

    public @NonNull IfExp visitIfNode(@NonNull IfNode node) {
        OCLExpression conditionExp = null;
        OCLExpression thenExp = null;
        OCLExpression elseExp = null;
        Parameter conditionParameter = this.qvtruntimeLibraryHelper.getIfConditionParameter();
        Parameter thenParameter = this.qvtruntimeLibraryHelper.getIfThenParameter();
        Parameter elseParameter = this.qvtruntimeLibraryHelper.getIfElseParameter();
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isExpression() || !(edge instanceof OperationParameterEdge)) continue;
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            Node expNode = operationParameterEdge.getEdgeSource();
            OCLExpression nestedExp = this.getExpressionInternal(expNode);
            Parameter parameter = operationParameterEdge.getReferredParameter();
            if (parameter == conditionParameter) {
                conditionExp = nestedExp;
                continue;
            }
            if (parameter == thenParameter) {
                thenExp = nestedExp;
                continue;
            }
            if (parameter != elseParameter) continue;
            elseExp = nestedExp;
        }
        assert (conditionExp != null && thenExp != null && elseExp != null);
        return this.helper.createIfExp(conditionExp, thenExp, elseExp);
    }

    public @NonNull OCLExpression visitIteratorNode(@NonNull IteratorNode node) {
        Parameter loopIteratorsParameter = this.qvtruntimeLibraryHelper.getLoopIteratorsParameter();
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            OperationParameterEdge operationParameterEdge;
            Parameter referredParameter;
            if (!(edge instanceof OperationParameterEdge) || (referredParameter = (operationParameterEdge = (OperationParameterEdge)edge).getReferredParameter()) != loopIteratorsParameter) continue;
            Node expNode = operationParameterEdge.getEdgeTarget();
            this.getExpressionInternal(expNode);
        }
        return ((BasicPartition2Mapping)this.context).getExpression((Node)node);
    }

    public @NonNull NullLiteralExp visitNullLiteralNode(@NonNull NullLiteralNode node) {
        return this.helper.createNullLiteralExp();
    }

    public @NonNull NumericLiteralExp visitNumericLiteralNode(@NonNull NumericLiteralNode node) {
        Number numericValue = (Number)ClassUtil.nonNullState((Object)node.getNumericValue());
        if (numericValue instanceof Byte || numericValue instanceof Integer || numericValue instanceof Long || numericValue instanceof Short) {
            return this.helper.createIntegerLiteralExp(numericValue);
        }
        return this.helper.createRealLiteralExp(numericValue);
    }

    public @NonNull CallExp visitOperationCallNode(@NonNull OperationCallNode node) {
        Operation iOperation;
        Operation asOperation = node.getReferredOperation();
        if (asOperation instanceof Iteration) {
            return this.doIterationCallNode(node);
        }
        OperationCallExp asOperationCallExp = this.doOperationCallNode(node);
        if (asOperation instanceof Function && (iOperation = ((BasicPartition2Mapping)this.context).createOperation(asOperation)) != asOperation) {
            asOperationCallExp.setReferredOperation(iOperation);
        }
        return asOperationCallExp;
    }

    public @NonNull OCLExpression visitPatternTypedNode(@NonNull PatternTypedNode node) {
        return this.doPatternNode((Node)node);
    }

    public @NonNull OCLExpression visitPatternVariableNode(@NonNull PatternVariableNode node) {
        return this.doPatternNode((Node)node);
    }

    public @NonNull OCLExpression visitShadowNode(@NonNull ShadowNode node) {
        ArrayList<@NonNull ShadowPart> asParts = new ArrayList<ShadowPart>();
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!(edge instanceof ShadowPartEdge)) continue;
            ShadowPartEdge shadowPartEdge = (ShadowPartEdge)edge;
            ShadowPart referredPart = QVTscheduleUtil.getReferredPart((ShadowPartEdge)shadowPartEdge);
            Property referredProperty = PivotUtil.getReferredProperty((ShadowPart)referredPart);
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)shadowPartEdge);
            ShadowPart shadowPart = this.helper.createShadowPart(referredProperty, this.getExpressionInternal(sourceNode));
            asParts.add(shadowPart);
            ((BasicPartition2Mapping)this.context).addTrace((Element)shadowPart, (GraphStringBuilder.GraphElement)shadowPartEdge);
        }
        @NonNull Class asClass = node.getClassDatum().getPrimaryClass();
        return this.helper.createShadowExp(asClass, asParts);
    }

    public @NonNull OCLExpression visitStringLiteralNode(@NonNull StringLiteralNode node) {
        return this.helper.createStringLiteralExp((String)ClassUtil.nonNullState((Object)node.getStringValue()));
    }

    public @NonNull OCLExpression visitSuccessNode(@NonNull SuccessNode node) {
        return this.doPatternNode((Node)node);
    }

    public @NonNull OCLExpression visitTypeLiteralNode(@NonNull TypeLiteralNode node) {
        return this.helper.createTypeExp((Type)ClassUtil.nonNullState((Object)node.getTypeValue()));
    }
}

