/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelParameterExtent {
    private static final int INITIAL_EXTENT_SIZE = 150;
    private static final int PURGE_LIMIT_SIZE = 300;
    private int myCountAddedAfterPurge = 0;
    private ModelParameter myModelParameter;
    private final List<EObject> myInitialEObjects = new ArrayList<EObject>();
    private final List<EObject> myAdditionalEObjects;

    public ModelParameterExtent() {
        this(Collections.emptyList());
    }

    public ModelParameterExtent(List<EObject> initialEObjs) {
        this.myInitialEObjects.addAll(initialEObjs);
        this.myAdditionalEObjects = new ArrayList<EObject>(150);
    }

    public ModelParameterExtent(EObject initialEObj) {
        this(Collections.singletonList(initialEObj));
    }

    void setModelParameter(ModelParameter modelParameter) {
        this.myModelParameter = modelParameter;
    }

    public ModelParameter getModelParameter() {
        return this.myModelParameter;
    }

    public boolean isEmpty() {
        return this.myInitialEObjects.isEmpty() && this.myAdditionalEObjects.isEmpty();
    }

    public void addObject(EObject eObject) {
        if (eObject != null) {
            this.myAdditionalEObjects.add(eObject);
            if (++this.myCountAddedAfterPurge == 300) {
                this.purgeContents();
                this.myCountAddedAfterPurge = 0;
            }
        }
    }

    public List<EObject> getInitialObjects() {
        return this.myInitialEObjects;
    }

    public List<EObject> getRootObjects() {
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (EObject eObj : this.myInitialEObjects) {
            if (eObj.eContainer() != null) continue;
            objects.add(eObj);
        }
        for (EObject eObj : this.myAdditionalEObjects) {
            if (eObj.eContainer() != null) continue;
            objects.add(eObj);
        }
        return objects;
    }

    public List<Object> getAllObjects() {
        this.purgeContents();
        ArrayList<Object> objects = new ArrayList<Object>();
        ModelParameterExtent.getAllObjects(this.myInitialEObjects, objects);
        ModelParameterExtent.getAllObjects(this.myAdditionalEObjects, objects);
        return objects;
    }

    private static void getAllObjects(Collection<EObject> rootObjs, Collection<Object> result) {
        for (EObject nextRoot : rootObjs) {
            result.add(nextRoot);
            TreeIterator iterContents = EcoreUtil.getAllProperContents((EObject)nextRoot, (boolean)false);
            while (iterContents.hasNext()) {
                result.add(iterContents.next());
            }
        }
    }

    public ModelExtentContents getContents() {
        this.purgeContents();
        ArrayList<EObject> initialObjects = new ArrayList<EObject>(this.myInitialEObjects);
        ArrayList<EObject> allRootObjects = new ArrayList<EObject>(this.myAdditionalEObjects);
        allRootObjects.addAll(initialObjects);
        return new ExtentContents(initialObjects, allRootObjects);
    }

    public boolean removeElement(EObject element) {
        this.purgeContents();
        ModelParameterExtent.delete(this.getRootObjects(), element);
        if (!this.myInitialEObjects.remove(element)) {
            this.myAdditionalEObjects.remove(element);
        }
        return true;
    }

    public String toString() {
        return this.myInitialEObjects.isEmpty() ? super.toString() : this.myInitialEObjects.toString();
    }

    private void purgeContents() {
        this.purgeContents(this.myInitialEObjects);
        this.purgeContents(this.myAdditionalEObjects);
    }

    private void purgeContents(List<EObject> elements) {
        ArrayList<EObject> result = null;
        for (EObject nextElement : elements) {
            if (nextElement.eContainer() != null) continue;
            if (result == null) {
                result = new ArrayList<EObject>(elements.size());
            }
            result.add(nextElement);
        }
        elements.clear();
        if (result != null) {
            elements.addAll(result);
        }
    }

    public static void delete(List<EObject> rootEObjects, EObject eObject) {
        HashSet<Object> eObjects = new HashSet<Object>();
        HashSet<InternalEObject> crossResourceEObjects = new HashSet<InternalEObject>();
        eObjects.add(eObject);
        TreeIterator j = eObject.eAllContents();
        while (j.hasNext()) {
            InternalEObject internalEObject = (InternalEObject)j.next();
            if (internalEObject.eDirectResource() != null) {
                crossResourceEObjects.add(internalEObject);
                continue;
            }
            eObjects.add(internalEObject);
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll(eObjects, rootEObjects);
        for (Map.Entry entry : usages.entrySet()) {
            EObject deletedEObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                if (eObjects.contains(setting.getEObject()) || !setting.getEStructuralFeature().isChangeable()) continue;
                EcoreUtil.remove((EStructuralFeature.Setting)setting, (Object)deletedEObject);
            }
        }
        EcoreUtil.remove((EObject)eObject);
        for (EObject eObject2 : crossResourceEObjects) {
            EcoreUtil.remove((EObject)eObject2.eContainer(), (EStructuralFeature)eObject2.eContainmentFeature(), (Object)eObject2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtentContents
    implements ModelExtentContents {
        private final List<EObject> myInitialObjects;
        private final List<EObject> myRootObjects;

        private ExtentContents(List<EObject> initialObjects, List<EObject> allRootObjects) {
            this.myInitialObjects = Collections.unmodifiableList(initialObjects);
            this.myRootObjects = Collections.unmodifiableList(allRootObjects);
        }

        @Override
        public List<EObject> getInitialElements() {
            return this.myInitialObjects;
        }

        @Override
        public List<EObject> getAllRootElements() {
            return this.myRootObjects;
        }
    }
}

