/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.library;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2m.qvt.oml.util.EvaluationMonitor;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements IContext {
    private final Map<String, Object> myConfiguration = new HashMap<String, Object>();
    private SessionDataImpl myData;
    private Log myLog = Log.NULL_LOG;
    private IProgressMonitor myMonitor = new NullProgressMonitor();
    private Trace myTrace = Trace.createEmptyTrace();

    public Context() {
        this.myData = new SessionDataImpl();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("Non-null monitor required");
        }
        this.myMonitor = monitor;
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.myMonitor;
    }

    @Override
    public EvaluationMonitor getMonitor() {
        return EvaluationMonitor.EvaluationMonitorWrapper.convert(this.myMonitor);
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new IllegalArgumentException("Non-null logger required");
        }
        this.myLog = log;
    }

    @Override
    public Log getLog() {
        return this.myLog;
    }

    @Override
    public Trace getTrace() {
        return this.myTrace;
    }

    public void setSessionData(ISessionData sessionData) {
        this.myData = new SessionDataImpl((SessionDataImpl)sessionData);
    }

    @Override
    public ISessionData getSessionData() {
        return this.myData;
    }

    @Override
    public Map<String, Object> getConfigProperties() {
        return Collections.unmodifiableMap(this.myConfiguration);
    }

    @Override
    public Object getConfigProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null config property name");
        }
        return this.myConfiguration.get(name);
    }

    public void setConfigProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("null config property name");
        }
        this.myConfiguration.put(name, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SessionDataImpl
    implements ISessionData {
        private final Map<ISessionData.Entry<Object>, Object> fData;

        public SessionDataImpl(Map<ISessionData.Entry<Object>, Object> data) {
            this.fData = data;
        }

        SessionDataImpl() {
            this(new HashMap<ISessionData.Entry<Object>, Object>());
        }

        SessionDataImpl(SessionDataImpl sessionData) {
            this(new HashMap<ISessionData.Entry<Object>, Object>(sessionData.fData));
        }

        @Override
        public <T> T getValue(ISessionData.Entry<T> entry) {
            if (this.fData.containsKey(entry)) {
                return (T)this.fData.get(entry);
            }
            return entry.defaultValue();
        }

        @Override
        public <T> void setValue(ISessionData.Entry<T> key, T value) {
            this.fData.put(key, value);
        }
    }
}

