/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderFinder;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.LogNode;

class JBossClassLoaderHandler
implements ClassLoaderHandler {
    private JBossClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return ClassLoaderFinder.classIsOrExtendsOrImplements(classLoaderClass, "org.jboss.modules.ModuleClassLoader");
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    private static void handleResourceLoader(Object resourceLoader, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        if (resourceLoader == null) {
            return;
        }
        Object root = classpathOrderOut.reflectionUtils.getFieldVal(false, resourceLoader, "root");
        classpathOrderOut.addClasspathEntry(JBossClassLoaderHandler.loadJarPathFromClassicVFS(root, classpathOrderOut), classLoader, scanSpec, log);
        classpathOrderOut.addClasspathEntry((Object)JBossClassLoaderHandler.loadJarPathFromNewVFS(root, classpathOrderOut), classLoader, scanSpec, log);
        classpathOrderOut.addClasspathEntry(classpathOrderOut.reflectionUtils.getFieldVal(false, resourceLoader, "fileOfJar"), classLoader, scanSpec, log);
    }

    private static File loadJarPathFromNewVFS(Object root, ClasspathOrder classpathOrderOut) {
        if (root == null) {
            return null;
        }
        Class<?> jbossVFS = JBossClassLoaderHandler.getJBossVFSAccess(root);
        if (jbossVFS == null) {
            return null;
        }
        Object mount = classpathOrderOut.reflectionUtils.invokeStaticMethod(false, jbossVFS, "getMount", root.getClass(), root);
        if (mount == null) {
            return null;
        }
        Object fileSystem = classpathOrderOut.reflectionUtils.invokeMethod(false, mount, "getFileSystem");
        if (fileSystem == null) {
            return null;
        }
        File mountSource = (File)classpathOrderOut.reflectionUtils.invokeMethod(false, fileSystem, "getMountSource");
        if (mountSource == null) {
            return null;
        }
        return mountSource;
    }

    private static Class<?> getJBossVFSAccess(Object root) {
        Class<?> jbossVFS = null;
        try {
            if (root.getClass().getName().contains("org.jboss.vfs")) {
                ClassLoader vfsRootClassloader = root.getClass().getClassLoader();
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(vfsRootClassloader);
            } else {
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            try {
                jbossVFS = JBossClassLoaderHandler.loadJBossVFS(Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jbossVFS;
    }

    private static Class<?> loadJBossVFS(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName("org.jboss.vfs.VFS", true, classLoader);
    }

    private static Object loadJarPathFromClassicVFS(Object root, ClasspathOrder classpathOrderOut) {
        if (root == null) {
            return null;
        }
        File physicalFile = (File)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getPhysicalFile");
        if (physicalFile != null) {
            String name = (String)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getName");
            if (name != null) {
                File file = new File(physicalFile.getParentFile(), name);
                if (FileUtils.canRead(file)) {
                    return file;
                }
                return physicalFile;
            }
            return physicalFile;
        }
        String path = (String)classpathOrderOut.reflectionUtils.invokeMethod(false, root, "getPathName");
        if (path != null) {
            return path;
        }
        return root;
    }

    private static void handleRealModule(Object module, Set<Object> visitedModules, ClassLoader classLoader, ClasspathOrder classpathOrderOut, ScanSpec scanSpec, LogNode log) {
        Object vfsResourceLoaders;
        if (!visitedModules.add(module)) {
            return;
        }
        ClassLoader moduleLoader = (ClassLoader)classpathOrderOut.reflectionUtils.invokeMethod(false, module, "getClassLoader");
        if (moduleLoader == null) {
            moduleLoader = classLoader;
        }
        if ((vfsResourceLoaders = classpathOrderOut.reflectionUtils.invokeMethod(false, moduleLoader, "getResourceLoaders")) != null) {
            int i = 0;
            int n = Array.getLength(vfsResourceLoaders);
            while (i < n) {
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                JBossClassLoaderHandler.handleResourceLoader(resourceLoader, moduleLoader, classpathOrderOut, scanSpec, log);
                ++i;
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Object module = classpathOrder.reflectionUtils.invokeMethod(false, classLoader, "getModule");
        Object callerModuleLoader = classpathOrder.reflectionUtils.invokeMethod(false, module, "getCallerModuleLoader");
        HashSet<Object> visitedModules = new HashSet<Object>();
        Map moduleMap = (Map)classpathOrder.reflectionUtils.getFieldVal(false, callerModuleLoader, "moduleMap");
        Set<Object> moduleMapEntries = moduleMap != null ? moduleMap.entrySet() : Collections.emptySet();
        for (Map.Entry entry : moduleMapEntries) {
            Object val = entry.getValue();
            Object realModule = classpathOrder.reflectionUtils.invokeMethod(false, val, "getModule");
            JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
        }
        Map map = (Map)classpathOrder.reflectionUtils.invokeMethod(false, module, "getPaths");
        for (Map.Entry ent : map.entrySet()) {
            for (Object localLoader : (List)ent.getValue()) {
                Object moduleClassLoader = classpathOrder.reflectionUtils.getFieldVal(false, localLoader, "this$0");
                Object realModule = classpathOrder.reflectionUtils.getFieldVal(false, moduleClassLoader, "module");
                JBossClassLoaderHandler.handleRealModule(realModule, visitedModules, classLoader, classpathOrder, scanSpec, log);
            }
        }
    }
}

