/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.mpc.ui;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceClient {
    public static void addCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        CatalogRegistry.getInstance().register(catalogDescriptor);
    }

    public static void removeCatalogDescriptor(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        CatalogRegistry.getInstance().unregister(catalogDescriptor);
    }

    public static void openMarketplaceWizard(List<CatalogDescriptor> catalogDescriptors) throws IllegalArgumentException, ExecutionException {
        if (catalogDescriptors != null) {
            if (catalogDescriptors.isEmpty()) {
                throw new IllegalArgumentException();
            }
            for (CatalogDescriptor descriptor : catalogDescriptors) {
                if (descriptor.getUrl() == null) {
                    throw new IllegalArgumentException();
                }
                if (descriptor.getLabel() != null) continue;
                throw new IllegalArgumentException();
            }
        }
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setCatalogDescriptors(catalogDescriptors);
        command.execute(new ExecutionEvent());
    }
}

