/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.common;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.internal.monitor.core.collection.InteractionEventSummary;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;

public class UsageCountStudyParamtersFilter
extends ViewerFilter {
    private final Collection<String> filteredIds;

    public UsageCountStudyParamtersFilter(StudyParameters studyParameters) {
        Assert.isNotNull((Object)studyParameters);
        this.filteredIds = studyParameters.getFilteredIds();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof InteractionEventSummary) {
            return this.shouldIncludeEvent((InteractionEventSummary)element);
        }
        return true;
    }

    private boolean shouldIncludeEvent(InteractionEventSummary event) {
        if (this.filteredIds.size() == 0) {
            return true;
        }
        for (String filterId : this.filteredIds) {
            if (!event.getName().startsWith(filterId)) continue;
            return true;
        }
        return false;
    }
}

