/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.ui.IStartup;

public class EarlyStart
implements IStartup {
    public static final String EXTENSION_POINT = "org.eclipse.oomph.ui.deferredEarlyStart";
    public static final boolean DEFERR;
    private static final String PRIORITY_PROPERTY = "org.eclipse.oomph.ui.deferredEarlyStart.priority";
    private static final String SCHEDULE_PROPERTY = "org.eclipse.oomph.ui.deferredEarlyStart.schedule";
    private static final int PRIORITY;
    private static final long SCHEDULE;

    static {
        long schedule;
        DEFERR = "true".equals(PropertiesUtil.getProperty((String)EXTENSION_POINT, (String)"true"));
        LinkedHashMap<String, Integer> priorities = new LinkedHashMap<String, Integer>();
        priorities.put("INTERACTIVE", 10);
        priorities.put("SHORT", 20);
        priorities.put("LONG", 30);
        priorities.put("BUILD", 40);
        priorities.put("DECORATE", 50);
        String priorityProperty = PropertiesUtil.getProperty((String)PRIORITY_PROPERTY, (String)"DECORATE");
        Integer priority = (Integer)priorities.get(priorityProperty);
        if (priority == null) {
            UIPlugin.INSTANCE.log("The value '" + priorityProperty + "' of the property " + PRIORITY_PROPERTY + " must be one of " + priorities.keySet());
            PRIORITY = 50;
        } else {
            PRIORITY = priority;
        }
        String scheduleProperty = PropertiesUtil.getProperty((String)SCHEDULE_PROPERTY, (String)"5000");
        try {
            schedule = Long.parseLong(scheduleProperty);
            if (schedule < 0L) {
                UIPlugin.INSTANCE.log("The value '" + scheduleProperty + "' of the property " + SCHEDULE_PROPERTY + " must be a non-negative long value");
                schedule = 5000L;
            }
        }
        catch (RuntimeException runtimeException) {
            UIPlugin.INSTANCE.log("The value '" + scheduleProperty + "' of the property " + SCHEDULE_PROPERTY + " must be a non-negative long value");
            schedule = 5000L;
        }
        SCHEDULE = schedule;
    }

    public void earlyStartup() {
        if (DEFERR) {
            Job job = new Job("Deferred Early Start"){

                protected IStatus run(IProgressMonitor monitor) {
                    return EarlyStart.this.run(monitor);
                }
            };
            job.setPriority(PRIORITY);
            job.schedule(SCHEDULE);
        } else {
            this.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                IStartup startup = (IStartup)configurationElement.createExecutableExtension("class");
                startup.earlyStartup();
            }
            catch (Throwable throwable) {
                UIPlugin.INSTANCE.log(throwable);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }
}

