/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerException;
import org.eclipse.oomph.setup.sync.RemoteData;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncDelta;
import org.eclipse.oomph.setup.sync.SyncDeltaType;
import org.eclipse.oomph.setup.sync.SyncFactory;
import org.eclipse.oomph.setup.sync.SyncPackage;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synchronization {
    public static final EClass USER_TYPE = SetupPackage.Literals.USER;
    public static final EClass REMOTE_DATA_TYPE = SyncPackage.Literals.REMOTE_DATA;
    private final ResourceSet resourceSet = SyncUtil.createResourceSet();
    private final Set<String> ids = new HashSet<String>();
    private final Map<String, String> preferenceIDs = new HashMap<String, String>();
    private final Synchronizer synchronizer;
    private final Snapshot.WorkingCopy remoteWorkingCopy;
    private final EMap<String, SyncPolicy> remotePolicies;
    private final Map<String, SyncDelta> remoteDeltas;
    private Snapshot.WorkingCopy localWorkingCopy;
    private Map<String, SyncAction> actions;
    private Map<String, SyncAction> unresolvedActions;
    private boolean committed;
    private boolean disposed;
    private int lastID;

    public Synchronization(Synchronizer synchronizer, boolean deferLocal) throws IOException {
        this.synchronizer = synchronizer;
        synchronizer.syncStarted();
        this.remoteWorkingCopy = this.createRemoteWorkingCopy();
        synchronizer.workingCopyCreated(this.remoteWorkingCopy);
        this.remotePolicies = this.getPolicies(this.remoteWorkingCopy);
        this.remoteDeltas = this.computeRemoteDeltas(this.remoteWorkingCopy);
        if (!deferLocal) {
            this.synchronizeLocal();
        }
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public EMap<String, SyncPolicy> getRemotePolicies() {
        return this.remotePolicies;
    }

    public Map<String, SyncAction> synchronizeLocal() throws IOException {
        if (this.localWorkingCopy != null) {
            this.localWorkingCopy.dispose();
        }
        this.localWorkingCopy = this.createLocalWorkingCopy();
        this.synchronizer.workingCopyCreated(this.localWorkingCopy);
        Map<String, SyncDelta> localDeltas = this.computeLocalDeltas(this.localWorkingCopy);
        this.actions = this.computeSyncActions(localDeltas, this.remoteDeltas);
        this.synchronizer.actionsComputed(this.actions);
        return this.actions;
    }

    private Snapshot.WorkingCopy createRemoteWorkingCopy() throws IOException {
        Snapshot snapshot = this.synchronizer.getRemoteSnapshot();
        return this.createWorkingCopy(snapshot, REMOTE_DATA_TYPE);
    }

    private Snapshot.WorkingCopy createLocalWorkingCopy() throws IOException {
        Snapshot snapshot = this.synchronizer.getLocalSnapshot();
        return this.createWorkingCopy(snapshot, USER_TYPE);
    }

    private Snapshot.WorkingCopy createWorkingCopy(Snapshot snapshot, EClass eClass) throws IOException {
        File tmpFile;
        Snapshot.WorkingCopy workingCopy = snapshot.createWorkingCopy();
        File oldFile = snapshot.getOldFile();
        if (!oldFile.exists()) {
            SyncUtil.inititalizeFile(oldFile, eClass, this.resourceSet);
        }
        if (!(tmpFile = workingCopy.getTmpFile()).exists()) {
            File newFile = snapshot.getNewFile();
            if (!newFile.exists()) {
                SyncUtil.inititalizeFile(tmpFile, eClass, this.resourceSet);
            } else {
                IOUtil.copyFile((File)newFile, (File)tmpFile);
            }
        }
        return workingCopy;
    }

    private EMap<String, SyncPolicy> getPolicies(Snapshot.WorkingCopy remoteWorkingCopy) {
        File file = remoteWorkingCopy.getTmpFile();
        RemoteData remoteData = (RemoteData)this.loadObject(file, REMOTE_DATA_TYPE);
        return remoteData.getPolicies();
    }

    private boolean isIncluded(String id) {
        return SyncPolicy.EXCLUDE != this.remotePolicies.get((Object)id);
    }

    private Map<String, SyncDelta> computeRemoteDeltas(Snapshot.WorkingCopy remoteWorkingCopy) {
        return this.computeDeltas(remoteWorkingCopy, REMOTE_DATA_TYPE);
    }

    private Map<String, SyncDelta> computeLocalDeltas(Snapshot.WorkingCopy localWorkingCopy) {
        return this.computeDeltas(localWorkingCopy, USER_TYPE);
    }

    private Map<String, SyncDelta> computeDeltas(Snapshot.WorkingCopy workingCopy, EClass eClass) {
        Snapshot snapshot = workingCopy.getSnapshot();
        File oldFile = snapshot.getOldFile();
        File tmpFile = workingCopy.getTmpFile();
        SetupTaskContainer oldData = (SetupTaskContainer)this.loadObject(oldFile, eClass);
        SetupTaskContainer newData = (SetupTaskContainer)this.loadObject(tmpFile, eClass);
        return this.compareTasks(oldData, newData);
    }

    private Map<String, SyncAction> computeSyncActions(Map<String, SyncDelta> localDeltas, Map<String, SyncDelta> remoteDeltas) {
        SyncAction action;
        String id;
        HashMap<String, SyncAction> actions = new HashMap<String, SyncAction>();
        for (Map.Entry<String, SyncDelta> entry : localDeltas.entrySet()) {
            SyncDelta remoteDelta;
            id = entry.getKey();
            SyncDelta localDelta = entry.getValue();
            SyncAction action2 = this.compareDeltas(localDelta, remoteDelta = remoteDeltas.remove(id));
            if (action2 == null) continue;
            actions.put(id, action2);
        }
        for (SyncDelta syncDelta : remoteDeltas.values()) {
            id = syncDelta.getID();
            action = this.compareDeltas(null, syncDelta);
            actions.put(id, action);
        }
        for (Map.Entry entry : actions.entrySet()) {
            id = (String)entry.getKey();
            action = (SyncAction)entry.getValue();
            new ActionAdapter(action, id);
        }
        return actions;
    }

    private SyncAction compareDeltas(SyncDelta localDelta, SyncDelta remoteDelta) {
        SyncDeltaType remoteDeltaType;
        SyncDeltaType localDeltaType = localDelta == null ? SyncDeltaType.UNCHANGED : localDelta.getType();
        SyncActionType actionType = this.compareDeltaTypes(localDeltaType, remoteDeltaType = remoteDelta == null ? SyncDeltaType.UNCHANGED : remoteDelta.getType());
        if (actionType == SyncActionType.NONE) {
            PreferenceTask localPreference = (PreferenceTask)localDelta.getNewTask();
            PreferenceTask remotePreference = (PreferenceTask)remoteDelta.getNewTask();
            actionType = ObjectUtil.equals((Object)localPreference.getValue(), (Object)remotePreference.getValue()) ? null : SyncActionType.CONFLICT;
        }
        if (actionType != null) {
            return SyncFactory.eINSTANCE.createSyncAction(localDelta, remoteDelta, actionType);
        }
        return null;
    }

    private SyncActionType compareDeltaTypes(SyncDeltaType localDeltaType, SyncDeltaType remoteDeltaType) {
        switch (localDeltaType) {
            case UNCHANGED: {
                switch (remoteDeltaType) {
                    case UNCHANGED: {
                        return null;
                    }
                    case CHANGED: {
                        return SyncActionType.SET_REMOTE;
                    }
                    case REMOVED: {
                        return SyncActionType.REMOVE;
                    }
                }
                break;
            }
            case CHANGED: {
                switch (remoteDeltaType) {
                    case UNCHANGED: {
                        return SyncActionType.SET_LOCAL;
                    }
                    case CHANGED: {
                        return SyncActionType.NONE;
                    }
                    case REMOVED: {
                        return SyncActionType.CONFLICT;
                    }
                }
                break;
            }
            case REMOVED: {
                switch (remoteDeltaType) {
                    case UNCHANGED: {
                        return SyncActionType.REMOVE;
                    }
                    case CHANGED: {
                        return SyncActionType.CONFLICT;
                    }
                    case REMOVED: {
                        return null;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    private Map<String, SyncDelta> compareTasks(SetupTaskContainer oldTaskContainer, SetupTaskContainer newTaskContainer) {
        String id;
        HashMap<String, SyncDelta> deltas = new HashMap<String, SyncDelta>();
        Map<String, SetupTask> oldTasks = this.collectTasks(oldTaskContainer);
        Map<String, SetupTask> newTasks = this.collectTasks(newTaskContainer);
        for (Map.Entry<String, SetupTask> oldEntry : oldTasks.entrySet()) {
            SetupTask newTask;
            SetupTask oldTask;
            SyncDelta delta;
            id = oldEntry.getKey();
            if (!this.isIncluded(id) || (delta = this.compareTasks(id, oldTask = oldEntry.getValue(), newTask = newTasks.remove(id))) == null) continue;
            deltas.put(id, delta);
        }
        for (Map.Entry<String, SetupTask> newEntry : newTasks.entrySet()) {
            id = newEntry.getKey();
            if (!this.isIncluded(id)) continue;
            SetupTask newTask = newEntry.getValue();
            SyncDelta delta = this.compareTasks(id, null, newTask);
            deltas.put(id, delta);
        }
        return deltas;
    }

    private SyncDelta compareTasks(String id, SetupTask oldTask, SetupTask newTask) {
        if (oldTask == null) {
            if (newTask == null) {
                return null;
            }
            return SyncFactory.eINSTANCE.createSyncDelta(id, oldTask, newTask, SyncDeltaType.CHANGED);
        }
        if (newTask == null) {
            return SyncFactory.eINSTANCE.createSyncDelta(id, oldTask, newTask, SyncDeltaType.REMOVED);
        }
        PreferenceTask oldPreference = (PreferenceTask)oldTask;
        PreferenceTask newPreference = (PreferenceTask)newTask;
        if (!ObjectUtil.equals((Object)oldPreference.getKey(), (Object)newPreference.getKey())) {
            return null;
        }
        if (ObjectUtil.equals((Object)oldPreference.getValue(), (Object)newPreference.getValue())) {
            return null;
        }
        return SyncFactory.eINSTANCE.createSyncDelta(id, (SetupTask)oldPreference, (SetupTask)newPreference, SyncDeltaType.CHANGED);
    }

    private Map<String, SetupTask> collectTasks(SetupTaskContainer taskContainer) {
        HashMap<String, SetupTask> tasks = new HashMap<String, SetupTask>();
        this.collectTasks((EList<SetupTask>)taskContainer.getSetupTasks(), tasks);
        return tasks;
    }

    private void collectTasks(EList<SetupTask> tasks, Map<String, SetupTask> result) {
        for (SetupTask task : tasks) {
            String id = this.rememberID(task);
            if (this.isSychronizable(task)) {
                if (StringUtil.isEmpty((String)id)) {
                    id = this.getPreferenceID(task);
                    if (StringUtil.isEmpty((String)id)) {
                        id = this.createID();
                    } else {
                        this.ids.add(id);
                    }
                    task.setID(id);
                    this.rememberPreferenceID(task);
                }
                if (result.put(id, task) == null) continue;
                throw new DuplicateIDException(id);
            }
            if (!(task instanceof CompoundTask)) continue;
            CompoundTask compoundTask = (CompoundTask)task;
            this.collectTasks((EList<SetupTask>)compoundTask.getSetupTasks(), result);
        }
    }

    private String rememberID(SetupTask task) {
        String id = task.getID();
        if (!StringUtil.isEmpty((String)id)) {
            this.ids.add(id);
            this.rememberPreferenceID(task);
        }
        return id;
    }

    private void rememberPreferenceID(SetupTask task) {
        PreferenceTask preferenceTask;
        String key;
        String id = task.getID();
        if (!StringUtil.isEmpty((String)id) && task instanceof PreferenceTask && !StringUtil.isEmpty((String)(key = (preferenceTask = (PreferenceTask)task).getKey()))) {
            this.preferenceIDs.put(key, id);
        }
    }

    private String getPreferenceID(SetupTask task) {
        PreferenceTask preferenceTask;
        String key;
        if (task instanceof PreferenceTask && !StringUtil.isEmpty((String)(key = (preferenceTask = (PreferenceTask)task).getKey()))) {
            return this.preferenceIDs.get(key);
        }
        return null;
    }

    private <T extends EObject> T loadObject(File file, EClass eClass) {
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        Resource resource = this.resourceSet.getResource(uri, true);
        return (T)((EObject)BaseUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)eClass));
    }

    private boolean isSychronizable(SetupTask task) {
        return task instanceof PreferenceTask;
    }

    private String createID() {
        int i = this.lastID + 1;
        while (i < Integer.MAX_VALUE) {
            String id = "sync" + i;
            if (this.ids.add(id)) {
                this.lastID = i;
                return id;
            }
            ++i;
        }
        throw new IllegalStateException("Too many IDs");
    }

    public String getID(SyncAction action) {
        String id = action.getID();
        if (id != null) {
            return id;
        }
        ActionAdapter adapter = (ActionAdapter)EcoreUtil.getAdapter((List)action.eAdapters(), ActionAdapter.class);
        if (adapter != null) {
            return adapter.getID();
        }
        return null;
    }

    public Map<String, SyncAction> getActions() {
        return this.actions;
    }

    public Map<String, SyncAction> getUnresolvedActions() {
        if (this.unresolvedActions == null) {
            this.unresolvedActions = new HashMap<String, SyncAction>();
            for (Map.Entry<String, SyncAction> entry : this.actions.entrySet()) {
                SyncAction action = entry.getValue();
                if (action.getEffectiveType() != SyncActionType.CONFLICT) continue;
                String id = entry.getKey();
                this.unresolvedActions.put(id, action);
            }
        }
        return this.unresolvedActions;
    }

    public Synchronization resolve(String id, SyncActionType resolvedType) {
        SyncAction action = this.actions.get(id);
        if (action != null) {
            action.setResolvedType(resolvedType);
        }
        return this;
    }

    public void commit() throws IOException, DataProvider.NotCurrentException {
        if (!this.committed && !this.disposed) {
            this.committed = true;
            this.doCommit();
        }
    }

    private void doCommit() throws IOException, DataProvider.NotCurrentException {
        this.synchronizer.commitStarted();
        try {
            try {
                this.applyActions(this.remoteWorkingCopy, REMOTE_DATA_TYPE);
                this.remoteWorkingCopy.commit();
                this.applyActions(this.localWorkingCopy, USER_TYPE);
                this.localWorkingCopy.commit();
                this.synchronizer.commitFinished(null);
            }
            catch (IOException ex) {
                this.synchronizer.commitFinished(ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                this.synchronizer.commitFinished(ex);
                throw ex;
            }
            catch (Error ex) {
                this.synchronizer.commitFinished(ex);
                throw ex;
            }
        }
        finally {
            this.doDispose();
        }
    }

    private void applyActions(Snapshot.WorkingCopy workingCopy, EClass eClass) {
        File file = workingCopy.getTmpFile();
        SetupTaskContainer taskContainer = (SetupTaskContainer)this.loadObject(file, eClass);
        Map<String, SetupTask> tasks = this.collectTasks(taskContainer);
        for (Map.Entry<String, SyncAction> entry : this.actions.entrySet()) {
            String id = entry.getKey();
            SyncAction action = entry.getValue();
            SyncActionType type = action.getEffectiveType();
            switch (type) {
                case CONFLICT: {
                    throw new ConflictException(action);
                }
                case SET_LOCAL: {
                    this.include(id);
                    this.applySetAction(taskContainer, tasks, id, action.getLocalDelta());
                    break;
                }
                case SET_REMOTE: {
                    this.include(id);
                    this.applySetAction(taskContainer, tasks, id, action.getRemoteDelta());
                    break;
                }
                case REMOVE: {
                    this.include(id);
                    this.applyRemoveAction(taskContainer, tasks, action.getLocalDelta());
                    this.applyRemoveAction(taskContainer, tasks, action.getRemoteDelta());
                    break;
                }
                case EXCLUDE: {
                    this.exclude(id);
                    this.applyRemoveAction(taskContainer, tasks, action.getRemoteDelta());
                    break;
                }
            }
        }
        BaseUtil.saveEObject((EObject)taskContainer);
    }

    private void applySetAction(SetupTaskContainer taskContainer, Map<String, SetupTask> tasks, String id, SyncDelta delta) {
        SetupTask newTask;
        if (delta != null && (newTask = delta.getNewTask()) != null) {
            newTask = (SetupTask)EcoreUtil.copy((EObject)newTask);
            newTask.setID(id);
            newTask.getRestrictions().clear();
            newTask.getPredecessors().clear();
            newTask.getSuccessors().clear();
            SetupTask oldTask = tasks.get(id);
            if (oldTask != null) {
                EcoreUtil.replace((EObject)oldTask, (EObject)newTask);
            } else {
                taskContainer.getSetupTasks().add((Object)newTask);
            }
        }
    }

    private void applyRemoveAction(SetupTaskContainer taskContainer, Map<String, SetupTask> tasks, SyncDelta delta) {
        String id;
        SetupTask oldTask;
        if (delta != null && (oldTask = tasks.get(id = delta.getID())) != null) {
            EcoreUtil.remove((EObject)oldTask);
        }
    }

    private void include(String id) {
        this.remotePolicies.put((Object)id, (Object)SyncPolicy.INCLUDE);
    }

    private void exclude(String id) {
        this.remotePolicies.put((Object)id, (Object)SyncPolicy.EXCLUDE);
    }

    public void dispose() {
        if (!this.disposed) {
            this.doDispose();
        }
    }

    private void doDispose() {
        this.disposed = true;
        try {
            this.localWorkingCopy.dispose();
        }
        catch (Throwable ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
        try {
            this.remoteWorkingCopy.dispose();
        }
        catch (Throwable ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
        try {
            this.synchronizer.releaseLock();
        }
        catch (Throwable ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
    }

    private final class ActionAdapter
    extends AdapterImpl {
        private final String id;

        public ActionAdapter(SyncAction action, String id) {
            this.id = id;
            action.eAdapters().add((Object)this);
        }

        public String getID() {
            return this.id;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == SyncPackage.Literals.SYNC_ACTION__RESOLVED_TYPE && !msg.isTouch()) {
                Synchronization.this.unresolvedActions = null;
                SyncAction action = (SyncAction)this.getTarget();
                Synchronization.this.synchronizer.actionResolved(action, this.id);
            }
        }
    }

    public static class ConflictException
    extends SynchronizerException {
        private static final long serialVersionUID = 1L;

        public ConflictException(SyncAction action) {
            super("Conflict: " + action);
        }
    }

    public static class DuplicateIDException
    extends SynchronizerException {
        private static final long serialVersionUID = 1L;

        public DuplicateIDException(String id) {
            super("Duplicate ID: " + id);
        }
    }
}

