/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.util.PreferencesRecorder;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.LocalDataProvider;
import org.eclipse.oomph.setup.internal.sync.RemoteDataProvider;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerJob;
import org.eclipse.oomph.setup.internal.sync.SynchronizerService;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.AbstractRecorderDialog;
import org.eclipse.oomph.setup.ui.recorder.RecorderPreferencePage;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerDialog;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecorderManager {
    public static final RecorderManager INSTANCE = new RecorderManager();
    private static final IPersistentPreferenceStore SETUP_UI_PREFERENCES = (IPersistentPreferenceStore)SetupUIPlugin.INSTANCE.getPreferenceStore();
    private final EarlySynchronization earlySynchronization = new EarlySynchronization();
    private static ToolItem toolItem;
    private final DisplayListener displayListener = new DisplayListener();
    private Display display;
    private PreferencesRecorder recorder;
    private IEditorPart editor;
    private boolean user = true;

    private RecorderManager() {
    }

    public void record(IEditorPart editor) {
        this.editor = editor;
        boolean wasEnabled = this.isRecorderEnabled();
        this.setRecorderEnabled(true);
        boolean wasUser = this.user;
        this.user = false;
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, null, null, null);
        try {
            dialog.open();
        }
        finally {
            this.user = wasUser;
            this.editor = null;
            this.setRecorderEnabled(wasEnabled);
        }
    }

    public boolean isUser() {
        return this.user;
    }

    public boolean isRecorderEnabled() {
        String value = SETUP_UI_PREFERENCES.getString("enable.preference.recorder");
        if (StringUtil.isEmpty((String)value)) {
            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
            SetupContext setupContext = SetupContext.createUserOnly((ResourceSet)resourceSet);
            User user = setupContext.getUser();
            boolean enabled = user.isPreferenceRecorderDefault();
            this.doSetRecorderEnabled(enabled);
            return enabled;
        }
        return Boolean.parseBoolean(value);
    }

    public void setRecorderEnabled(boolean enabled) {
        if (this.isRecorderEnabled() != enabled) {
            try {
                this.doSetRecorderEnabled(enabled);
            }
            finally {
                if (enabled) {
                    if (this.recorder == null) {
                        this.recorder = new PreferencesRecorder();
                    }
                    this.earlySynchronization.start();
                } else {
                    if (this.recorder != null) {
                        this.recorder.done();
                        this.recorder = null;
                    }
                    this.earlySynchronization.stop();
                }
            }
        }
    }

    private void doSetRecorderEnabled(boolean enabled) {
        SETUP_UI_PREFERENCES.setValue("enable.preference.recorder", Boolean.toString(enabled));
        try {
            SETUP_UI_PREFERENCES.save();
        }
        catch (IOException ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
    }

    private void closeTransaction(RecorderTransaction transaction) {
        try {
            transaction.close();
        }
        finally {
            this.earlySynchronization.stop();
        }
    }

    public Scope getRecorderTargetObject(ResourceSet resourceSet) {
        URIConverter uriConverter = resourceSet.getURIConverter();
        URI recorderTarget = this.getRecorderTarget();
        URI uri = RecorderManager.normalize(uriConverter, recorderTarget);
        return (Scope)resourceSet.getEObject(uri, true);
    }

    public URI getRecorderTarget() {
        String value = SETUP_UI_PREFERENCES.getString("preference.recorder.target");
        if (StringUtil.isEmpty((String)value)) {
            return SetupContext.USER_SETUP_URI;
        }
        return URI.createURI((String)value);
    }

    public URI setRecorderTarget(URI uri) {
        URI oldURI = this.getRecorderTarget();
        if (!ObjectUtil.equals((Object)oldURI, (Object)uri)) {
            SETUP_UI_PREFERENCES.setValue("preference.recorder.target", uri.toString());
            try {
                SETUP_UI_PREFERENCES.save();
            }
            catch (IOException ex) {
                SetupUIPlugin.INSTANCE.log(ex);
            }
            return oldURI;
        }
        return null;
    }

    private void handleRecording(IEditorPart editorPart, final Shell shell, final Map<URI, String> values) {
        final RecorderTransaction transaction = editorPart == null ? RecorderTransaction.open() : RecorderTransaction.open(this.user, editorPart);
        try {
            Iterator<URI> it = values.keySet().iterator();
            while (it.hasNext()) {
                URI uri = it.next();
                String path = PreferencesFactory.eINSTANCE.convertURI(uri);
                Boolean policy = transaction.getPolicy(path);
                if (policy == null) {
                    transaction.setPolicy(path, true);
                    continue;
                }
                if (policy.booleanValue()) continue;
                it.remove();
            }
            this.earlySynchronization.start();
            if (transaction.isDirty()) {
                final Synchronization synchronization = this.earlySynchronization.await();
                final boolean[] exitEarly = new boolean[1];
                UIUtil.syncExec((Display)this.display, (Runnable)new Runnable(){

                    public void run() {
                        AbstractRecorderDialog dialog = this.createDialog();
                        int result = dialog.open();
                        if (!dialog.isEnableRecorder()) {
                            RecorderManager.this.setRecorderEnabled(false);
                            exitEarly[0] = true;
                        } else if (result != 0) {
                            exitEarly[0] = true;
                        }
                    }

                    private AbstractRecorderDialog createDialog() {
                        return new SynchronizerDialog(shell, transaction, values, synchronization);
                    }
                });
                if (exitEarly[0]) {
                    return;
                }
            }
            transaction.setPreferences(values);
            transaction.commit();
            Mars1.offerSynchronizer();
        }
        finally {
            this.closeTransaction(transaction);
        }
    }

    private static boolean isPreferenceDialog(Shell shell) {
        Object data = shell.getData();
        return data instanceof WorkbenchPreferenceDialog;
    }

    private static void hookRecorderCheckbox(final Shell shell) {
        try {
            Control child;
            Composite buttonBar;
            Control[] children;
            WorkbenchPreferenceDialog dialog = (WorkbenchPreferenceDialog)shell.getData();
            if (dialog.buttonBar instanceof Composite && (children = (buttonBar = (Composite)dialog.buttonBar).getChildren()).length != 0 && (child = children[0]) instanceof ToolBar) {
                ToolBar toolBar = (ToolBar)child;
                toolItem = new ToolItem(toolBar, 8);
                RecorderManager.updateRecorderCheckboxState();
                toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean enableRecorder = !INSTANCE.isRecorderEnabled();
                        INSTANCE.setRecorderEnabled(enableRecorder);
                        RecorderManager.updateRecorderCheckboxState();
                        RecorderPreferencePage.updateEnablement();
                        if (enableRecorder) {
                            SynchronizerManager.INSTANCE.offerFirstTimeConnect(shell);
                        }
                    }
                });
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        RecorderManager.toolItem = null;
                    }
                });
                buttonBar.layout();
            }
        }
        catch (Throwable throwable) {}
    }

    static void updateRecorderCheckboxState() {
        if (toolItem != null) {
            boolean recorderEnabled = INSTANCE.isRecorderEnabled();
            String state = recorderEnabled ? "enabled" : "disabled";
            String verb = !recorderEnabled ? "enable" : "disable";
            toolItem.setImage(SetupUIPlugin.INSTANCE.getSWTImage("recorder_" + state));
            toolItem.setToolTipText("Oomph preference recorder " + state + " - Push to " + verb);
        }
    }

    public static URI normalize(URIConverter uriConverter, URI uri) {
        uri = uriConverter.normalize(uri);
        if (StringUtil.isEmpty((String)(uri = SetupContext.resolveUser((URI)uri)).fragment())) {
            uri = uri.appendFragment("/");
        }
        return uri;
    }

    public static File copyRecorderTarget(Scope recorderTarget, File tmpFolder) {
        URI uri = recorderTarget.eResource().getURI();
        File source = new File(uri.toFileString());
        File target = new File(tmpFolder, uri.lastSegment());
        IOUtil.copyFile((File)source, (File)target);
        return target;
    }

    private final class DisplayListener
    implements Listener {
        private boolean stopped;

        private DisplayListener() {
        }

        public void stop() {
            this.stopped = true;
        }

        public void handleEvent(Event event) {
            Shell shell;
            if (this.stopped) {
                return;
            }
            if (event.widget instanceof Shell && RecorderManager.isPreferenceDialog(shell = (Shell)event.widget) && toolItem == null) {
                UIUtil.asyncExec((Display)RecorderManager.this.display, (Runnable)new Runnable(){

                    public void run() {
                        RecorderManager.hookRecorderCheckbox(shell);
                    }
                });
                if (RecorderManager.this.isRecorderEnabled()) {
                    RecorderManager.this.recorder = new PreferencesRecorder();
                    RecorderManager.this.earlySynchronization.start();
                }
                shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (RecorderManager.this.recorder == null) {
                            return;
                        }
                        final Map values = RecorderManager.this.recorder.done();
                        RecorderManager.this.recorder = null;
                        Iterator it = values.keySet().iterator();
                        while (it.hasNext()) {
                            String lastSegment;
                            URI uri = (URI)it.next();
                            String pluginID = uri.segment(0);
                            if (!SetupUIPlugin.PLUGIN_ID.equals(pluginID) || !"enable.preference.recorder".equals(lastSegment = uri.lastSegment()) && !"preference.recorder.target".equals(lastSegment)) continue;
                            it.remove();
                        }
                        if (values.isEmpty()) {
                            RecorderTransaction transaction = RecorderTransaction.getInstance();
                            if (transaction != null) {
                                RecorderManager.this.closeTransaction(transaction);
                            }
                            Mars1.offerSynchronizer();
                        } else {
                            Job job = new Job("Store preferences"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    RecorderManager.this.handleRecording(RecorderManager.this.editor, shell, values);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                        }
                    }
                });
            }
        }
    }

    private static final class EarlySynchronization {
        private static final boolean DEBUG = false;
        private SynchronizerJob synchronizerJob;

        private EarlySynchronization() {
        }

        public void start() {
            ResourceSet resourceSet;
            Scope recorderTarget;
            if (!SynchronizerManager.ENABLED) {
                Mars1.checkAvailability();
                return;
            }
            if (this.synchronizerJob == null && SynchronizerManager.INSTANCE.isSyncEnabled() && (recorderTarget = INSTANCE.getRecorderTargetObject(resourceSet = SetupCoreUtil.createResourceSet())) instanceof User) {
                File tmpFolder = IOUtil.createTempFolder((String)"sync-", (boolean)true);
                SynchronizerService service = SynchronizerManager.INSTANCE.getService();
                File syncFolder = service.getSyncFolder();
                File[] files = syncFolder.listFiles();
                if (files != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        IOUtil.copyTree((File)file, (File)new File(tmpFolder, file.getName()));
                        ++n2;
                    }
                }
                File target = RecorderManager.copyRecorderTarget(recorderTarget, tmpFolder);
                LocalDataProvider local = new LocalDataProvider(target);
                RemoteDataProvider remote = service.createDataProvider();
                Synchronizer synchronizer = new Synchronizer((DataProvider)local, (DataProvider)remote, tmpFolder);
                this.synchronizerJob = new SynchronizerJob(synchronizer, true);
                this.synchronizerJob.setService(service);
                this.synchronizerJob.schedule();
            }
        }

        public void stop() {
            if (!SynchronizerManager.ENABLED) {
                return;
            }
            if (this.synchronizerJob != null) {
                this.synchronizerJob.cancel();
                this.synchronizerJob = null;
            }
        }

        public Synchronization await() {
            if (!SynchronizerManager.ENABLED) {
                return null;
            }
            if (this.synchronizerJob != null) {
                final AtomicReference<Synchronization> synchronization = new AtomicReference<Synchronization>(this.synchronizerJob.getSynchronization());
                if (synchronization.get() == null) {
                    SynchronizerService service = this.synchronizerJob.getService();
                    final String serviceLabel = service == null ? "remote service" : service.getLabel();
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                synchronization.set(EarlySynchronization.this.await(serviceLabel, 2000, monitor));
                            }
                        });
                        if (synchronization.get() == null) {
                            ProgressMonitorDialog dialog = new ProgressMonitorDialog(UIUtil.getShell());
                            dialog.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    synchronization.set(EarlySynchronization.this.await(serviceLabel, 8000, monitor));
                                }
                            });
                        }
                        if (synchronization.get() == null) {
                            Throwable exception = this.synchronizerJob.getException();
                            if (exception != null) {
                                throw exception;
                            }
                            throw new TimeoutException("Request to " + serviceLabel + " timed out.");
                        }
                    }
                    catch (Throwable ex) {
                        SetupUIPlugin.INSTANCE.log(ex);
                    }
                }
                return synchronization.get();
            }
            return null;
        }

        private Synchronization await(String serviceLabel, int timeout, IProgressMonitor monitor) {
            monitor.beginTask("Requesting data from " + serviceLabel + "...", -1);
            try {
                Synchronization synchronization = this.synchronizerJob.awaitSynchronization((long)timeout, monitor);
                return synchronization;
            }
            finally {
                monitor.done();
            }
        }
    }

    public static class Lifecycle {
        public static void start(Display display) {
            INSTANCE.display = display;
            display.addListener(45, (Listener)INSTANCE.displayListener);
        }

        public static void stop() {
            INSTANCE.displayListener.stop();
            if (INSTANCE.display != null) {
                UIUtil.asyncExec((Display)INSTANCE.display, (Runnable)new Runnable(){

                    public void run() {
                        if (!INSTANCE.display.isDisposed()) {
                            INSTANCE.display.removeListener(45, (Listener)INSTANCE.displayListener);
                        }
                    }
                });
            }
        }
    }

    @Deprecated
    private static final class Mars1 {
        private static final boolean ENABLED = PropertiesUtil.isProperty((String)"oomph.setup.mars1.optin");
        private static final URI PROPERTIES_URI = URI.createURI((String)"http://download.eclipse.org/oomph/epp/mars/mars1.sync.properties");
        private static final File PROPERTIES = SetupUIPlugin.INSTANCE.getConfigurationLocation().append("mars1.sync.properties").toFile();
        private static final String TITLE = "Oomph Preference Synchronizer";
        private static final String INSTALLED = "update.installed";
        private static final String REJECTED = "update.rejected";
        private static boolean checked;
        private static boolean available;

        private Mars1() {
        }

        public static void checkAvailability() {
            if (!ENABLED || checked || available) {
                return;
            }
            checked = true;
            if (PROPERTIES.isFile()) {
                available = true;
                return;
            }
            Job job = new Job("Synchronizer availability check"){

                protected IStatus run(IProgressMonitor monitor) {
                    block5: {
                        InputStream in = null;
                        FileOutputStream out = null;
                        try {
                            try {
                                HashMap<String, ECFURIHandlerImpl.CacheHandling> options = new HashMap<String, ECFURIHandlerImpl.CacheHandling>();
                                options.put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_IGNORE);
                                in = SetupCoreUtil.createResourceSet().getURIConverter().createInputStream(PROPERTIES_URI, options);
                                PROPERTIES.getParentFile().mkdirs();
                                out = new FileOutputStream(PROPERTIES);
                                IOUtil.copy((InputStream)in, (OutputStream)out);
                                available = true;
                            }
                            catch (Throwable throwable) {
                                IOUtil.closeSilent(out);
                                IOUtil.deleteBestEffort((File)PROPERTIES, (boolean)true);
                                out = null;
                                IOUtil.closeSilent(out);
                                IOUtil.closeSilent((Closeable)in);
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtil.closeSilent(out);
                            IOUtil.closeSilent(in);
                            throw throwable;
                        }
                        IOUtil.closeSilent((Closeable)out);
                        IOUtil.closeSilent((Closeable)in);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        public static void offerSynchronizer() {
            if (!ENABLED || !available) {
                return;
            }
            try {
                final Map properties = PropertiesUtil.loadProperties((File)PROPERTIES);
                if (properties != null && !"true".equals(properties.get(REJECTED))) {
                    Shell shell = UIUtil.getShell();
                    if (MessageDialog.openQuestion((Shell)shell, (String)TITLE, (String)("Since " + (String)properties.get("available.date") + " you can synchronize your preferences with your Eclipse.org account. Do you want to update Eclipse and use this new service?"))) {
                        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                        dialog.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                block4: {
                                    try {
                                        Agent agent = P2Util.getAgentManager().getCurrentAgent();
                                        Profile profile = agent.getCurrentProfile();
                                        if (profile.change().commit(monitor)) {
                                            properties.put(Mars1.INSTALLED, "true");
                                            PropertiesUtil.saveProperties((File)PROPERTIES, (Map)properties, (boolean)false);
                                            MessageDialog.openInformation((Shell)dialog.getShell(), (String)Mars1.TITLE, (String)"Updates were installed. Press OK to restart.");
                                            PlatformUI.getWorkbench().restart();
                                        } else {
                                            MessageDialog.openInformation((Shell)dialog.getShell(), (String)Mars1.TITLE, (String)"No updates were installed.");
                                        }
                                    }
                                    catch (Throwable ex) {
                                        SetupUIPlugin.INSTANCE.log(ex);
                                        if (MessageDialog.openQuestion((Shell)dialog.getShell(), (String)Mars1.TITLE, (String)"An error occured during the update. Do you want to try again later?")) break block4;
                                        properties.put(Mars1.REJECTED, "true");
                                        PropertiesUtil.saveProperties((File)PROPERTIES, (Map)properties, (boolean)false);
                                    }
                                }
                            }
                        });
                    } else {
                        properties.put(REJECTED, "true");
                        PropertiesUtil.saveProperties((File)PROPERTIES, (Map)properties, (boolean)false);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

