/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.BuildState;
import org.eclipse.oomph.internal.version.DeprecationUtil;
import org.eclipse.oomph.internal.version.Element;
import org.eclipse.oomph.internal.version.ReleaseManager;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.version.IElement;
import org.eclipse.oomph.version.IElementResolver;
import org.eclipse.oomph.version.IRelease;
import org.eclipse.oomph.version.IReleaseManager;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.VersionValidator;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionBuilder
extends IncrementalProjectBuilder
implements IElementResolver {
    private static final Path DESCRIPTION_PATH = new Path(".project");
    private static final Path OPTIONS_PATH = new Path(".options");
    private static final Path MAVEN_POM_PATH = new Path("pom.xml");
    private static final Path MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    private static final Path FEATURE_PATH = new Path("feature.xml");
    public static final String INTEGRATION_PROPERTY_KEY = "baseline.for.integration";
    public static final String DEVIATIONS_PROPERTY_KEY = "show.deviations";
    public static final String ROOT_PROJECTS_KEY = "root.projects";
    public static final String IGNORED_REFERENCES_KEY = "ignored.references";
    private static final Pattern DEBUG_OPTION_PATTERN = Pattern.compile("^( *)([^/ \\n\\r]+)/([^ =]+)( *=.*)$", 8);
    private static final Set<String> releasePaths = new HashSet<String>();
    private static final Map<IElement, IElement> elementCache = new HashMap<IElement, IElement>();
    private static final Map<IElement, Set<IElement>> elementReferences = new HashMap<IElement, Set<IElement>>();
    private static IResourceChangeListener postBuildListener;
    private static SAXParserFactory parserFactory;
    private IRelease release;
    private Boolean integration;
    private Boolean deviations;
    private Set<String> rootProjects;
    private Set<String> ignoredReferences;
    private VersionBuilderArguments arguments;

    @Override
    public IElement resolveElement(IElement key) {
        try {
            this.ensureCacheExists();
            return elementCache.get(key);
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    public Set<IElement> resolveReferences(IElement key) {
        try {
            this.ensureCacheExists();
            return elementReferences.get(key);
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private void ensureCacheExists() throws NoSuchAlgorithmException, CoreException, IOException {
        String path = this.arguments.getReleasePath();
        if (releasePaths.add(path)) {
            Map<IElement, IElement> elements = IReleaseManager.INSTANCE.createElements(this.arguments.getReleasePath(), false);
            elementCache.putAll(elements);
            for (IElement element : elements.keySet()) {
                if (element.getType() != IElement.Type.FEATURE) continue;
                for (IElement child : element.getChildren()) {
                    Set<IElement> references = elementReferences.get(child);
                    if (references == null) {
                        references = new HashSet<IElement>();
                        elementReferences.put(child, references);
                    }
                    references.add(element);
                }
            }
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        monitor.beginTask("", 1);
        monitor.subTask("Cleaning version validity problems of " + project.getName());
        try {
            Activator.clearBuildState(project);
            Markers.deleteAllMarkers((IResource)project, new String[0]);
        }
        finally {
            monitor.done();
        }
    }

    protected final IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        ArrayList<IProject> buildDependencies = new ArrayList<IProject>();
        this.build(kind, args, monitor, buildDependencies);
        return buildDependencies.toArray(new IProject[buildDependencies.size()]);
    }

    private void build(int kind, Map<String, String> args, IProgressMonitor monitor, List<IProject> buildDependencies) throws CoreException {
        this.arguments = new VersionBuilderArguments((Map<? extends String, ? extends String>)args);
        VersionValidator validator = null;
        IProject project = this.getProject();
        IFile projectDescription = project.getFile((IPath)DESCRIPTION_PATH);
        if (postBuildListener == null) {
            postBuildListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    elementCache.clear();
                    elementReferences.clear();
                    releasePaths.clear();
                    VersionBuilder.this.arguments = null;
                }
            };
            project.getWorkspace().addResourceChangeListener(postBuildListener, 16);
            Activator.setPostBuildListener(postBuildListener);
        }
        BuildState buildState = Activator.getBuildState(project);
        byte[] releaseSpecDigest = buildState.getReleaseSpecDigest();
        VersionBuilderArguments oldVersionBuilderArguments = new VersionBuilderArguments((Map<? extends String, ? extends String>)buildState.getArguments());
        buildState.setArguments(this.arguments);
        IResourceDelta delta = releaseSpecDigest == null || kind == 6 || kind == 15 || !oldVersionBuilderArguments.equals(this.arguments) ? null : this.getDelta(project);
        monitor.beginTask("", 1);
        monitor.subTask("Checking version validity of " + project.getName());
        try {
            IMarker marker;
            IElement releaseElement;
            Set<IElement> elementReference;
            IModel componentModel = VersionUtil.getComponentModel(project);
            IFile componentModelFile = (IFile)componentModel.getUnderlyingResource();
            String releasePathArg = this.arguments.getReleasePath();
            if (releasePathArg == null) {
                String msg = "Path to release spec file is not configured";
                Markers.addMarker(projectDescription, msg, 2, "(org.eclipse.oomph.version.VersionBuilder)");
                return;
            }
            if (Activator.getReleaseCheckMode(releasePathArg) == Activator.ReleaseCheckMode.NONE) {
                return;
            }
            Path releasePath = new Path(releasePathArg);
            try {
                IFile releaseSpecFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)releasePath);
                buildDependencies.add(releaseSpecFile.getProject());
                IRelease release = !releaseSpecFile.exists() ? IReleaseManager.INSTANCE.createRelease(releaseSpecFile) : IReleaseManager.INSTANCE.getRelease(releaseSpecFile);
                byte[] digest = VersionUtil.getSHA1(releaseSpecFile);
                if (releaseSpecDigest == null || !MessageDigest.isEqual(digest, releaseSpecDigest)) {
                    buildState.setReleaseSpecDigest(digest);
                    delta = null;
                }
                this.release = release;
                Markers.deleteAllMarkers((IResource)projectDescription, "release.path");
            }
            catch (Exception ex) {
                Activator.log(ex, 2);
                String msg = "Problem with release spec: " + releasePath + " (" + ex.getMessage() + ")";
                IMarker marker2 = Markers.addMarker(projectDescription, msg, 2, "(" + releasePath.toString().replace(".", "\\.") + ")");
                if (marker2 != null) {
                    marker2.setAttribute("problemType", (Object)"release.path");
                }
                this.deviations = null;
                this.integration = null;
                this.release = null;
                monitor.done();
                return;
            }
            IFile propertiesFile = VersionUtil.getFile((IPath)releasePath, "properties");
            long propertiesTimeStamp = propertiesFile.getLocalTimeStamp();
            boolean formerDeviations = buildState.isDeviations();
            if (buildState.getPropertiesTimeStamp() != propertiesTimeStamp) {
                if (this.initReleaseProperties(propertiesFile)) {
                    delta = null;
                }
                buildState.setDeviations(this.deviations);
                buildState.setIntegration(this.integration);
                buildState.setRootProjects(this.rootProjects);
                buildState.setIgnoredReferences(this.ignoredReferences);
                buildState.setPropertiesTimeStamp(propertiesTimeStamp);
                if (formerDeviations && !this.deviations.booleanValue()) {
                    Markers.deleteAllMarkers((IResource)componentModelFile, "deviation");
                }
            } else {
                this.deviations = formerDeviations;
                this.integration = buildState.isIntegration();
                this.rootProjects = buildState.getRootProjects();
                this.ignoredReferences = buildState.getIgnoredReferences();
            }
            IPath componentModelPath = componentModelFile.getProjectRelativePath();
            boolean checkComponentModel = delta == null || delta.findMember(componentModelPath) != null;
            IElement element = IReleaseManager.INSTANCE.createElement(componentModel, true, false);
            for (IElement child : element.getAllChildren(this, this.release)) {
                IModel childProjectComponentModel;
                IProject childProject = this.getProject(child);
                if (childProject == null) continue;
                buildDependencies.add(childProject);
                if (!checkComponentModel || (childProjectComponentModel = VersionUtil.getComponentModel(childProject)) == null) continue;
                IResource underlyingResource = childProjectComponentModel.getUnderlyingResource();
                Markers.deleteAllMarkers(underlyingResource, "unreferenced.element");
            }
            Markers.deleteAllMarkers((IResource)componentModelFile, "unreferenced.element");
            if (Activator.getReleaseCheckMode(releasePathArg) == Activator.ReleaseCheckMode.FULL && !this.rootProjects.contains(project.getName()) && ((elementReference = this.resolveReferences(element)) == null || elementReference.isEmpty())) {
                this.addUnreferencedElementMarker(componentModelFile, element);
            }
            if (componentModel instanceof IPluginModelBase) {
                if (!this.arguments.isIgnoreSchemaBuilder()) {
                    if (delta == null || delta.findMember((IPath)DESCRIPTION_PATH) != null) {
                        this.checkSchemaBuilder((IPluginModelBase)componentModel, projectDescription);
                    }
                } else if (!oldVersionBuilderArguments.isIgnoreSchemaBuilder()) {
                    Markers.deleteAllMarkers((IResource)projectDescription, "schema.builder");
                }
                if (!this.arguments.isIgnoreDebugOptions()) {
                    if (delta == null || delta.findMember((IPath)OPTIONS_PATH) != null) {
                        this.checkDebugOptions((IPluginModelBase)componentModel);
                    }
                } else if (!oldVersionBuilderArguments.isIgnoreDebugOptions()) {
                    Markers.deleteAllMarkers((IResource)project.getFile((IPath)OPTIONS_PATH), "debug.option");
                }
                if (!this.arguments.isIgnoreMissingDependencyRanges()) {
                    if (checkComponentModel) {
                        this.checkDependencyRanges((IPluginModelBase)componentModel);
                    }
                } else if (!oldVersionBuilderArguments.isIgnoreMissingDependencyRanges()) {
                    Markers.deleteAllMarkers((IResource)this.getProject().getFile((IPath)MANIFEST_PATH), "lower.bound.version");
                }
                if (!this.arguments.isIgnoreLaxLowerBoundDependencyVersions()) {
                    if (checkComponentModel) {
                        this.checkLowerBoundVersions((IPluginModelBase)componentModel);
                    }
                } else if (!oldVersionBuilderArguments.isIgnoreLaxLowerBoundDependencyVersions()) {
                    Markers.deleteAllMarkers((IResource)this.getProject().getFile((IPath)MANIFEST_PATH), "lower.bound.version");
                }
                if (!this.arguments.isIgnoreMissingExportVersions()) {
                    if (checkComponentModel) {
                        this.checkPackageExports((IPluginModelBase)componentModel);
                    }
                } else if (!oldVersionBuilderArguments.isIgnoreMissingExportVersions()) {
                    Markers.deleteAllMarkers((IResource)this.getProject().getFile((IPath)MANIFEST_PATH), "export.version");
                }
                if (this.hasAPIToolsMarker((IPluginModelBase)componentModel)) {
                    return;
                }
            } else if (!this.arguments.isIgnoreFeatureNature()) {
                if (delta == null || delta.findMember((IPath)DESCRIPTION_PATH) != null) {
                    this.checkFeatureNature(projectDescription);
                }
            } else if (!oldVersionBuilderArguments.isIgnoreFeatureNature()) {
                Markers.deleteAllMarkers((IResource)projectDescription, "feature.nature");
            }
            if (!this.arguments.isIgnoreMalformedVersions()) {
                if (checkComponentModel && this.checkMalformedVersions(componentModel)) {
                    return;
                }
            } else if (!oldVersionBuilderArguments.isIgnoreMalformedVersions()) {
                Markers.deleteAllMarkers((IResource)componentModelFile, "malformed.version");
            }
            if (this.arguments.isCheckMavenPom()) {
                if (delta == null || delta.findMember((IPath)MAVEN_POM_PATH) != null || delta.findMember(componentModelPath) != null) {
                    this.checkMavenPom(element);
                }
            } else if (oldVersionBuilderArguments.isCheckMavenPom()) {
                Markers.deleteAllMarkers((IResource)project.getFile((IPath)MAVEN_POM_PATH), "maven.pom");
            }
            if ((releaseElement = this.release.getElements().get(element.trimVersion())) == null) {
                if (VersionUtil.DEBUG) {
                    System.out.println("Project has not been released: " + project.getName());
                }
                return;
            }
            Markers.deleteAllMarkers((IResource)componentModelFile, "version.nature");
            for (IElement child : element.getChildren()) {
                IProject childProject;
                IResource childComponentModelFile;
                IModel childComponentModel = ReleaseManager.INSTANCE.getComponentModel(child);
                if (childComponentModel == null || (childComponentModelFile = childComponentModel.getUnderlyingResource()) == null || (childProject = childComponentModelFile.getProject()).hasNature("org.eclipse.oomph.version.VersionNature")) continue;
                IElement.Type childType = child.getType();
                String name = child.getName();
                String label = childType.toString();
                String tag = childType.getTag();
                String msg = String.valueOf(label) + " '" + name + "' is missing the version management builder";
                IMarker marker3 = this.addFeatureChildMarker(componentModelFile, "version.nature", tag, name, msg, child.isLicenseFeature(), false, null, 2);
                marker3.setAttribute("quickFixNature", (Object)"org.eclipse.oomph.version.VersionNature");
                marker3.setAttribute("quickFixProject", (Object)childProject.getName());
            }
            Version elementVersion = element.getVersion();
            Version releaseVersion = releaseElement.getVersion();
            Version nextMicroVersion = this.getNextMicroVersion(releaseVersion);
            int comparison = releaseVersion.compareTo(elementVersion);
            if (comparison != 0 && this.deviations.booleanValue() && checkComponentModel) {
                this.addDeviationMarker(componentModelFile, element, releaseVersion);
            }
            Markers.deleteAllMarkers((IResource)componentModelFile, "component.version", "feature.closure");
            boolean microVersionProperlyIncreased = false;
            if (comparison < 0) {
                microVersionProperlyIncreased = nextMicroVersion.equals((Object)elementVersion);
                if (!microVersionProperlyIncreased) {
                    boolean noOtherIncrements;
                    boolean bl = noOtherIncrements = elementVersion.getMajor() == nextMicroVersion.getMajor() && elementVersion.getMinor() == nextMicroVersion.getMinor();
                    if (noOtherIncrements) {
                        this.addVersionMarker(componentModelFile, "Version should be " + nextMicroVersion, nextMicroVersion);
                    }
                }
                if (element.getType() == IElement.Type.PLUGIN) {
                    return;
                }
            }
            if (comparison > 0) {
                this.addVersionMarker(componentModelFile, "Version has been decreased after release " + releaseVersion, releaseVersion);
                return;
            }
            if (element.getType() == IElement.Type.FEATURE) {
                if (!this.arguments.isIgnoreFeatureContentRedundancy()) {
                    this.checkFeatureRedundancy(componentModelFile, element);
                }
                if (this.arguments.isCheckFeatureClosureCompleteness()) {
                    this.checkFeatureClosureCompleteness(componentModelFile, element);
                }
                if (!this.arguments.isIgnoreFeatureContentChanges()) {
                    ArrayList<Problem> problems = new ArrayList<Problem>();
                    this.checkFeatureReferences(componentModelFile, element, problems);
                    if (!problems.isEmpty()) {
                        this.createMarkers(componentModelFile, problems, ComponentReferenceType.UNRESOLVED);
                        return;
                    }
                    ComponentReferenceType change = this.checkFeatureContentChanges(element, releaseElement, problems);
                    if (change != ComponentReferenceType.UNCHANGED) {
                        Version nextFeatureVersion = this.getNextFeatureVersion(releaseVersion, nextMicroVersion, change);
                        if (elementVersion.compareTo(nextFeatureVersion) < 0) {
                            marker = this.addVersionMarker(componentModelFile, "Version must be increased to " + nextFeatureVersion + " because the feature's references have changed", nextFeatureVersion);
                            if (marker != null) {
                                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.content.changes");
                            }
                            this.createMarkers(componentModelFile, problems, change);
                        }
                        return;
                    }
                    if (!elementVersion.equals((Object)releaseVersion)) {
                        return;
                    }
                }
            }
            if (microVersionProperlyIncreased || elementVersion.getMajor() > nextMicroVersion.getMajor() || elementVersion.getMinor() > nextMicroVersion.getMinor()) {
                return;
            }
            String validatorClassName = this.arguments.getValidatorClassName();
            if (validatorClassName == null) {
                validatorClassName = "org.eclipse.oomph.version.digest.DigestValidator$BuildModel";
            }
            try {
                Markers.deleteAllMarkers((IResource)projectDescription, "validator.class");
                Class<?> c = Class.forName(validatorClassName, true, VersionBuilder.class.getClassLoader());
                validator = (VersionValidator)c.newInstance();
                if (VersionUtil.DEBUG) {
                    System.out.println(String.valueOf(validator.getClass().getName()) + ": " + project.getName());
                }
            }
            catch (Exception ex) {
                String msg = String.valueOf(ex.getLocalizedMessage()) + ": " + validatorClassName;
                marker = Markers.addMarker(projectDescription, msg, 2, ".*(" + validatorClassName + ").*");
                if (marker != null) {
                    marker.setAttribute("problemType", (Object)"validator.class");
                }
                this.deviations = null;
                this.integration = null;
                this.release = null;
                monitor.done();
                return;
            }
            try {
                String validatorVersion = validator.getVersion();
                if (!VersionUtil.equals(validatorClassName, buildState.getValidatorClass()) || !VersionUtil.equals(validatorVersion, buildState.getValidatorVersion())) {
                    buildState.setValidatorState(null);
                    delta = null;
                }
                buildState.setValidatorClass(validatorClassName);
                buildState.setValidatorVersion(validatorVersion);
                validator.updateBuildState(buildState, this.release, project, delta, componentModel, monitor);
                if (buildState.isChangedSinceRelease()) {
                    this.addVersionMarker(componentModelFile, "Version must be increased to " + nextMicroVersion + " because the project's contents have changed", nextMicroVersion);
                }
            }
            catch (Exception ex) {
                try {
                    if (validator != null) {
                        validator.abort(buildState, project, ex, monitor);
                    }
                    Activator.log(ex);
                }
                catch (Exception ignore) {
                    Activator.log(ignore);
                }
            }
        }
        finally {
            this.deviations = null;
            this.integration = null;
            this.release = null;
            monitor.done();
        }
    }

    private void createMarkers(IFile componentModelFile, List<Problem> problems, ComponentReferenceType change) {
        for (Problem problem : problems) {
            ComponentReferenceType componentReferenceType = problem.getComponentReferenceType();
            if (componentReferenceType.ordinal() < change.ordinal()) continue;
            this.addIncludeMarker(componentModelFile, problem.getElement(), problem.getSeverity(), problem.getVersion(), componentReferenceType);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAPIToolsMarker(IPluginModelBase pluginModel) {
        try {
            IResource manifest = pluginModel.getUnderlyingResource();
            IMarker[] iMarkerArray = manifest.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker marker = iMarkerArray[n2];
                if (marker.getType().startsWith("org.eclipse.pde.api.tools")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.log(ex);
        }
        return false;
    }

    private boolean initReleaseProperties(IFile propertiesFile) throws CoreException, IOException {
        if (propertiesFile.exists()) {
            InputStream contents = null;
            try {
                contents = propertiesFile.getContents();
                Properties properties = new Properties();
                properties.load(contents);
                this.deviations = Boolean.valueOf(properties.getProperty(DEVIATIONS_PROPERTY_KEY, "false"));
                this.rootProjects = new HashSet<String>();
                for (String rootProject : Arrays.asList(properties.getProperty(ROOT_PROJECTS_KEY, "").split(" "))) {
                    this.rootProjects.add(rootProject.replace("\\ ", " ").replace("\\\\", "\\"));
                }
                this.ignoredReferences = new HashSet<String>();
                for (String ignoredReference : Arrays.asList(properties.getProperty(IGNORED_REFERENCES_KEY, "").split(" "))) {
                    this.ignoredReferences.add(ignoredReference.replace("\\ ", " ").replace("\\\\", "\\"));
                }
                Boolean newValue = Boolean.valueOf(properties.getProperty(INTEGRATION_PROPERTY_KEY, "true"));
                if (!newValue.equals(this.integration)) {
                    this.integration = newValue;
                    return true;
                }
                return false;
            }
            finally {
                IOUtil.closeSilent((Closeable)contents);
            }
        }
        this.deviations = false;
        this.integration = true;
        this.rootProjects = new HashSet<String>();
        this.ignoredReferences = new HashSet<String>();
        String lineDelimiter = VersionUtil.getLineDelimiter(propertiesFile);
        String contents = "baseline.for.integration = " + this.integration + lineDelimiter + DEVIATIONS_PROPERTY_KEY + " = " + this.deviations + lineDelimiter + ROOT_PROJECTS_KEY + " = ";
        String charsetName = propertiesFile.getCharset();
        byte[] bytes = contents.getBytes(charsetName);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        propertiesFile.create((InputStream)bais, true, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    private Version getNextMicroVersion(Version releaseVersion) {
        return new Version(releaseVersion.getMajor(), releaseVersion.getMinor(), releaseVersion.getMicro() + (this.integration != false ? 100 : 1));
    }

    private Version getNextFeatureVersion(Version releaseVersion, Version nextImplementationVersion, ComponentReferenceType change) {
        switch (change) {
            case MAJOR_CHANGED: 
            case REMOVED: {
                return new Version(releaseVersion.getMajor() + 1, 0, 0);
            }
            case MINOR_CHANGED: 
            case ADDED: {
                return new Version(releaseVersion.getMajor(), releaseVersion.getMinor() + 1, 0);
            }
            case MICRO_CHANGED: {
                return nextImplementationVersion;
            }
        }
        throw new IllegalArgumentException();
    }

    private void checkFeatureReferences(IFile file, IElement element, List<Problem> problems) {
        for (IElement child : element.getChildren()) {
            IElement resolvedChild;
            boolean hasSpecificVersion;
            boolean bl = hasSpecificVersion = !child.isVersionUnresolved();
            if (!hasSpecificVersion || (resolvedChild = this.resolveElement(child)) != null) continue;
            resolvedChild = this.resolveElement(child.trimVersion());
            Version resolvedChildVersion = resolvedChild == null ? null : resolvedChild.getVersion();
            this.addProblem(child, 2, ComponentReferenceType.UNRESOLVED, resolvedChildVersion, problems);
        }
    }

    private void checkFeatureRedundancy(IFile file, IElement element) {
        int i = 0;
        List<IElement> children = element.getChildren();
        for (IElement pluginChild : children) {
            if (pluginChild.getType() == IElement.Type.PLUGIN) {
                for (IElement featureChild : children) {
                    Set<IElement> allChildren;
                    if (featureChild.getType() != IElement.Type.FEATURE || (featureChild = this.resolveElement(featureChild)) == null || !(allChildren = featureChild.getAllChildren(this, this.release)).contains(pluginChild)) continue;
                    try {
                        this.addRedundancyMarker(file, pluginChild, featureChild);
                    }
                    catch (Exception ex) {
                        Activator.log(ex);
                    }
                }
                if (children.indexOf(pluginChild) != i) {
                    this.addRedundancyMarker(file, pluginChild, null);
                }
            }
            ++i;
        }
    }

    private void checkFeatureClosureCompleteness(IFile file, IElement element) {
        List<IElement> children = element.getChildren();
        HashSet<IElement> plugins = new HashSet<IElement>();
        HashMap<IElement, IElement> closure = new HashMap<IElement, IElement>();
        for (IElement iElement : children) {
            if (iElement.getType() == IElement.Type.FEATURE) {
                this.collectFeatureClosure(iElement, iElement, closure);
                continue;
            }
            plugins.add(iElement);
        }
        for (Map.Entry entry : closure.entrySet()) {
            IElement plugin = (IElement)entry.getKey();
            if (!plugins.add(plugin)) continue;
            try {
                IElement mainFeature = (IElement)entry.getValue();
                this.addFeatureClosureMarker(file, plugin, mainFeature);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
    }

    private void collectFeatureClosure(IElement feature, IElement mainFeature, Map<IElement, IElement> closure) {
        if ((feature = this.resolveElement(feature)) != null) {
            for (IElement child : feature.getChildren()) {
                if (child.getType() == IElement.Type.PLUGIN) {
                    if (closure.containsKey(child)) continue;
                    closure.put(child, mainFeature);
                    continue;
                }
                this.collectFeatureClosure(child, mainFeature, closure);
            }
        }
    }

    private ComponentReferenceType checkFeatureContentChanges(IElement element, IElement releasedElement, List<Problem> problems) {
        ComponentReferenceType biggestChange = ComponentReferenceType.UNCHANGED;
        Set<IElement> allChildren = element.getAllChildren(this, this.release);
        for (IElement child : allChildren) {
            ComponentReferenceType change = this.checkFeatureContentChanges(element, releasedElement, child, problems);
            biggestChange = ComponentReferenceType.values()[Math.max(biggestChange.ordinal(), change.ordinal())];
        }
        for (IElement releasedElementsChild : releasedElement.getAllChildren(this.release, this)) {
            IElement trimmedVersion = releasedElementsChild.trimVersion();
            if (allChildren.contains(trimmedVersion) || !this.addProblem(releasedElementsChild, 1, ComponentReferenceType.REMOVED, null, problems)) continue;
            biggestChange = ComponentReferenceType.REMOVED;
        }
        return biggestChange;
    }

    private ComponentReferenceType checkFeatureContentChanges(IElement element, IElement releasedElement, IElement childElement, List<Problem> problems) {
        IElement releasedElementsChild = releasedElement.getChild(this.release, this, childElement);
        if (releasedElementsChild == null && (releasedElementsChild = releasedElement.getChild(this.release, this, childElement.trimVersion())) == null && this.addProblem(childElement, 1, ComponentReferenceType.ADDED, null, problems)) {
            return ComponentReferenceType.ADDED;
        }
        IElement childsReleasedElement = this.release.getElements().get(childElement);
        if (childsReleasedElement == null && (childsReleasedElement = this.release.getElements().get(childElement.trimVersion())) == null) {
            return ComponentReferenceType.UNCHANGED;
        }
        if (!childsReleasedElement.isVersionUnresolved()) {
            Version releasedVersion = childsReleasedElement.getVersion();
            Version version = childElement.trimVersion().getResolvedVersion();
            if (!version.equals((Object)Version.emptyVersion)) {
                if (version.getMajor() != releasedVersion.getMajor() && this.addProblem(childsReleasedElement, 1, ComponentReferenceType.MAJOR_CHANGED, version, problems)) {
                    return ComponentReferenceType.MAJOR_CHANGED;
                }
                if (version.getMinor() != releasedVersion.getMinor() && this.addProblem(childsReleasedElement, 1, ComponentReferenceType.MINOR_CHANGED, version, problems)) {
                    return ComponentReferenceType.MINOR_CHANGED;
                }
                if (version.getMicro() != releasedVersion.getMicro() && this.addProblem(childsReleasedElement, 1, ComponentReferenceType.MICRO_CHANGED, version, problems)) {
                    return ComponentReferenceType.MICRO_CHANGED;
                }
            }
        }
        return ComponentReferenceType.UNCHANGED;
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
        }
        return parserFactory.newSAXParser();
    }

    private void checkMavenPom(IElement element) throws CoreException {
        final IFile file = this.getProject().getFile((IPath)MAVEN_POM_PATH);
        if (file.isAccessible()) {
            Markers.deleteAllMarkers((IResource)file, "maven.pom");
            final String componentName = element.getName();
            final String componentVersion = StringUtil.removeSuffix((String)element.getVersion().toString(), (String[])new String[]{".qualifier"});
            InputStream contents = null;
            try {
                try {
                    contents = file.getContents();
                    SAXParser parser = this.getParser();
                    parser.parse((InputStream)new BufferedInputStream(contents), new DefaultHandler(){
                        private Locator locator;
                        private int level;
                        private int lineNumber;
                        private int found;
                        private StringBuilder builder;

                        public void setDocumentLocator(Locator locator) {
                            this.locator = locator;
                        }

                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            if (++this.level == 2 && ("artifactId".equals(qName) || "version".equals(qName))) {
                                this.lineNumber = this.locator.getLineNumber();
                                this.builder = new StringBuilder();
                            }
                        }

                        public void characters(char[] ch, int start, int length) throws SAXException {
                            if (this.builder != null) {
                                this.builder.append(ch, start, length);
                            }
                        }

                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            --this.level;
                            if (this.builder != null) {
                                String textContent = this.builder.toString().replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim();
                                if ("artifactId".equals(qName)) {
                                    if (!textContent.equals(componentName)) {
                                        this.addMarker(file, "Maven artifactId '" + textContent + "' is different from plug-in name '" + componentName + "'", textContent, componentName);
                                    }
                                } else {
                                    String version = StringUtil.removeSuffix((String)textContent, (String[])new String[]{"-SNAPSHOT"});
                                    if (!version.equals(componentVersion)) {
                                        this.addMarker(file, "Maven version '" + version + "' is different from plug-in version '" + componentVersion + "'", version, componentVersion);
                                    }
                                }
                                if (++this.found == 2) {
                                    throw new SAXException("STOP-EARLY");
                                }
                            }
                            this.builder = null;
                        }

                        private void addMarker(IFile file2, String message, String pomValue, String componentValue) {
                            StringBuilder regexBuilder = new StringBuilder();
                            int i = 1;
                            while (i < this.lineNumber) {
                                regexBuilder.append('$');
                                ++i;
                            }
                            regexBuilder.append(".*(" + pomValue.replace(".", "\\.") + ")");
                            String regex = regexBuilder.toString();
                            try {
                                IMarker marker = Markers.addMarker(file2, message, 2, regex);
                                if (marker != null) {
                                    marker.setAttribute("problemType", (Object)"maven.pom");
                                    marker.setAttribute("quickFixPattern", (Object)regex);
                                    marker.setAttribute("quickFixReplacement", (Object)componentValue);
                                    marker.setAttribute("quickFixConfigureOption", (Object)"check.maven.pom");
                                    marker.setAttribute("quickFixConfigureValue", (Object)"false");
                                }
                            }
                            catch (Exception ex) {
                                Activator.log(ex);
                            }
                        }
                    });
                }
                catch (SAXException ex) {
                    if (!"STOP-EARLY".equals(ex.getMessage())) {
                        Activator.log(ex);
                    }
                    IOUtil.closeSilent((Closeable)contents);
                }
                catch (Exception ex) {
                    Activator.log(ex);
                    IOUtil.closeSilent((Closeable)contents);
                }
            }
            finally {
                IOUtil.closeSilent((Closeable)contents);
            }
        }
    }

    private boolean addProblem(IElement element, int severity, ComponentReferenceType componentReferenceType, Version version, List<Problem> problems) {
        String elementName = element.getName();
        if (!this.ignoredReferences.contains(elementName)) {
            problems.add(new Problem(element, severity, componentReferenceType, version));
            return true;
        }
        return false;
    }

    private IProject getProject(IElement element) {
        String name = element.getName();
        if (element.getType() == IElement.Type.PLUGIN) {
            return this.getPluginProject(name);
        }
        return this.getFeatureProject(name);
    }

    private IProject getPluginProject(String name) {
        IResource resource;
        IPluginModelBase pluginModel = PluginRegistry.findModel((String)name);
        if (pluginModel != null && (resource = pluginModel.getUnderlyingResource()) != null) {
            return resource.getProject();
        }
        return null;
    }

    private IProject getFeatureProject(String name) {
        IFeatureModel[] featureModels;
        IFeatureModel[] iFeatureModelArray = featureModels = PDECore.getDefault().getFeatureModelManager().getWorkspaceModels();
        int n = featureModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel featureModel = iFeatureModelArray[n2];
            IResource resource = featureModel.getUnderlyingResource();
            if (resource != null && featureModel.getFeature().getId().equals(name)) {
                return resource.getProject();
            }
            ++n2;
        }
        return null;
    }

    private boolean checkMalformedVersions(IModel componentModel) throws CoreException {
        IResource underlyingResource = componentModel.getUnderlyingResource();
        if (underlyingResource != null) {
            Markers.deleteAllMarkers(underlyingResource, "malformed.version");
            IProject project = underlyingResource.getProject();
            if (project.isAccessible()) {
                IFile file = null;
                String regex = null;
                if (componentModel instanceof IPluginModelBase) {
                    file = project.getFile((IPath)MANIFEST_PATH);
                    regex = "Bundle-Version: *(\\d+(\\.\\d+(\\.\\d+(\\.[-_a-zA-Z0-9]+)?)?)?)";
                } else {
                    file = project.getFile((IPath)FEATURE_PATH);
                    regex = "feature.*?version\\s*=\\s*[\"'](\\d+(\\.\\d+(\\.\\d+(\\.[-_a-zA-Z0-9]+)?)?)?)";
                }
                if (file.exists()) {
                    try {
                        String content = VersionUtil.getContents(file);
                        Pattern pattern = Pattern.compile(regex, 40);
                        Matcher matcher = pattern.matcher(content);
                        if (matcher.find()) {
                            String version = matcher.group(1);
                            if (matcher.groupCount() < 4 || !".qualifier".equals(matcher.group(4))) {
                                Version expectedVersion = new Version(version);
                                this.addMalformedVersionMarker(file, regex, new Version(expectedVersion.getMajor(), expectedVersion.getMinor(), expectedVersion.getMicro(), "qualifier"));
                                return true;
                            }
                        }
                    }
                    catch (Exception ex) {
                        Activator.log(ex);
                    }
                }
            }
        }
        return false;
    }

    private void checkDependencyRanges(IPluginModelBase pluginModel) throws CoreException, IOException {
        VersionRange range;
        BundleDescription description = pluginModel.getBundleDescription();
        if (description == null) {
            return;
        }
        IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
        Markers.deleteAllMarkers((IResource)file, "dependency.range");
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            range = requiredBundle.getVersionRange();
            if (this.isUnspecified(this.getMaximum(range))) {
                this.addRequireMarker(file, requiredBundle.getName(), "dependency must specify a version range");
            } else {
                if (!range.getIncludeMinimum()) {
                    this.addRequireMarker(file, requiredBundle.getName(), "dependency range must include the minimum");
                }
                if (range.getIncludeMaximum()) {
                    this.addRequireMarker(file, requiredBundle.getName(), "dependency range must not include the maximum");
                }
            }
            ++n2;
        }
        bundleSpecificationArray = description.getImportPackages();
        n = bundleSpecificationArray.length;
        n2 = 0;
        while (n2 < n) {
            BundleSpecification importPackage = bundleSpecificationArray[n2];
            range = importPackage.getVersionRange();
            if (this.isUnspecified(this.getMaximum(range))) {
                this.addImportMarker(file, importPackage.getName(), "dependency must specify a version range");
            } else {
                if (!range.getIncludeMinimum()) {
                    this.addImportMarker(file, importPackage.getName(), "dependency range must include the minimum");
                }
                if (range.getIncludeMaximum()) {
                    this.addImportMarker(file, importPackage.getName(), "dependency range must not include the maximum");
                }
            }
            ++n2;
        }
    }

    private void checkLowerBoundVersions(IPluginModelBase pluginModel) throws CoreException, IOException {
        BundleDescription description = pluginModel.getBundleDescription();
        if (description == null) {
            return;
        }
        IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
        Markers.deleteAllMarkers((IResource)file, "lower.bound.version");
        String releasePath = this.arguments.getReleasePath();
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            this.checkLowerBoundVersions(file, releasePath, (VersionConstraint)requiredBundle, "bundle-version");
            ++n2;
        }
        bundleSpecificationArray = description.getImportPackages();
        n = bundleSpecificationArray.length;
        n2 = 0;
        while (n2 < n) {
            BundleSpecification importPackage = bundleSpecificationArray[n2];
            this.checkLowerBoundVersions(file, releasePath, (VersionConstraint)importPackage, "version");
            ++n2;
        }
    }

    void checkLowerBoundVersions(IFile file, String releasePath, VersionConstraint versionConstraint, String versionAttribute) {
        BaseDescription supplier;
        VersionRange requiredVersionRange = versionConstraint.getVersionRange();
        if (!requiredVersionRange.isEmpty() && (supplier = versionConstraint.getSupplier()) != null) {
            IProject project;
            VersionBuilderArguments versionBuilderArguments;
            String elementReleasePath;
            IResource underlyingResource;
            IModel componentModel;
            IElement element;
            BundleDescription supplierBundle;
            Version version = supplier.getVersion();
            version = new Version(version.getMajor(), version.getMinor(), version.getMicro());
            Version minimumRequiredVersion = requiredVersionRange.getMinimum();
            if (!minimumRequiredVersion.equals((Object)version) && (supplierBundle = supplier.getSupplier()) != null && (element = this.resolveElement(new Element(IElement.Type.PLUGIN, supplierBundle.getName()))) != null && (componentModel = ReleaseManager.INSTANCE.getComponentModel(element)) != null && (underlyingResource = componentModel.getUnderlyingResource()) != null && underlyingResource.isAccessible() && releasePath.equals(elementReleasePath = (versionBuilderArguments = new VersionBuilderArguments(project = underlyingResource.getProject())).getReleasePath())) {
                String name = versionConstraint.getName();
                VersionRange expectedVersionRange = new VersionRange(element.getVersion(), true, requiredVersionRange.getRight(), requiredVersionRange.getIncludeMaximum());
                this.addLaxLowerBoundMarker(file, name, "dependency range minimum must be " + version, expectedVersionRange, versionAttribute);
            }
        }
    }

    private Version getMaximum(VersionRange range) {
        DeprecationUtil.someDeprecatedCode();
        return range.getMaximum();
    }

    private boolean isUnspecified(Version version) {
        if (version.getMajor() != Integer.MAX_VALUE) {
            return false;
        }
        if (version.getMinor() != Integer.MAX_VALUE) {
            return false;
        }
        return version.getMicro() == Integer.MAX_VALUE;
    }

    private void checkPackageExports(IPluginModelBase pluginModel) throws CoreException, IOException {
        IFile file = this.getProject().getFile((IPath)MANIFEST_PATH);
        Markers.deleteAllMarkers((IResource)file, "export.version");
        BundleDescription description = pluginModel.getBundleDescription();
        String bundleName = description.getSymbolicName();
        Version bundleVersion = VersionUtil.normalize(description.getVersion());
        ExportPackageDescription[] exportPackageDescriptionArray = description.getExportPackages();
        int n = exportPackageDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version packageVersion;
            ExportPackageDescription packageExport = exportPackageDescriptionArray[n2];
            String packageName = packageExport.getName();
            if (this.isBundlePackage(packageName, bundleName) && (packageVersion = packageExport.getVersion()) != null && !packageVersion.equals((Object)Version.emptyVersion) && !packageVersion.equals((Object)bundleVersion)) {
                this.addExportMarker(file, packageName, bundleVersion);
            }
            ++n2;
        }
    }

    private void checkFeatureNature(IFile file) throws CoreException, IOException {
        IProject project = file.getProject();
        Markers.deleteAllMarkers((IResource)project, "feature.nature");
        IProjectDescription description = project.getDescription();
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if ("org.eclipse.pde.FeatureBuilder".equals(command.getBuilderName()) && project.hasNature("org.eclipse.pde.FeatureNature")) {
                return;
            }
            ++n2;
        }
        String regex = "<buildSpec\\s*>()";
        String msg = "Feature builder is missing";
        IMarker marker = Markers.addMarker(file, msg, 1, regex);
        marker.setAttribute("problemType", (Object)"feature.nature");
        marker.setAttribute("quickFixNature", (Object)"org.eclipse.pde.FeatureNature");
        marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.nature");
    }

    private void checkSchemaBuilder(IPluginModelBase pluginModel, IFile file) throws CoreException, IOException {
        IPluginExtensionPoint[] extensionPoints;
        Markers.deleteAllMarkers((IResource)file, "schema.builder");
        IProjectDescription description = this.getProject().getDescription();
        IPluginBase pluginBase = pluginModel.getPluginBase();
        if (pluginBase != null && (extensionPoints = pluginBase.getExtensionPoints()) != null & extensionPoints.length != 0) {
            ICommand[] iCommandArray = description.getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if ("org.eclipse.pde.SchemaBuilder".equals(command.getBuilderName())) {
                    return;
                }
                ++n2;
            }
            String regex = "<buildCommand\\s*>\\s*<name>\\s*org.eclipse.pde.ManifestBuilder\\s*</name>.*?</buildCommand>(\\s*)";
            String msg = "Schema builder is missing";
            IMarker marker = Markers.addMarker(file, msg, 1, regex);
            marker.setAttribute("problemType", (Object)"schema.builder");
            marker.setAttribute("quickFixPattern", (Object)regex);
            String lineDelimiter = VersionUtil.getLineDelimiter(file);
            marker.setAttribute("quickFixReplacement", (Object)(String.valueOf(lineDelimiter) + "\t\t<buildCommand>" + lineDelimiter + "\t\t\t<name>org.eclipse.pde.SchemaBuilder</name>" + lineDelimiter + "\t\t\t<arguments>" + lineDelimiter + "\t\t\t</arguments>" + lineDelimiter + "\t\t</buildCommand>" + lineDelimiter + "\t\t"));
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.schema.builder");
            return;
        }
        ICommand[] iCommandArray = description.getBuildSpec();
        int n = iCommandArray.length;
        int n3 = 0;
        while (n3 < n) {
            ICommand command = iCommandArray[n3];
            if ("org.eclipse.pde.SchemaBuilder".equals(command.getBuilderName())) {
                String regex = "(<buildCommand\\s*>\\s*<name>\\s*org.eclipse.pde.SchemaBuilder\\s*</name>.*?</buildCommand>)\\s*";
                String msg = "No schema builder is needed because no extension point is declared";
                IMarker marker = Markers.addMarker(file, msg, 1, regex);
                marker.setAttribute("problemType", (Object)"schema.builder");
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.schema.builder");
                break;
            }
            ++n3;
        }
    }

    private void checkDebugOptions(IPluginModelBase pluginModel) throws CoreException, IOException {
        IFile file = this.getProject().getFile((IPath)OPTIONS_PATH);
        if (file.isAccessible()) {
            Markers.deleteAllMarkers((IResource)file, "debug.option");
            String symbolicName = pluginModel.getBundleDescription().getSymbolicName();
            String content = VersionUtil.getContents(file);
            Matcher matcher = DEBUG_OPTION_PATTERN.matcher(content);
            while (matcher.find()) {
                String pluginID = matcher.group(2);
                if (symbolicName.equals(pluginID)) continue;
                String prefix = matcher.group(1);
                String suffix = "/" + (String.valueOf(matcher.group(3)) + matcher.group(4)).replace(".", "\\.");
                pluginID = pluginID.replace(".", "\\.");
                String regex = String.valueOf(prefix) + "(" + pluginID + ")" + suffix;
                String msg = "Debug option should be '" + symbolicName + "/" + matcher.group(3) + "'";
                IMarker marker = Markers.addMarker(file, msg, 2, regex);
                marker.setAttribute("problemType", (Object)"debug.option");
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixReplacement", (Object)symbolicName);
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.debug.options");
            }
        }
    }

    private boolean isBundlePackage(String packageName, String bundleName) {
        if (packageName.startsWith(bundleName)) {
            return true;
        }
        int lastDot = bundleName.lastIndexOf(46);
        if (lastDot != -1) {
            String bundleStart = bundleName.substring(0, lastDot);
            String bundleEnd = bundleName.substring(lastDot + 1);
            if (packageName.startsWith(String.valueOf(bundleStart) + ".internal." + bundleEnd)) {
                return true;
            }
            if (packageName.startsWith(String.valueOf(bundleStart) + ".spi." + bundleEnd)) {
                return true;
            }
        }
        return false;
    }

    private void addRequireMarker(IFile file, String name, String message) {
        try {
            String regex = String.valueOf(name.replace(".", "\\.")) + ";bundle-version=\"([^\\\"]*)\"";
            IMarker marker = Markers.addMarker(file, "'" + name + "' " + message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"dependency.range");
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.missing.dependency.ranges");
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addLaxLowerBoundMarker(IFile file, String name, String message, VersionRange versionRange, String versionAttribute) {
        try {
            String regex = String.valueOf(name.replace(".", "\\.")) + ";" + versionAttribute + "=\"([^\\\"]*)\"";
            IMarker marker = Markers.addMarker(file, "'" + name + "' " + message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"lower.bound.version");
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixReplacement", (Object)versionRange.toString());
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.lower.bound.dependency.ranges");
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addImportMarker(IFile file, String name, String message) {
        try {
            String regex = String.valueOf(name.replace(".", "\\.")) + ";version=\"([^\\\"]*)\"";
            IMarker marker = Markers.addMarker(file, "'" + name + "' " + message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"dependency.range");
                marker.setAttribute("quickFixConfigureOption", (Object)"ignore.missing.dependency.ranges");
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addExportMarker(IFile file, String name, Version bundleVersion) {
        String versionString = bundleVersion.toString();
        try {
            String message = "Export of package '" + name + "' should have the version " + versionString;
            String regex = String.valueOf(name.replace(".", "\\.")) + ";version=\"([0123456789\\.]*)\"";
            IMarker marker = Markers.addMarker(file, message, 2, regex);
            marker.setAttribute("problemType", (Object)"export.version");
            marker.setAttribute("quickFixPattern", (Object)regex);
            marker.setAttribute("quickFixReplacement", (Object)versionString);
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.missing.export.versions");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addMalformedVersionMarker(IFile file, String regex, Version version) {
        try {
            String versionString = version.toString();
            IMarker marker = Markers.addMarker(file, "The version should be of the form '" + versionString + "'", 2, regex);
            marker.setAttribute("problemType", (Object)"malformed.version");
            marker.setAttribute("quickFixPattern", (Object)regex);
            marker.setAttribute("quickFixReplacement", (Object)versionString);
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.malformed.versions");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private IMarker addUnreferencedElementMarker(IFile file, IElement element) {
        try {
            String type = element.getType() == IElement.Type.PLUGIN ? "Plug-in" : "Feature";
            String message = String.valueOf(type) + " '" + element.getName() + "' is not referenced by any other feature";
            String regex = file.getFullPath().lastSegment().equals("MANIFEST.MF") ? "Bundle-SymbolicName: *([^;\n\r]*)" : "feature.*?id\\s*=\\s*[\"']([^\"']*)";
            IMarker marker = Markers.addMarker(file, message, 2, regex);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"unreferenced.element");
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private IMarker addDeviationMarker(IFile file, IElement element, Version releasedVersion) {
        try {
            String type = element.getType() == IElement.Type.PLUGIN ? "Plug-in" : "Feature";
            Version version = element.getVersion();
            String message = String.valueOf(type) + " '" + element.getName() + "' has been changed from " + releasedVersion + " to " + version;
            IMarker marker = this.addVersionMarker(file, message, version, 0);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"deviation");
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private IMarker addVersionMarker(IFile file, String message, Version version) {
        try {
            IMarker marker = this.addVersionMarker(file, message, version, 2);
            if (marker != null) {
                marker.setAttribute("problemType", (Object)"component.version");
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private IMarker addVersionMarker(IFile file, String message, Version version, int severity) {
        try {
            String regex = file.getFullPath().lastSegment().equals("MANIFEST.MF") ? "Bundle-Version: *(\\d+(\\.\\d+(\\.\\d+)?)?)" : "feature.*?version\\s*=\\s*[\"'](\\d+(\\.\\d+(\\.\\d+)?)?)";
            IMarker marker = Markers.addMarker(file, message, severity, regex);
            if (severity != 0) {
                marker.setAttribute("quickFixPattern", (Object)regex);
                marker.setAttribute("quickFixReplacement", (Object)version.toString());
            }
            return marker;
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private void addRedundancyMarker(IFile file, IElement pluginChild, IElement featureChild) {
        try {
            String name = pluginChild.getName();
            String cause = featureChild != null ? "feature '" + featureChild.getName() + "' already includes it" : " because it occurs more than once in this feature";
            String msg = "Plug-in reference '" + name + "' is redundant because " + cause;
            IMarker marker = this.addFeatureChildMarker(file, "component.version", "plugin", name, msg, false, true, null, 1);
            marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.content.redundancy");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addFeatureClosureMarker(IFile file, IElement pluginChild, IElement featureChild) {
        try {
            String pluginName = pluginChild.getName();
            String featureName = featureChild.getName();
            String msg = "Plug-in '" + pluginName + "' should be referenced because feature '" + featureName + "' contains it";
            String lineDelimiter = VersionUtil.getLineDelimiter(file);
            IMarker marker = this.addFeatureChildMarker(file, "feature.closure", "includes", featureName, msg, false, true, null, 1);
            marker.setAttribute("quickFixPattern", (Object)("(([ \t]*)<includes(\\s*)id\\s*=\\s*\"" + featureName + "\")"));
            marker.setAttribute("quickFixReplacement", (Object)("\\2<plugin\\3id=\"" + pluginName + "\"\\3download-size=\"0\"\\3install-size=\"0\"\\3version=\"0.0.0\"\\3unpack=\"false\"/>" + lineDelimiter + lineDelimiter + "\\1"));
            marker.setAttribute("quickFixConfigureOption", (Object)"check.feature.closure.completeness");
            marker.setAttribute("quickFixConfigureValue", (Object)"false");
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void addIncludeMarker(IFile file, IElement element, int severity, Version version, ComponentReferenceType componentReferenceType) {
        try {
            String tag;
            String label;
            if (element.getType() == IElement.Type.PLUGIN) {
                label = "Plug-in";
                tag = "plugin";
            } else {
                label = "Feature";
                tag = "includes";
            }
            String name = element.getName();
            if (componentReferenceType == ComponentReferenceType.REMOVED) {
                String msg = String.valueOf(label) + " reference '" + name + "' has been removed";
                IMarker marker = Markers.addMarker((IResource)file, msg, severity);
                marker.setAttribute("problemType", (Object)"component.version");
                marker.setAttribute("quickFixReference", (Object)name);
            } else {
                String msg;
                Version replacementVersion = null;
                switch (componentReferenceType) {
                    case UNRESOLVED: {
                        if (version == null) {
                            msg = String.valueOf(label) + " reference '" + name + "' cannot be resolved ";
                            break;
                        }
                        msg = String.valueOf(label) + " reference '" + name + "' resolves to the different version " + version;
                        replacementVersion = version;
                        break;
                    }
                    case ADDED: {
                        msg = String.valueOf(label) + " reference '" + name + "' has been added with " + element.getResolvedVersion();
                        break;
                    }
                    case MICRO_CHANGED: 
                    case MINOR_CHANGED: 
                    case MAJOR_CHANGED: {
                        msg = String.valueOf(label) + " reference '" + name + "' has been changed from " + element.getVersion() + " to " + version;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("This should be unreachable code");
                    }
                }
                IMarker marker = this.addFeatureChildMarker(file, "component.version", tag, name, msg, element.isLicenseFeature(), componentReferenceType == ComponentReferenceType.ADDED, replacementVersion, severity);
                if (severity == 2) {
                    marker.setAttribute("quickFixConfigureOption", (Object)"ignore.feature.content.changes");
                } else {
                    marker.setAttribute("quickFixReference", (Object)name);
                }
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private IMarker addFeatureChildMarker(IFile file, String problemType, String tag, String name, String msg, boolean isLicense, boolean hasQuickFix, Version version, int severity) throws CoreException, IOException {
        String regex = isLicense ? "\\s+.*?license-feature-version\\s*=\\s*[\"']([^\"']*)[\"']" : (version != null ? "[ \\t\\x0B\\f]*<" + tag + "\\s+[^<]*id\\s*=\\s*[\"']" + name.replace(".", "\\.") + "[\"'].*?version\\s*=\\s*[\"']([^\"']*)[\"'].*?/>([ \\t\\x0B\\f]*[\\n\\r])*" : "[ \\t\\x0B\\f]*<" + tag + "\\s+[^<]*id\\s*=\\s*[\"'](" + name.replace(".", "\\.") + ")[\"'].*?/>([ \\t\\x0B\\f]*[\\n\\r])*");
        IMarker marker = Markers.addMarker(file, msg, severity, regex);
        marker.setAttribute("problemType", (Object)problemType);
        if (version != null) {
            marker.setAttribute("quickFixPattern", (Object)regex);
            marker.setAttribute("quickFixReplacement", (Object)version.toString());
            marker.setAttribute("quickFixAlternativeReplacement", (Object)"0.0.0");
        } else if (hasQuickFix) {
            marker.setAttribute("quickFixPattern", (Object)regex);
        }
        return marker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ComponentReferenceType {
        UNRESOLVED,
        UNCHANGED,
        MICRO_CHANGED,
        MINOR_CHANGED,
        ADDED,
        MAJOR_CHANGED,
        REMOVED;

    }

    private static class Problem {
        private IElement element;
        private int severity;
        private ComponentReferenceType componentReferenceType;
        private Version version;

        public Problem(IElement element, int severity, ComponentReferenceType componentReferenceType, Version version) {
            this.element = element;
            this.severity = severity;
            this.componentReferenceType = componentReferenceType;
            this.version = version;
        }

        public IElement getElement() {
            return this.element;
        }

        public int getSeverity() {
            return this.severity;
        }

        public ComponentReferenceType getComponentReferenceType() {
            return this.componentReferenceType;
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

