/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.HashSet;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;

public class EditablePropertyTester
extends PropertyTester {
    private static final Object EDITABLE = "editable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals(EDITABLE)) {
            MarkerSupportItem item = (MarkerSupportItem)receiver;
            HashSet<IMarker> markers = new HashSet<IMarker>();
            if (item.isConcrete()) {
                markers.add(((MarkerEntry)receiver).getMarker());
            } else {
                MarkerSupportItem[] markerSupportItemArray = item.getChildren();
                int n = markerSupportItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MarkerSupportItem child = markerSupportItemArray[n2];
                    if (child.isConcrete()) {
                        markers.add(((MarkerEntry)child).getMarker());
                    }
                    ++n2;
                }
            }
            if (!markers.isEmpty()) {
                for (IMarker marker : markers) {
                    if (marker.getAttribute("userEditable", true)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

