/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.osgi.util.NLS;

public class RepositoryFinder
implements IApplication {
    private static final boolean SUPPRESS_STATS = PropertiesUtil.isProperty((String)"suppress.stats");

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        Pattern pattern = Pattern.compile(arguments[0]);
        ArrayList<String> urls = new ArrayList<String>();
        P2Index.Repository[] repositories = P2Index.INSTANCE.getRepositories();
        if (repositories != null) {
            P2Index.Repository[] repositoryArray = repositories;
            int n = repositories.length;
            int n2 = 0;
            while (n2 < n) {
                P2Index.Repository repository = repositoryArray[n2];
                String url = repository.getLocation().toString();
                if (pattern.matcher(url).find()) {
                    urls.add(url);
                }
                ++n2;
            }
        }
        if (!SUPPRESS_STATS) {
            System.out.println(NLS.bind((String)Messages.RepositoryFinder_Found_message, (Object)urls.size(), (Object)repositories.length));
        }
        Collections.sort(urls);
        for (String url : urls) {
            System.out.println(url);
        }
        return null;
    }

    public void stop() {
    }
}

