/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.PreferenceTransferElement;
import org.eclipse.ui.internal.wizards.preferences.PreferencesMessages;
import org.eclipse.ui.internal.wizards.preferences.WizardPreferencesPage;

public class WizardPreferencesImportPage1
extends WizardPreferencesPage {
    protected WizardPreferencesImportPage1(String pageName) {
        super(pageName);
        this.setTitle(PreferencesMessages.WizardPreferencesImportPage1_importTitle);
        this.setDescription(PreferencesMessages.WizardPreferencesImportPage1_importDescription);
    }

    public WizardPreferencesImportPage1() {
        this("preferencesImportPage1");
    }

    @Override
    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.setHelp(composite, "org.eclipse.ui.preferences_import_wizard_page");
    }

    @Override
    protected String getAllButtonText() {
        return PreferencesMessages.WizardPreferencesImportPage1_all;
    }

    @Override
    protected String getChooseButtonText() {
        return PreferencesMessages.WizardPreferencesImportPage1_choose;
    }

    @Override
    protected PreferenceTransferElement[] getTransfers() {
        if (this.validFromFile()) {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (FileInputStream fis = new FileInputStream(this.getDestinationValue());){
                    IPreferencesService service = Platform.getPreferencesService();
                    IExportedPreferences prefs = service.readPreferences((InputStream)fis);
                    PreferenceTransferElement[] transfers = super.getTransfers();
                    IPreferenceFilter[] filters = new IPreferenceFilter[transfers.length];
                    int i = 0;
                    while (i < transfers.length) {
                        PreferenceTransferElement transfer = transfers[i];
                        filters[i] = transfer.getFilter();
                        ++i;
                    }
                    IPreferenceFilter[] matches = service.matches((IEclipsePreferences)prefs, filters);
                    PreferenceTransferElement[] returnTransfers = new PreferenceTransferElement[matches.length];
                    int index = 0;
                    IPreferenceFilter[] iPreferenceFilterArray = matches;
                    int n = matches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPreferenceFilter filter = iPreferenceFilterArray[n2];
                        PreferenceTransferElement[] preferenceTransferElementArray = transfers;
                        int n3 = transfers.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PreferenceTransferElement element = preferenceTransferElementArray[n4];
                            if (element.getFilter().equals(filter)) {
                                returnTransfers[index++] = element;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    PreferenceTransferElement[] destTransfers = new PreferenceTransferElement[index];
                    System.arraycopy(returnTransfers, 0, destTransfers, 0, index);
                    return destTransfers;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException e) {
                WorkbenchPlugin.log(e.getMessage(), e);
                return new PreferenceTransferElement[0];
            }
        }
        return new PreferenceTransferElement[0];
    }

    private boolean validFromFile() {
        File fromFile = new File(this.getDestinationValue());
        return fromFile.exists() && !fromFile.isDirectory();
    }

    @Override
    protected void setPreferenceTransfers() {
        super.setPreferenceTransfers();
        if (this.validFromFile() && this.transfersTree.getViewer().getTree().getItemCount() == 0) {
            this.descText.setText(PreferencesMessages.WizardPreferences_noSpecificPreferenceDescription);
        } else {
            this.descText.setText("");
        }
    }

    @Override
    protected void createTransferArea(Composite composite) {
        this.createDestinationGroup(composite);
        this.createTransfersList(composite);
    }

    @Override
    protected String getDestinationLabel() {
        return PreferencesMessages.WizardPreferencesImportPage1_file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean transfer(IPreferenceFilter[] filters) {
        File importFile = new File(this.getDestinationValue());
        if (filters.length <= 0) return true;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fis = new FileInputStream(importFile);){
                IPreferencesService service = Platform.getPreferencesService();
                try {
                    IExportedPreferences prefs = service.readPreferences((InputStream)fis);
                    service.applyPreferences((IEclipsePreferences)prefs, filters);
                    return true;
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log(e.getMessage(), e);
                    MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)"", (String)e.getLocalizedMessage(), (int)0x10000000);
                    if (fis == null) return false;
                    fis.close();
                    return false;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            WorkbenchPlugin.log(e.getMessage(), e);
            MessageDialog.open((int)1, (Shell)this.getControl().getShell(), (String)"", (String)e.getLocalizedMessage(), (int)0x10000000);
            return false;
        }
    }

    @Override
    public void handleEvent(Event e) {
        if (e.widget == this.destinationNameField) {
            this.setPreferenceTransfers();
        }
        super.handleEvent(e);
    }

    @Override
    protected String getFileDialogTitle() {
        return PreferencesMessages.WizardPreferencesImportPage1_title;
    }

    @Override
    protected int getFileDialogStyle() {
        return 0x10001000;
    }

    @Override
    protected boolean validDestination() {
        return super.validDestination() && this.validFromFile();
    }

    @Override
    protected String getInvalidDestinationMessage() {
        return PreferencesMessages.WizardPreferencesImportPage1_invalidPrefFile;
    }

    @Override
    protected boolean shouldSaveTransferAll() {
        return false;
    }
}

