/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SimpleLicenseManager
extends LicenseManager {
    private final Set<String> accepted = new HashSet<String>();
    private final String profileId;
    private static final Pattern DIGESTS_DELIMITER = Pattern.compile(",");

    public SimpleLicenseManager(String profileId) {
        this.profileId = profileId;
        this.initializeFromPreferences();
    }

    public SimpleLicenseManager() {
        this("_SELF_");
    }

    public boolean accept(ILicense license) {
        this.accepted.add(license.getUUID());
        this.updatePreferences();
        return true;
    }

    public boolean reject(ILicense license) {
        this.accepted.remove(license.getUUID());
        this.updatePreferences();
        return true;
    }

    public boolean isAccepted(ILicense license) {
        return this.accepted.contains(license.getUUID());
    }

    public boolean hasAcceptedLicenses() {
        return !this.accepted.isEmpty();
    }

    private Preferences getPreferences() {
        IAgentLocation location = (IAgentLocation)ProvSDKUIActivator.getDefault().getProvisioningAgent().getService(IAgentLocation.class);
        return new ProfileScope(location, this.profileId).getNode("org.eclipse.equinox.p2.ui.sdk");
    }

    private void initializeFromPreferences() {
        Preferences pref = this.getPreferences();
        if (pref != null) {
            String digestList = pref.get("licenseDigestList", "");
            DIGESTS_DELIMITER.splitAsStream(digestList).filter(s -> !s.isBlank()).map(String::strip).forEach(this.accepted::add);
        }
    }

    private void updatePreferences() {
        Preferences pref = this.getPreferences();
        String acceptedLicenseDigests = String.join((CharSequence)",", this.accepted);
        pref.put("licenseDigestList", acceptedLicenseDigests);
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            ILog.of(SimpleLicenseManager.class).error("Persisting remembered licenses failed", (Throwable)e);
        }
    }
}

