/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.services.internal.events;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.services.internal.events.UIEventHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventBroker
implements IEventBroker {
    private final Map<EventHandler, Collection<ServiceRegistration<?>>> registrations = new HashMap();
    @Inject
    @Optional
    UISynchronize uiSync;
    @Inject
    EventAdmin eventAdmin;
    BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();

    public boolean send(String topic, Object data) {
        Event event = this.constructEvent(topic, data);
        this.eventAdmin.sendEvent(event);
        return true;
    }

    public boolean post(String topic, Object data) {
        Event event = this.constructEvent(topic, data);
        this.eventAdmin.postEvent(event);
        return true;
    }

    private Event constructEvent(String topic, Object data) {
        Event event;
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey("event.topics") && map.containsKey("org.eclipse.e4.data")) {
                return new Event(topic, map);
            }
            HashMap<String, Object> eventMap = new HashMap<String, Object>(map);
            if (!eventMap.containsKey("event.topics")) {
                eventMap.put("event.topics", topic);
            }
            if (!eventMap.containsKey("org.eclipse.e4.data")) {
                eventMap.put("org.eclipse.e4.data", data);
            }
            event = new Event(topic, eventMap);
        } else if (data instanceof Dictionary) {
            Dictionary d = (Dictionary)data;
            if (d.get("event.topics") != null && d.get("org.eclipse.e4.data") != null) {
                return new Event(topic, d);
            }
            Map<String, Object> map = EventBroker.convertToMap(d);
            if (map.get("event.topics") == null) {
                map.put("event.topics", topic);
            }
            if (map.get("org.eclipse.e4.data") == null) {
                map.put("org.eclipse.e4.data", map);
            }
            event = new Event(topic, map);
        } else {
            Hashtable<String, Object> d = new Hashtable<String, Object>(2);
            ((Dictionary)d).put("event.topics", topic);
            if (data != null) {
                ((Dictionary)d).put("org.eclipse.e4.data", data);
            }
            event = new Event(topic, d);
        }
        return event;
    }

    private static <K, V> Map<K, V> convertToMap(Dictionary<K, V> source) {
        Hashtable<K, V> map = new Hashtable<K, V>();
        Enumeration<K> keys = source.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            map.put(key, source.get(key));
        }
        return map;
    }

    public boolean subscribe(String topic, EventHandler eventHandler) {
        return this.subscribe(topic, null, eventHandler, false);
    }

    public boolean subscribe(String topic, String filter, EventHandler eventHandler, boolean headless) {
        String[] topics = new String[]{topic};
        Hashtable<String, Object> d = new Hashtable<String, Object>();
        ((Dictionary)d).put("event.topics", topics);
        if (filter != null) {
            ((Dictionary)d).put("event.filter", filter);
        }
        UIEventHandler wrappedHandler = new UIEventHandler(eventHandler, headless ? null : this.uiSync);
        ServiceRegistration registration = this.bundleContext.registerService(EventHandler.class.getName(), (Object)wrappedHandler, d);
        Collection<ServiceRegistration<?>> handled = this.registrations.get(eventHandler);
        if (handled == null) {
            handled = new ArrayList();
            this.registrations.put(eventHandler, handled);
        }
        handled.add(registration);
        return true;
    }

    public boolean unsubscribe(EventHandler eventHandler) {
        Collection<ServiceRegistration<?>> handled = this.registrations.remove(eventHandler);
        if (handled == null || handled.isEmpty()) {
            return false;
        }
        for (ServiceRegistration<?> r : handled) {
            r.unregister();
        }
        return true;
    }

    @PreDestroy
    void dispose() {
        ArrayList values = new ArrayList(this.registrations.values());
        this.registrations.clear();
        for (Collection collection : values) {
            for (ServiceRegistration registration : collection) {
                registration.unregister();
            }
        }
    }
}

