// This is a generated file, modify: generate/templates/class_content.cc

#include <nan.h>
#include <string.h>

extern "C" {
#include <git2.h>
}

#include "../include/lock_master.h"
#include "../include/functions/copy.h"
#include "../include/packbuilder.h"
#include "nodegit_wrapper.cc"

#include "../include/oid.h"
#include "../include/revwalk.h"
#include "../include/repository.h"

#include <iostream>

using namespace std;
using namespace v8;
using namespace node;

GitPackbuilder::~GitPackbuilder()
{
  // this will cause an error if you have a non-self-freeing object that also needs
  // to save values. Since the object that will eventually free the object has no
  // way of knowing to free these values.
}

void GitPackbuilder::InitializeComponent(Local<v8::Object> target)
{
  Nan::HandleScope scope;

  Local<FunctionTemplate> tpl = Nan::New<FunctionTemplate>(JSNewFunction);

  tpl->InstanceTemplate()->SetInternalFieldCount(1);
  tpl->SetClassName(Nan::New("Packbuilder").ToLocalChecked());

  Nan::SetPrototypeMethod(tpl, "free", Free);
  Nan::SetPrototypeMethod(tpl, "hash", Hash);
  Nan::SetPrototypeMethod(tpl, "insert", Insert);
  Nan::SetPrototypeMethod(tpl, "insertCommit", InsertCommit);
  Nan::SetPrototypeMethod(tpl, "insertRecur", InsertRecur);
  Nan::SetPrototypeMethod(tpl, "insertTree", InsertTree);
  Nan::SetPrototypeMethod(tpl, "insertWalk", InsertWalk);
  Nan::SetMethod(tpl, "create", Create);
  Nan::SetPrototypeMethod(tpl, "objectCount", ObjectCount);
  Nan::SetPrototypeMethod(tpl, "setThreads", SetThreads);
  Nan::SetPrototypeMethod(tpl, "written", Written);

  InitializeTemplate(tpl);

  Local<Function> _constructor_template = Nan::GetFunction(tpl).ToLocalChecked();
  constructor_template.Reset(_constructor_template);
  Nan::Set(target, Nan::New("Packbuilder").ToLocalChecked(), _constructor_template);
}


/*
     */
NAN_METHOD(GitPackbuilder::Free)
{
  Nan::EscapableHandleScope scope;

  if (Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue() != NULL) {

    giterr_clear();

    {
      LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                           );

      git_packbuilder_free(
        Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
      );

      Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->ClearValue();
    }
    return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
  }
}

/*
     * @return Oid  result    */
NAN_METHOD(GitPackbuilder::Hash)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                         );

    const git_oid * result = git_packbuilder_hash(
                               Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                             );

    // null checks on pointers
    if (!result) {
      return info.GetReturnValue().Set(scope.Escape(Nan::Undefined()));
    }

    Local<v8::Value> to;
// start convert_to_v8 block

    if (result != NULL) {
      // GitOid result
      to = GitOid::New(result, true , info.This() );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Oid id
   * @param String name
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::Insert)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0
      || (!info[0]->IsObject() && !info[0]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
  if (info.Length() == 1 || !info[1]->IsString()) {
    return Nan::ThrowError("String name is required.");
  }

// start convert_from_v8 block
  const git_oid * from_id;
  if (info[0]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[0]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[0]->ToObject())->GetValue();
  }
// end convert_from_v8 block
// start convert_from_v8 block
  const char * from_name;

  String::Utf8Value name(info[1]->ToString());
  // malloc with one extra byte so we can add the terminating null character C-strings expect:
  from_name = (const char *) malloc(name.length() + 1);
  // copy the characters from the nodejs string into our C-string (used instead of strdup or strcpy because nulls in
  // the middle of strings are valid coming from nodejs):
  memcpy((void *)from_name, *name, name.length());
  // ensure the final byte of our new string is null, extra casts added to ensure compatibility with various C types
  // used in the nodejs binding generation:
  memset((void *)(((char *)from_name) + name.length()), 0, 1);
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                                           ,    from_id
                                           ,    from_name
                         );

    int result = git_packbuilder_insert(
                   Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                   ,  from_id
                   ,  from_name
                 );

    if (info[0]->IsString()) {
      free((void *)from_id);
    }

    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Oid id
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::InsertCommit)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0
      || (!info[0]->IsObject() && !info[0]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
// start convert_from_v8 block
  const git_oid * from_id;
  if (info[0]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[0]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[0]->ToObject())->GetValue();
  }
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                                           ,    from_id
                         );

    int result = git_packbuilder_insert_commit(
                   Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                   ,  from_id
                 );

    if (info[0]->IsString()) {
      free((void *)from_id);
    }

    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Oid id
   * @param String name
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::InsertRecur)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0
      || (!info[0]->IsObject() && !info[0]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
  if (info.Length() == 1 || !info[1]->IsString()) {
    return Nan::ThrowError("String name is required.");
  }

// start convert_from_v8 block
  const git_oid * from_id;
  if (info[0]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[0]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[0]->ToObject())->GetValue();
  }
// end convert_from_v8 block
// start convert_from_v8 block
  const char * from_name;

  String::Utf8Value name(info[1]->ToString());
  // malloc with one extra byte so we can add the terminating null character C-strings expect:
  from_name = (const char *) malloc(name.length() + 1);
  // copy the characters from the nodejs string into our C-string (used instead of strdup or strcpy because nulls in
  // the middle of strings are valid coming from nodejs):
  memcpy((void *)from_name, *name, name.length());
  // ensure the final byte of our new string is null, extra casts added to ensure compatibility with various C types
  // used in the nodejs binding generation:
  memset((void *)(((char *)from_name) + name.length()), 0, 1);
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                                           ,    from_id
                                           ,    from_name
                         );

    int result = git_packbuilder_insert_recur(
                   Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                   ,  from_id
                   ,  from_name
                 );

    if (info[0]->IsString()) {
      free((void *)from_id);
    }

    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Oid id
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::InsertTree)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0
      || (!info[0]->IsObject() && !info[0]->IsString())) {
    return Nan::ThrowError("Oid id is required.");
  }
// start convert_from_v8 block
  const git_oid * from_id;
  if (info[0]->IsString()) {
    // Try and parse in a string to a git_oid
    String::Utf8Value oidString(info[0]->ToString());
    git_oid *oidOut = (git_oid *)malloc(sizeof(git_oid));

    if (git_oid_fromstr(oidOut, (const char *) strdup(*oidString)) != GIT_OK) {
      free(oidOut);

      if (giterr_last()) {
        return Nan::ThrowError(giterr_last()->message);
      } else {
        return Nan::ThrowError("Unknown Error");
      }
    }

    from_id = oidOut;
  } else {
    from_id = Nan::ObjectWrap::Unwrap<GitOid>(info[0]->ToObject())->GetValue();
  }
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                                           ,    from_id
                         );

    int result = git_packbuilder_insert_tree(
                   Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                   ,  from_id
                 );

    if (info[0]->IsString()) {
      free((void *)from_id);
    }

    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Revwalk walk
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::InsertWalk)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("Revwalk walk is required.");
  }

// start convert_from_v8 block
  git_revwalk * from_walk;
  from_walk = Nan::ObjectWrap::Unwrap<GitRevwalk>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                                           ,    from_walk
                         );

    int result = git_packbuilder_insert_walk(
                   Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                   ,  from_walk
                 );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
  * @param Repository repo
     * @return Packbuilder out    */
NAN_METHOD(GitPackbuilder::Create)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsObject()) {
    return Nan::ThrowError("Repository repo is required.");
  }

  git_packbuilder * out = 0;
// start convert_from_v8 block
  git_repository * from_repo;
  from_repo = Nan::ObjectWrap::Unwrap<GitRepository>(info[0]->ToObject())->GetValue();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    from_repo
                         );

    git_packbuilder_new(
      &  out
      ,  from_repo
    );


    Local<v8::Value> to;
// start convert_to_v8 block

    if (out != NULL) {
      // GitPackbuilder out
      to = GitPackbuilder::New(out, false  );
    } else {
      to = Nan::Null();
    }

// end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::ObjectCount)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                         );

    uint32_t result = git_packbuilder_object_count(
                        Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                      );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
   * @param Number n
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::SetThreads)
{
  Nan::EscapableHandleScope scope;

  if (info.Length() == 0 || !info[0]->IsNumber()) {
    return Nan::ThrowError("Number n is required.");
  }

// start convert_from_v8 block
  unsigned int from_n;
  from_n = (unsigned int)   info[0]->ToNumber()->Value();
// end convert_from_v8 block

  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                         );

    unsigned int result = git_packbuilder_set_threads(
                            Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                            ,  from_n
                          );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}

/*
     * @return Number  result    */
NAN_METHOD(GitPackbuilder::Written)
{
  Nan::EscapableHandleScope scope;


  giterr_clear();

  {
    LockMaster lockMaster(/*asyncAction: */false        ,    Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                         );

    uint32_t result = git_packbuilder_written(
                        Nan::ObjectWrap::Unwrap<GitPackbuilder>(info.This())->GetValue()
                      );


    Local<v8::Value> to;
// start convert_to_v8 block
    to = Nan::New<Number>( result);
    // end convert_to_v8 block
    return info.GetReturnValue().Set(scope.Escape(to));
  }
}
// force base class template instantiation, to make sure we get all the
// methods, statics, etc.
template class NodeGitWrapper<GitPackbuilderTraits>;
