/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.sample.utility;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.eclipse.paho.sample.utility.ConnOpts;
import org.eclipse.paho.sample.utility.MQTTFrame;

public class MQTTHist
extends JDialog
implements ActionListener,
Runnable {
    private ConnOpts connOptions;
    private JTextArea histData;
    private JScrollPane scroller;
    private boolean running = true;
    private boolean logEnabled = true;
    private JButton close = null;
    private JFrame owner = null;

    public MQTTHist(JFrame theOwner, ConnOpts connOptions) {
        super((Frame)theOwner, "WMQTT Client History");
        this.owner = theOwner;
        this.connOptions = connOptions;
        Container histDialog = this.getContentPane();
        histDialog.setLayout(new BorderLayout());
        JButton clear = new JButton("Clear");
        clear.addActionListener(this);
        clear.setToolTipText("Clear history dialog");
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        this.close.setToolTipText("Close history log");
        JPanel bottom = new JPanel();
        bottom.setBorder(new EtchedBorder());
        bottom.add(clear);
        bottom.add(this.close);
        this.histData = new JTextArea(3, 30);
        this.histData.setBorder(new BevelBorder(1));
        this.histData.setEditable(false);
        this.histData.setMargin(MQTTFrame.TEXT_MARGINS);
        this.scroller = new JScrollPane(this.histData);
        histDialog.add((Component)this.scroller, "Center");
        histDialog.add((Component)bottom, "South");
        this.setDefaultCloseOperation(1);
        new Thread(this).start();
    }

    private void defaultDialogSize(JFrame owner) {
        this.setBounds(owner.getX() + owner.getWidth(), owner.getY(), 375, 450);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.running = false;
        JTextArea jTextArea = this.histData;
        synchronized (jTextArea) {
            this.histData.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(String logData) {
        if (this.logEnabled) {
            this.histData.append(logData);
            this.histData.revalidate();
            JTextArea jTextArea = this.histData;
            synchronized (jTextArea) {
                this.histData.notify();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Clear")) {
            this.histData.setText("");
        } else if (e.getActionCommand().equals("Close")) {
            this.disableHistory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JScrollBar jsb = this.scroller.getVerticalScrollBar();
        while (this.running) {
            try {
                JTextArea jTextArea = this.histData;
                synchronized (jTextArea) {
                    this.histData.wait();
                }
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jsb.setValue(jsb.getMaximum());
        }
    }

    public void enableHistory() {
        this.defaultDialogSize(this.owner);
        this.logEnabled = true;
        this.setVisible(true);
    }

    public void disableHistory() {
        this.logEnabled = false;
        this.setVisible(false);
    }
}

