/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Vector;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.ConnectActionListener;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME;
    private static final Logger log;
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.paho.client.mqttv3.internal.CommsCallback");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    }

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackThread = new Thread((Runnable)this, threadName);
                this.callbackThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.running) {
                log.fine(CLASS_NAME, "stop", "700");
                this.running = false;
                if (!Thread.currentThread().equals(this.callbackThread)) {
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            log.fine(CLASS_NAME, "stop", "701");
                            this.workAvailable.notifyAll();
                        }
                        this.callbackThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.callbackThread = null;
            log.fine(CLASS_NAME, "stop", "703");
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            if (!this.running) {
                return;
            }
            try {
                try {
                    try {
                        var1_1 = this.workAvailable;
                        synchronized (var1_1) {
                            if (this.running && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                                CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "704");
                                this.workAvailable.wait();
                            }
                        }
                    }
                    catch (InterruptedException v1) {}
                    if (this.running) {
                        token = null;
                        var2_3 = this.completeQueue;
                        synchronized (var2_3) {
                            if (!this.completeQueue.isEmpty()) {
                                token = (MqttToken)this.completeQueue.elementAt(0);
                                this.completeQueue.removeElementAt(0);
                            }
                        }
                        if (token != null) {
                            this.handleActionComplete(token);
                        }
                        message = null;
                        var3_4 = this.messageQueue;
                        synchronized (var3_4) {
                            if (!this.messageQueue.isEmpty()) {
                                message = (MqttPublish)this.messageQueue.elementAt(0);
                                this.messageQueue.removeElementAt(0);
                            }
                        }
                        if (message != null) {
                            this.handleMessage(message);
                        }
                    }
                    if (this.quiescing) {
                        this.clientState.checkQuiesceLock();
                    }
                }
                catch (Throwable ex) {
                    CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "714", null, ex);
                    this.running = false;
                    this.clientComms.shutdownConnection(null, new MqttException(ex));
                }
            }
            catch (Throwable var5_7) {
                var4_5 = null;
                var6_6 = this.spaceAvailable;
                synchronized (var6_6) {
                    CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                    throw var5_7;
                }
            }
            {
                var4_5 = null;
                var6_6 = this.spaceAvailable;
            }
            synchronized (var6_6) {
                ** try [egrp 6[TRYBLOCK] [10 : 265->293)] { 
lbl68:
                // 1 sources

                CommsCallback.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                this.spaceAvailable.notifyAll();
            }
        }
lbl-1000:
        // 1 sources

        {
            catch (Throwable v5) {
                throw v5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            log.fine(CLASS_NAME, "handleActionComplete", "705", new Object[]{token.internalTok.getKey()});
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token.isComplete() && (token instanceof MqttDeliveryToken || token.getActionCallback() instanceof ConnectActionListener)) {
                token.internalTok.setNotified(true);
            }
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
        }
    }

    public void connectionLost(MqttException cause) {
        try {
            if (this.mqttCallback != null && cause != null) {
                log.fine(CLASS_NAME, "connectionLost", "708", new Object[]{cause});
                this.mqttCallback.connectionLost(cause);
            }
        }
        catch (Throwable t) {
            log.fine(CLASS_NAME, "connectionLost", "720", new Object[]{t});
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onSuccess(token);
            } else {
                log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageArrived(MqttPublish sendMessage) {
        if (this.mqttCallback == null) return;
        Object object = this.spaceAvailable;
        synchronized (object) {
            while (this.running && !this.quiescing && this.messageQueue.size() >= 10) {
                try {
                    log.fine(CLASS_NAME, "messageArrived", "709");
                    this.spaceAvailable.wait(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.quiescing) return;
        this.messageQueue.addElement(sendMessage);
        object = this.workAvailable;
        synchronized (object) {
            log.fine(CLASS_NAME, "messageArrived", "710");
            this.workAvailable.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            log.fine(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        if (this.mqttCallback != null) {
            String destName = publishMessage.getTopicName();
            log.fine(CLASS_NAME, "handleMessage", "713", new Object[]{new Integer(publishMessage.getMessageId()), destName});
            this.mqttCallback.messageArrived(destName, publishMessage.getMessage());
            if (publishMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token) {
        if (this.running) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                log.fine(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{token.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            log.fine(CLASS_NAME, "asyncOperationComplete", "719", null, ex);
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }
}

