/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

public class WebSocketFrame {
    public static final int frameLengthOverhead = 6;
    private byte opcode;
    private boolean fin;
    private byte[] payload;
    private boolean closeFlag = false;

    public byte getOpcode() {
        return this.opcode;
    }

    public boolean isFin() {
        return this.fin;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isCloseFlag() {
        return this.closeFlag;
    }

    public WebSocketFrame(byte opcode, boolean fin, byte[] payload) {
        this.opcode = opcode;
        this.fin = fin;
        this.payload = payload;
    }

    public WebSocketFrame(byte[] rawFrame) {
        ByteBuffer buffer = ByteBuffer.wrap(rawFrame);
        byte b = buffer.get();
        this.setFinAndOpCode(b);
        b = buffer.get();
        boolean masked = (b & 0x80) != 0;
        int payloadLength = 0x7F & b;
        int byteCount = 0;
        if (payloadLength == 127) {
            byteCount = 8;
        } else if (payloadLength == 126) {
            byteCount = 2;
        }
        while (--byteCount > 0) {
            b = buffer.get();
            payloadLength |= (b & 0xFF) << 8 * byteCount;
        }
        byte[] maskingKey = null;
        if (masked) {
            maskingKey = new byte[4];
            buffer.get(maskingKey, 0, 4);
        }
        this.payload = new byte[payloadLength];
        buffer.get(this.payload, 0, payloadLength);
        if (masked) {
            int i = 0;
            while (i < this.payload.length) {
                int n = i;
                this.payload[n] = (byte)(this.payload[n] ^ maskingKey[i % 4]);
                ++i;
            }
        }
    }

    private void setFinAndOpCode(byte incomingByte) {
        this.fin = (incomingByte & 0x80) != 0;
        this.opcode = (byte)(incomingByte & 0xF);
    }

    public WebSocketFrame(InputStream input) throws IOException {
        byte firstByte = (byte)input.read();
        this.setFinAndOpCode(firstByte);
        if (this.opcode == 2) {
            byte maskLengthByte = (byte)input.read();
            boolean masked = (maskLengthByte & 0x80) != 0;
            int payloadLength = 0x7F & maskLengthByte;
            int byteCount = 0;
            if (payloadLength == 127) {
                byteCount = 8;
            } else if (payloadLength == 126) {
                byteCount = 2;
            }
            if (byteCount > 0) {
                payloadLength = 0;
            }
            while (--byteCount >= 0) {
                maskLengthByte = (byte)input.read();
                payloadLength |= (maskLengthByte & 0xFF) << 8 * byteCount;
            }
            byte[] maskingKey = null;
            if (masked) {
                maskingKey = new byte[4];
                input.read(maskingKey, 0, 4);
            }
            this.payload = new byte[payloadLength];
            int offsetIndex = 0;
            int tempLength = payloadLength;
            int bytesRead = 0;
            while (offsetIndex != payloadLength) {
                bytesRead = input.read(this.payload, offsetIndex, tempLength);
                offsetIndex += bytesRead;
                tempLength -= bytesRead;
            }
            if (masked) {
                int i = 0;
                while (i < this.payload.length) {
                    int n = i;
                    this.payload[n] = (byte)(this.payload[n] ^ maskingKey[i % 4]);
                    ++i;
                }
            }
            return;
        }
        if (this.opcode != 8) {
            throw new IOException("Invalid Frame: Opcode: " + this.opcode);
        }
        this.closeFlag = true;
    }

    public byte[] encodeFrame() {
        int length = this.payload.length + 6;
        if (this.payload.length > 65535) {
            length += 8;
        } else if (this.payload.length >= 126) {
            length += 2;
        }
        ByteBuffer buffer = ByteBuffer.allocate(length);
        WebSocketFrame.appendFinAndOpCode(buffer, this.opcode, this.fin);
        byte[] mask = WebSocketFrame.generateMaskingKey();
        WebSocketFrame.appendLengthAndMask(buffer, this.payload.length, mask);
        int i = 0;
        while (i < this.payload.length) {
            int n = i;
            byte by = (byte)(this.payload[n] ^ mask[i % 4]);
            this.payload[n] = by;
            buffer.put(by);
            ++i;
        }
        buffer.flip();
        return buffer.array();
    }

    public static void appendLengthAndMask(ByteBuffer buffer, int length, byte[] mask) {
        if (mask != null) {
            WebSocketFrame.appendLength(buffer, length, true);
            buffer.put(mask);
        } else {
            WebSocketFrame.appendLength(buffer, length, false);
        }
    }

    private static void appendLength(ByteBuffer buffer, int length, boolean masked) {
        int b;
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        int n = b = masked ? -128 : 0;
        if (length > 65535) {
            buffer.put((byte)(b | 0x7F));
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)(length >> 24 & 0xFF));
            buffer.put((byte)(length >> 16 & 0xFF));
            buffer.put((byte)(length >> 8 & 0xFF));
            buffer.put((byte)(length & 0xFF));
        } else if (length >= 126) {
            buffer.put((byte)(b | 0x7E));
            buffer.put((byte)(length >> 8));
            buffer.put((byte)(length & 0xFF));
        } else {
            buffer.put((byte)(b | length));
        }
    }

    public static void appendFinAndOpCode(ByteBuffer buffer, byte opcode, boolean fin) {
        byte b = 0;
        if (fin) {
            b = (byte)(b | 0x80);
        }
        b = (byte)(b | opcode & 0xF);
        buffer.put(b);
    }

    public static byte[] generateMaskingKey() {
        SecureRandom secureRandomGenerator = new SecureRandom();
        int a = secureRandomGenerator.nextInt(255);
        int b = secureRandomGenerator.nextInt(255);
        int c = secureRandomGenerator.nextInt(255);
        int d = secureRandomGenerator.nextInt(255);
        return new byte[]{(byte)a, (byte)b, (byte)c, (byte)d};
    }
}

