/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general;

import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ModelElementProperties;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ReviewItemProperties
extends ModelElementProperties {
    private static final String REVIEW_ITEM_AUTHOR_ID = "reviewItemElement.author";
    private static final PropertyDescriptor REVIEW_ITEM_AUTHOR_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.author", "Added By: ");
    private static final String REVIEW_ITEM_AUTHOR_REP_ID = "reviewItemElement.authorRep";
    private static final PropertyDescriptor REVIEW_ITEM_AUTHOR_REP_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.authorRep", "Email: ");
    private static final String REVIEW_ITEM_PROJECT_ID = "reviewItemElement.project";
    private static final PropertyDescriptor REVIEW_ITEM_PROJECT_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.project", "Project Id: ");
    private static final String REVIEW_ITEM_CHANGE_ID = "reviewItemElement.ChangeId";
    private static final PropertyDescriptor REVIEW_ITEM_CHANGE_ID_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.ChangeId", "Change Id: ");
    private static final String REVIEW_ITEM_DATE_SUBMITTED_ID = "reviewItemElement.dateSubmitted";
    private static final PropertyDescriptor REVIEW_ITEM_DATE_SUBMITTED_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.dateSubmitted", "Date Submitted: ");
    private static final String REVIEW_ITEM_DESCRIPTION_ID = "reviewItemElement.description";
    private static final PropertyDescriptor REVIEW_ITEM_DESCRIPTION_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.description", "Description: ");
    private static final String REVIEW_ITEM_ASSIGNED_TO_ID = "reviewItemElement.assignedTo";
    protected static final PropertyDescriptor REVIEW_ITEM_ASSIGNED_TO_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewItemElement.assignedTo", "Assigned to: ");
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{REVIEW_ITEM_AUTHOR_PROPERTY_DESCRIPTOR, REVIEW_ITEM_AUTHOR_REP_PROPERTY_DESCRIPTOR, REVIEW_ITEM_PROJECT_PROPERTY_DESCRIPTOR, REVIEW_ITEM_CHANGE_ID_PROPERTY_DESCRIPTOR, REVIEW_ITEM_DATE_SUBMITTED_PROPERTY_DESCRIPTOR, REVIEW_ITEM_DESCRIPTION_PROPERTY_DESCRIPTOR};

    public ReviewItemProperties(R4EUIModelElement aElement) {
        super(aElement);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Object getPropertyValue(Object aId) {
        if (REVIEW_ITEM_AUTHOR_ID.equals(aId)) {
            return ((R4EUIReviewItem)this.getElement()).getItem().getAddedById();
        }
        if (REVIEW_ITEM_AUTHOR_REP_ID.equals(aId)) {
            R4EItem modelItem = ((R4EUIReviewItem)this.getElement()).getItem();
            if (modelItem.getAuthorRep() != null) {
                return modelItem.getAuthorRep();
            }
            try {
                R4EParticipant participant = R4EUIModelController.getActiveReview().getParticipant(modelItem.getAddedById(), false);
                if (participant != null) {
                    return participant.getEmail();
                }
                return "";
            }
            catch (ResourceHandlingException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                return "";
            }
        }
        if (REVIEW_ITEM_PROJECT_ID.equals(aId)) {
            return ((R4EUIReviewItem)this.getElement()).getItem().getProjectURIs();
        }
        if (REVIEW_ITEM_CHANGE_ID.equals(aId)) {
            return ((R4EUIReviewItem)this.getElement()).getItem().getRepositoryRef();
        }
        if (REVIEW_ITEM_DATE_SUBMITTED_ID.equals(aId)) {
            return ((R4EUIReviewItem)this.getElement()).getItem().getSubmitted();
        }
        if (REVIEW_ITEM_DESCRIPTION_ID.equals(aId)) {
            return ((R4EUIReviewItem)this.getElement()).getItem().getDescription();
        }
        if (REVIEW_ITEM_ASSIGNED_TO_ID.equals(aId)) {
            return ((R4EUIReviewItem)this.getElement()).getItem().getAssignedTo();
        }
        return null;
    }
}

