/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.core.resources.IResource;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class PostponedFileTabPropertySection
extends ModelElementTabPropertySection {
    protected Text fOriginalFileNameText = null;
    protected Text fOriginalFilePathRepositoryText = null;
    protected Text fOriginalFilePathAbsoluteText = null;
    protected Text fOriginalFilePathProjectText = null;
    protected Text fOriginalFileVersionText = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        Group targetFileComposite = widgetFactory.createGroup(composite, "Original File");
        FormLayout targetFileLayout = new FormLayout();
        targetFileComposite.setLayout((Layout)targetFileLayout);
        this.createOriginalFileVersionComposite((Composite)targetFileComposite, widgetFactory);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        targetFileComposite.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
    }

    private void createOriginalFileVersionComposite(final Composite aParent, TabbedPropertySheetWidgetFactory aWidgetFactory) {
        FormData data = null;
        this.fOriginalFileNameText = aWidgetFactory.createText(aParent, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)aParent, 4);
        this.fOriginalFileNameText.setEditable(false);
        this.fOriginalFileNameText.setToolTipText("The Name of the file where the original postponed anomaly was raised");
        this.fOriginalFileNameText.setLayoutData((Object)data);
        CLabel fileNameLabel = aWidgetFactory.createCLabel(aParent, "Name: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fOriginalFileNameText, -5);
        data.top = new FormAttachment((Control)this.fOriginalFileNameText, 0, 0x1000000);
        fileNameLabel.setToolTipText("The Name of the file where the original postponed anomaly was raised");
        fileNameLabel.setLayoutData((Object)data);
        this.fOriginalFileVersionText = aWidgetFactory.createText(aParent, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fOriginalFileNameText, 4);
        this.fOriginalFileVersionText.setEditable(false);
        this.fOriginalFileVersionText.setToolTipText("The Version of the file where the original postponed anomaly was raised");
        this.fOriginalFileVersionText.setLayoutData((Object)data);
        CLabel fileVersionLabel = aWidgetFactory.createCLabel(aParent, "Version: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fOriginalFileVersionText, -5);
        data.top = new FormAttachment((Control)this.fOriginalFileVersionText, 0, 0x1000000);
        fileVersionLabel.setToolTipText("The Version of the file where the original postponed anomaly was raised");
        fileVersionLabel.setLayoutData((Object)data);
        ExpandableComposite pathSection = aWidgetFactory.createExpandableComposite(aParent, 66);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fOriginalFileVersionText, 4);
        pathSection.setLayoutData((Object)data);
        pathSection.setText("Path Information");
        pathSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledComposite scrolledParent = (ScrolledComposite)aParent.getParent().getParent().getParent().getParent().getParent().getParent();
                scrolledParent.setMinSize(aParent.computeSize(-1, -1));
                scrolledParent.layout(true, true);
            }
        });
        pathSection.setLayout((Layout)new GridLayout(1, false));
        Composite pathSectionClient = aWidgetFactory.createComposite((Composite)pathSection);
        pathSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        pathSectionClient.setLayout((Layout)new GridLayout(4, false));
        pathSection.setClient((Control)pathSectionClient);
        CLabel filePathRepositoryLabel = aWidgetFactory.createCLabel(pathSectionClient, "Repository Path: ");
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathRepositoryLabel.setToolTipText("The Repository Path to the file where the original postponed anomaly was raised");
        filePathRepositoryLabel.setLayoutData((Object)gridData);
        this.fOriginalFilePathRepositoryText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fOriginalFilePathRepositoryText.setEditable(false);
        this.fOriginalFilePathRepositoryText.setToolTipText("The Repository Path to the file where the original postponed anomaly was raised");
        this.fOriginalFilePathRepositoryText.setLayoutData((Object)gridData);
        CLabel filePathAbsoluteLabel = aWidgetFactory.createCLabel(pathSectionClient, "Absolute Path: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathAbsoluteLabel.setToolTipText("The Absolute Path to the file where the original postponed anomaly was raised");
        filePathAbsoluteLabel.setLayoutData((Object)gridData);
        this.fOriginalFilePathAbsoluteText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fOriginalFilePathAbsoluteText.setEditable(false);
        this.fOriginalFilePathAbsoluteText.setToolTipText("The Absolute Path to the file where the original postponed anomaly was raised");
        this.fOriginalFilePathAbsoluteText.setLayoutData((Object)gridData);
        CLabel filePathProjectLabel = aWidgetFactory.createCLabel(pathSectionClient, "Project Relative Path: ");
        gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 1;
        filePathProjectLabel.setToolTipText("The Project Relative Path to the file where the original postponed anomaly was raised");
        filePathProjectLabel.setLayoutData((Object)gridData);
        this.fOriginalFilePathProjectText = aWidgetFactory.createText(pathSectionClient, "", 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        this.fOriginalFilePathProjectText.setEditable(false);
        this.fOriginalFilePathProjectText.setToolTipText("The Project Relative Path to the file where the original postponed anomaly was raised");
        this.fOriginalFilePathProjectText.setLayoutData((Object)gridData);
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        R4EFileContext modelFile = ((R4EUIFileContext)this.fProperties.getElement()).getFileContext();
        R4EFileVersion targetVersion = modelFile.getTarget();
        if (targetVersion != null) {
            this.fOriginalFileNameText.setText(targetVersion.getName());
            IResource targetResource = targetVersion.getResource();
            if (targetResource != null) {
                this.fOriginalFilePathAbsoluteText.setText(targetResource.getLocation().toOSString());
            } else {
                this.fOriginalFilePathAbsoluteText.setText("");
            }
            this.fOriginalFileVersionText.setText(targetVersion.getVersionID());
        } else {
            this.fOriginalFileNameText.setText("(Not Present)");
            this.fOriginalFilePathAbsoluteText.setText("");
            this.fOriginalFileVersionText.setText("");
        }
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || R4EUIModelController.getActiveReview() == null || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fOriginalFileNameText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fOriginalFilePathAbsoluteText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fOriginalFileVersionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
        } else {
            this.fOriginalFileNameText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fOriginalFilePathAbsoluteText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fOriginalFileVersionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
        }
    }
}

