/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;

class ResourceUtils {
    ResourceUtils() {
    }

    public static IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ResourceUtils.getSelectedResources((IStructuredSelection)selection);
        }
        return new IResource[0];
    }

    public static IQ7NamedElement getNamedElementByResource(IResource resource) {
        IWorkspace workspace;
        IFile file;
        if (resource.getType() == 1 && (file = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getFile(resource.getFullPath())) != null && file.exists()) {
            return (IQ7NamedElement)RcpttCore.create((IResource)file);
        }
        return null;
    }

    private static IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList<IResource> selectedResources = new ArrayList<IResource>();
        for (Object o : selection) {
            IAdaptable a;
            IResource r;
            if (o instanceof IResource) {
                selectedResources.add((IResource)o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (r = (IResource)(a = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            selectedResources.add(r);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }
}

