/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.dispatch.IScriptletExtension;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.expandbar.runtime.internal.ExpandBarRuntimePlugin;
import org.eclipse.rcptt.expandbar.runtime.internal.ItemLocation;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.ecl.impl.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.model.ControlHandler;
import org.eclipse.rcptt.tesla.ecl.model.GetItems;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public class GetItemsExtension
implements IScriptletExtension {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        GetItems cmd = (GetItems)command;
        final ControlHandler parent = cmd.getControl();
        Element element = TeslaBridge.find((ControlHandler)parent, (IProcess)context);
        Widget widget = ((SWTUIElement)((SWTUIProcessor)TeslaBridge.getClient().getProcessor(SWTUIProcessor.class)).getMapper().get((Element)element)).widget;
        if (!(widget instanceof ExpandBar)) {
            return ExpandBarRuntimePlugin.err("Don't know how to get items from %s", widget);
        }
        final ExpandBar expandBar = (ExpandBar)widget;
        final ArrayList items = new ArrayList();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExpandItem[] expandItemArray = expandBar.getItems();
                int n = expandItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExpandItem item = expandItemArray[n2];
                    ControlHandler handler = TeslaFactory.eINSTANCE.createControlHandler();
                    handler.setKind(ElementKind.Item);
                    handler.setParent(parent);
                    handler.setPath(ItemLocation.fromItem(item).toPathFragment());
                    items.add(handler);
                    ++n2;
                }
            }
        });
        for (ControlHandler item : items) {
            context.getOutput().write((Object)item);
        }
        return Status.OK_STATUS;
    }

    public boolean canHandle(Command c) {
        return c instanceof GetItems && GetItemsExtension.isExpandBarHandle(((GetItems)c).getControl());
    }

    public static final boolean isExpandBarHandle(ControlHandler handle) {
        return handle.getKind() == ElementKind.Custom && "org.eclipse.swt.widgets.ExpandBar".equals(handle.getCustomKindId());
    }
}

