/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.context;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.actions.ContextSnapshotAction;
import org.eclipse.rcptt.ui.context.ContextUIManager;
import org.eclipse.rcptt.ui.context.ContextViewer;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.editors.IQ7EditorActionsProvider;
import org.eclipse.rcptt.ui.editors.NamedElementEditorPage;
import org.eclipse.rcptt.ui.editors.context.ContextEditor;
import org.eclipse.rcptt.ui.utils.ImageManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ContextEditorPage
extends NamedElementEditorPage {
    private ImageManager imageManager = new ImageManager();
    private IQ7Editor<Context> editor;

    public void setSelectionAtLine(int line) {
        if (this.editor != null) {
            this.editor.setSelectionAtLine(line);
        }
    }

    public ContextEditorPage(ContextEditor editor) {
        super(editor, "context", Messages.ContextEditorPage_Name);
    }

    public Context getElement() {
        return (Context)super.getElement();
    }

    @Override
    protected EditorHeader createHeader() {
        return new EditorHeader(this.getModel(), (NamedElement)this.getElement()){

            @Override
            protected Button createRecordButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.ContextEditorPage_CaptureButtonText, 8);
                button.setImage(Images.getImage("icons/camera.png"));
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.record();
                    }
                });
                ContextType type = ContextTypeManager.getInstance().getTypeByContext((Context)this.getElement());
                ContextViewer viewer = ContextUIManager.getInstance().getViewer(type);
                if (viewer != null) {
                    button.setEnabled(viewer.getViewer().isCaptureSupported());
                }
                return button;
            }

            @Override
            protected Button createReplayButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.ContextEditorPage_ApplyButtonText, 8);
                button.setImage(DebugUITools.getImage((String)"IMG_ACT_RUN"));
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((e.stateMask & 0x20000) != 0) {
                            this.multiReplay();
                        } else {
                            this.replay();
                        }
                    }
                });
                ContextType type = ContextTypeManager.getInstance().getTypeByContext((Context)this.getElement());
                ContextViewer viewer = ContextUIManager.getInstance().getViewer(type);
                if (viewer != null) {
                    button.setEnabled(viewer.getViewer().isApplySupported());
                }
                return button;
            }

            @Override
            protected void record() {
                ContextEditorPage.this.record();
            }
        };
    }

    @Override
    protected void createSpecificContent(Composite parent, FormToolkit toolkit, IManagedForm form) {
        ContextType type = ContextTypeManager.getInstance().getTypeByContext(this.getElement());
        ContextViewer viewer = ContextUIManager.getInstance().getViewer(type);
        if (viewer == null) {
            throw new RuntimeException("While opening " + this.getElement().getName() + ", failed to find viewer of " + type.getId() + " context type.");
        }
        if (viewer != null) {
            ImageDescriptor descriptor;
            this.editor = viewer.getViewer().createEditor();
            this.editor.setElement(this.getModel());
            this.editor.setForm(form);
            this.editor.create(parent, toolkit, (IWorkbenchSite)this.getSite(), this.getHeader());
            if (this.editor instanceof IQ7EditorActionsProvider) {
                ((ContextEditor)this.getEditor()).setCtxActions(((IQ7EditorActionsProvider)((Object)this.editor)).createActions());
            }
            if ((descriptor = viewer.getIcon()) != null) {
                Image img = this.imageManager.getImage(descriptor);
                ((ContextEditor)this.getEditor()).setEditorImage(img);
            }
        }
    }

    @Override
    protected void record() {
        new ContextSnapshotAction(this.editor).run();
    }

    public void save() throws CoreException {
        this.editor.save();
    }

    public void dispose() {
        super.dispose();
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.getEditor() instanceof ContextEditor) {
            ((ContextEditor)this.getEditor()).setEditorImage(Images.getImage("icons/context.gif"));
        }
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }
}

