/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.injection.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.launching.injection.Directory;
import org.eclipse.rcptt.launching.injection.Entry;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.InjectionFactory;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.injection.internal.InjectionPlugin;

public class InjectionUtil {
    private static final String UNIT_SEP = ";";

    public static String siteToString(UpdateSite site) {
        StringBuilder sb = new StringBuilder();
        sb.append(site.getUri());
        if (site.isAllUnits()) {
            return sb.toString();
        }
        sb.append(UNIT_SEP);
        for (String unit : site.getUnits()) {
            sb.append(unit).append(UNIT_SEP);
        }
        return sb.toString();
    }

    public static UpdateSite siteFromString(String string) {
        String[] entries = string.split(UNIT_SEP);
        UpdateSite result = InjectionFactory.eINSTANCE.createUpdateSite();
        result.setUri(entries[0]);
        int i = 1;
        while (i < entries.length) {
            if (entries[i].length() > 0) {
                result.getUnits().add((Object)entries[i]);
            }
            ++i;
        }
        result.setAllUnits(result.getUnits().isEmpty());
        return result;
    }

    public static String entryToString(Entry entry) {
        if (entry instanceof UpdateSite) {
            return InjectionUtil.siteToString((UpdateSite)entry);
        }
        if (entry instanceof Directory) {
            return InjectionUtil.dirToString((Directory)entry);
        }
        return "";
    }

    public static Directory dirFromString(String string) {
        Directory result = InjectionFactory.eINSTANCE.createDirectory();
        result.setPath(string);
        return result;
    }

    public static String dirToString(Directory dir) {
        return dir.getPath();
    }

    public static InjectionConfiguration merge(InjectionConfiguration a, InjectionConfiguration b) {
        Entry merged;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        Map<String, Entry> aMap = InjectionUtil.getEntryMap(a);
        Map<String, Entry> bMap = InjectionUtil.getEntryMap(b);
        HashMap<String, Entry> resultMap = new HashMap<String, Entry>();
        for (String key : aMap.keySet()) {
            merged = InjectionUtil.mergeEntry(key, aMap.get(key), bMap, resultMap);
            resultMap.put(key, merged);
        }
        for (String key : bMap.keySet()) {
            merged = InjectionUtil.mergeEntry(key, bMap.get(key), aMap, resultMap);
            resultMap.put(key, merged);
        }
        InjectionConfiguration result = InjectionFactory.eINSTANCE.createInjectionConfiguration();
        result.getEntries().addAll(resultMap.values());
        return result;
    }

    private static Entry mergeEntry(String key, Entry entry, Map<String, Entry> other, Map<String, Entry> result) {
        if (result.containsKey(key)) {
            return result.get(key);
        }
        Entry otherEntry = other.get(key);
        if (otherEntry == null) {
            return (Entry)EcoreUtil.copy((EObject)entry);
        }
        return InjectionUtil.mergeEntry(entry, otherEntry);
    }

    private static Entry mergeEntry(Entry a, Entry b) {
        if (a instanceof UpdateSite && b instanceof UpdateSite) {
            UpdateSite site1 = (UpdateSite)a;
            UpdateSite site2 = (UpdateSite)b;
            if (site1.isAllUnits()) {
                return (Entry)EcoreUtil.copy((EObject)a);
            }
            if (site2.isAllUnits()) {
                return (Entry)EcoreUtil.copy((EObject)b);
            }
            UpdateSite result = InjectionFactory.eINSTANCE.createUpdateSite();
            result.setUri(site1.getUri());
            result.setAllUnits(false);
            HashSet<String> units = new HashSet<String>();
            units.addAll((Collection<String>)site1.getUnits());
            units.addAll((Collection<String>)site2.getUnits());
            result.getUnits().addAll(units);
            return result;
        }
        if (a instanceof Directory && b instanceof Directory) {
            return (Entry)EcoreUtil.copy((EObject)a);
        }
        InjectionPlugin.logWarn("Injection entries have the same key but different type");
        return (Entry)EcoreUtil.copy((EObject)a);
    }

    private static Map<String, Entry> getEntryMap(InjectionConfiguration config) {
        HashMap<String, Entry> result = new HashMap<String, Entry>();
        for (Entry entry : config.getEntries()) {
            if (entry instanceof UpdateSite) {
                result.put(((UpdateSite)entry).getUri(), entry);
                continue;
            }
            if (!(entry instanceof Directory)) continue;
            result.put(((Directory)entry).getPath(), entry);
        }
        return result;
    }
}

