/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.expandbar.runtime.internal;

import org.eclipse.rcptt.expandbar.runtime.internal.ExpandBarDescriber;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.swt.IRecordingDescriber;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTWidgetLocator;
import org.eclipse.swt.widgets.ExpandBar;

public class ExpandBarRecordingDescriber
extends ExpandBarDescriber
implements IRecordingDescriber {
    private SWTUIElement element;
    private boolean needLogging;

    public ExpandBarRecordingDescriber(ExpandBar bar) {
        super(bar);
    }

    public ExpandBarRecordingDescriber(SWTUIElement element) {
        super((ExpandBar)element.unwrap());
        this.element = element;
    }

    public Element searchForElement(TeslaRecorder recorder) {
        SWTWidgetLocator locator = SWTRecordingHelper.getHelper().getLocator();
        FindResult result = null;
        if (this.element != null) {
            if (this.needLogging && TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"assert engine", (String)String.format("Looking for element: %s", this.element.getClassName()));
            }
            result = locator.findElement(this.element, false, false, true);
        } else {
            if (this.needLogging && TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"assert engine", (String)String.format("assert properties of the element: %s", this.getWidget().getClass().getName()));
            }
            result = locator.findElement(this.getWidget(), true, false, true);
        }
        return result == null ? null : result.element;
    }

    public IRecordingDescriber getParent() {
        return this;
    }

    public void setNeedLogging(boolean fixed) {
        this.needLogging = fixed;
    }
}

