/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.impl.SimpleBNode;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;

public class MemBNode
extends SimpleBNode
implements MemResource {
    private static final long serialVersionUID = -887382892580321647L;
    private final transient Object creator;
    private volatile transient MemStatementList subjectStatements;
    private volatile transient MemStatementList objectStatements;
    private volatile transient MemStatementList contextStatements;

    public MemBNode(Object creator, String id) {
        super(id);
        this.creator = creator;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return this.subjectStatements != null || this.objectStatements != null || this.contextStatements != null;
    }

    @Override
    public MemStatementList getSubjectStatementList() {
        if (this.subjectStatements == null) {
            return EMPTY_LIST;
        }
        return this.subjectStatements;
    }

    @Override
    public int getSubjectStatementCount() {
        if (this.subjectStatements == null) {
            return 0;
        }
        return this.subjectStatements.size();
    }

    @Override
    public void addSubjectStatement(MemStatement st) {
        if (this.subjectStatements == null) {
            this.subjectStatements = new MemStatementList(4);
        }
        this.subjectStatements.add(st);
    }

    @Override
    public void removeSubjectStatement(MemStatement st) {
        this.subjectStatements.remove(st);
        if (this.subjectStatements.isEmpty()) {
            this.subjectStatements = null;
        }
    }

    @Override
    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) {
        if (this.subjectStatements != null) {
            this.subjectStatements.cleanSnapshots(currentSnapshot);
            if (this.subjectStatements.isEmpty()) {
                this.subjectStatements = null;
            }
        }
    }

    @Override
    public MemStatementList getObjectStatementList() {
        if (this.objectStatements == null) {
            return EMPTY_LIST;
        }
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        if (this.objectStatements == null) {
            return 0;
        }
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) {
        if (this.objectStatements == null) {
            this.objectStatements = new MemStatementList(4);
        }
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
        if (this.objectStatements.isEmpty()) {
            this.objectStatements = null;
        }
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        if (this.objectStatements != null) {
            this.objectStatements.cleanSnapshots(currentSnapshot);
            if (this.objectStatements.isEmpty()) {
                this.objectStatements = null;
            }
        }
    }

    @Override
    public MemStatementList getContextStatementList() {
        if (this.contextStatements == null) {
            return EMPTY_LIST;
        }
        return this.contextStatements;
    }

    @Override
    public int getContextStatementCount() {
        if (this.contextStatements == null) {
            return 0;
        }
        return this.contextStatements.size();
    }

    @Override
    public void addContextStatement(MemStatement st) {
        if (this.contextStatements == null) {
            this.contextStatements = new MemStatementList(4);
        }
        this.contextStatements.add(st);
    }

    @Override
    public void removeContextStatement(MemStatement st) {
        this.contextStatements.remove(st);
        if (this.contextStatements.isEmpty()) {
            this.contextStatements = null;
        }
    }

    @Override
    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
        if (this.contextStatements != null) {
            this.contextStatements.cleanSnapshots(currentSnapshot);
            if (this.contextStatements.isEmpty()) {
                this.contextStatements = null;
            }
        }
    }
}

