/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalLeftOuterJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.GroupByFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValueInFilter;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;

public class HasValueConstraintComponent
extends AbstractConstraintComponent {
    Value hasValue;

    public HasValueConstraintComponent(Value hasValue) {
        this.hasValue = hasValue;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection, Set<Resource> rdfListDedupe) {
        model.add(subject, SHACL.HAS_VALUE, this.hasValue, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.HasValueConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new HasValueConstraintComponent(this.hasValue);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        EffectiveTarget target = this.getTargetChain().getEffectiveTarget("_target", scope, connectionsGroup.getRdfsSubClassOfReasoner());
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode addedTargets;
            Path path = this.getTargetChain().getPath().get();
            if (overrideTargetNode != null) {
                addedTargets = overrideTargetNode.getPlanNode();
                addedTargets = target.extend(addedTargets, connectionsGroup, scope, EffectiveTarget.Extend.right, false);
            } else {
                addedTargets = target.getPlanNode(connectionsGroup, scope, true);
                PlanNode addedByPath = path.getAdded(connectionsGroup, null);
                addedByPath = target.getTargetFilter(connectionsGroup, new Unique(new TrimToTarget(addedByPath), false));
                addedByPath = target.extend(addedByPath, connectionsGroup, scope, EffectiveTarget.Extend.left, false);
                addedTargets = new UnionNode(addedByPath, addedTargets);
                addedTargets = new Unique(addedTargets, false);
            }
            BulkedExternalLeftOuterJoin joined = new BulkedExternalLeftOuterJoin(addedTargets, connectionsGroup.getBaseConnection(), path.getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
            GroupByFilter invalidTargets = new GroupByFilter(joined, group -> group.stream().map(ValidationTuple::getValue).noneMatch(v -> this.hasValue.equals(v)));
            return new Unique(new TrimToTarget(invalidTargets), false);
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode addedTargets;
            if (overrideTargetNode != null) {
                addedTargets = overrideTargetNode.getPlanNode();
                addedTargets = target.extend(addedTargets, connectionsGroup, scope, EffectiveTarget.Extend.right, false);
            } else {
                addedTargets = target.getPlanNode(connectionsGroup, scope, false);
            }
            PlanNode falseNode = new ValueInFilter(addedTargets, new HashSet<Value>(Collections.singletonList(this.hasValue))).getFalseNode(UnBufferedPlanNode.class);
            return falseNode;
        }
        throw new UnsupportedOperationException("Unknown scope: " + (Object)((Object)scope));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true);
            return new Unique(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return new EmptyNode();
    }

    @Override
    public Stream<StatementMatcher> getStatementMatchers_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        if (this.getTargetChain().getPath().isPresent()) {
            Path path = this.getTargetChain().getPath().get();
            return path.getStatementMatcher(subject, object, rdfsSubClassOfReasoner);
        }
        throw new IllegalStateException("Dunno what to do here!");
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            Path path = this.getTargetChain().getPath().get();
            if (this.hasValue.isIRI()) {
                return SparqlFragment.bgp("BIND(<" + this.hasValue + "> as ?" + object.getName() + ")\n" + path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner));
            }
            if (this.hasValue.isLiteral()) {
                return SparqlFragment.bgp("BIND(" + this.hasValue.toString() + " as ?" + object.getName() + ")\n" + path.getTargetQueryFragment(subject, object, rdfsSubClassOfReasoner));
            }
            throw new UnsupportedOperationException("value was unsupported type: " + this.hasValue.getClass().getSimpleName());
        }
        if (this.hasValue.isIRI()) {
            return SparqlFragment.filterCondition("?" + object.getName() + " = <" + this.hasValue + ">");
        }
        if (this.hasValue.isLiteral()) {
            return SparqlFragment.filterCondition("?" + object.getName() + " = " + this.hasValue);
        }
        throw new UnsupportedOperationException("value was unsupported type: " + this.hasValue.getClass().getSimpleName());
    }
}

