/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import java.io.File;
import org.eclipse.rdf4j.federated.FedXFactory;
import org.eclipse.rdf4j.federated.repository.FedXRepository;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryConfig;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;

class FedXRepositoryWrapper
extends RepositoryWrapper
implements RepositoryResolverClient,
FederatedServiceResolverClient {
    private final FedXRepositoryConfig fedXConfig;
    private File dataDir;
    private RepositoryResolver repositoryResolver;
    private FederatedServiceResolver serviceResolver;

    FedXRepositoryWrapper(FedXRepositoryConfig fedXConfig) {
        this.fedXConfig = fedXConfig;
    }

    @Override
    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    @Override
    public boolean isInitialized() {
        if (this.getDelegate() == null) {
            return false;
        }
        return super.isInitialized();
    }

    @Override
    public void initialize() throws RepositoryException {
        FedXRepository fedxRepo;
        if (this.getDelegate() != null) {
            return;
        }
        File baseDir = this.getDataDir();
        if (baseDir == null) {
            baseDir = new File(".");
        }
        Model members = this.fedXConfig.getMembers();
        File dataConfigFile = null;
        if (this.fedXConfig.getDataConfig() != null) {
            dataConfigFile = new File(baseDir, this.fedXConfig.getDataConfig());
        }
        if (members == null && dataConfigFile == null) {
            throw new RepositoryException("No federation members defined: neither explicitly nor via data config.");
        }
        try {
            FedXFactory factory = FedXFactory.newFederation().withRepositoryResolver(this.repositoryResolver).withFederatedServiceResolver(this.serviceResolver).withFedXBaseDir(baseDir);
            if (dataConfigFile != null) {
                factory.withMembers(dataConfigFile);
            }
            if (members != null) {
                factory.withMembers(members);
            }
            if (this.fedXConfig.getConfig() != null) {
                factory.withConfig(this.fedXConfig.getConfig());
            }
            fedxRepo = factory.create();
            fedxRepo.init();
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        this.setDelegate(fedxRepo);
    }

    @Override
    public void shutDown() throws RepositoryException {
        if (!this.isInitialized()) {
            return;
        }
        super.shutDown();
        this.setDelegate(null);
    }

    @Override
    public void setRepositoryResolver(RepositoryResolver resolver) {
        this.repositoryResolver = resolver;
    }

    @Override
    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }
}

