/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.LockRemover;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class Load
extends ConsoleCommand {
    @Override
    public String getName() {
        return "load";
    }

    @Override
    public String getHelpShort() {
        return "Loads a data file into a repository, takes a file path or URL as argument";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nload <file-or-url> [from <base-uri>] [into <context-id>]\n  <file-or-url>   The path or URL identifying the data file\n  <base-uri>      The base URI to use for resolving relative references, defaults to <file-or-url>\n  <context-id>    The ID of the context to add the data to, e.g. foo:bar or _:n123\nLoads the specified data file into the current repository\n";
    }

    @Override
    public String[] usesSettings() {
        return new String[]{"workdir"};
    }

    public Load(ConsoleIO consoleIO, ConsoleState state, Map<String, ConsoleSetting> settings) {
        super(consoleIO, state, settings);
    }

    @Override
    public void execute(String ... tokens) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            this.writeUnopenedError();
        } else if (tokens.length < 2) {
            this.writeln(this.getHelpLong());
        } else {
            String baseURI = null;
            String context = null;
            int index = 2;
            if (tokens.length >= index + 2 && tokens[index].equalsIgnoreCase("from")) {
                baseURI = tokens[index + 1];
                index += 2;
            }
            if (tokens.length >= index + 2 && tokens[index].equalsIgnoreCase("into")) {
                context = tokens[tokens.length - 1];
                index += 2;
            }
            if (index < tokens.length) {
                this.writeln(this.getHelpLong());
            } else {
                this.load(repository, baseURI, context, tokens);
            }
        }
    }

    private Path getWorkDir() {
        return (Path)((WorkDir)this.settings.get("workdir")).get();
    }

    private void load(Repository repository, String baseURI, String context, String ... tokens) {
        String dataPath = tokens[1];
        URL dataURL = null;
        File dataFile = null;
        if (Util.isHttpOrFile(dataPath)) {
            try {
                dataURL = new URL(dataPath);
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            dataFile = Util.getNormalizedPath(this.getWorkDir(), dataPath).toFile();
        }
        try {
            this.addData(repository, baseURI, context, dataURL, dataFile);
        }
        catch (RepositoryReadOnlyException e) {
            this.handleReadOnlyException(repository, e, tokens);
        }
        catch (MalformedURLException e) {
            this.writeError("Malformed URL: " + dataPath);
        }
        catch (IllegalArgumentException e) {
            this.writeError(e.getMessage());
        }
        catch (IOException e) {
            this.writeError("Failed to load data", e);
        }
        catch (UnsupportedRDFormatException e) {
            this.writeError("No parser available for this RDF format");
        }
        catch (RDFParseException e) {
            this.writeError("Malformed document", e);
        }
        catch (RepositoryException e) {
            this.writeError("Unable to add data to repository", e);
        }
    }

    private void handleReadOnlyException(Repository repository, RepositoryReadOnlyException caught, String ... tokens) {
        try {
            if (LockRemover.tryToRemoveLock(repository, this.consoleIO)) {
                this.execute(tokens);
            } else {
                this.writeError("Failed to load data", caught);
            }
        }
        catch (RepositoryException e) {
            this.writeError("Unable to restart repository", e);
        }
        catch (IOException e) {
            this.writeError("Unable to remove lock", e);
        }
    }

    private void addData(Repository repository, String baseURI, String context, URL dataURL, File dataFile) throws RepositoryException, IOException, RDFParseException {
        Resource[] contexts = this.getContexts(repository, context);
        this.writeln("Loading data...");
        long startTime = System.nanoTime();
        try (RepositoryConnection con = repository.getConnection();){
            if (dataURL == null) {
                con.add(dataFile, baseURI, null, contexts);
            } else {
                con.add(dataURL, baseURI, null, contexts);
            }
        }
        long endTime = System.nanoTime();
        this.writeln("Data has been added to the repository (" + (endTime - startTime) / 1000000L + " ms)");
    }

    private Resource[] getContexts(Repository repository, String context) {
        Resource[] contexts = new Resource[]{};
        if (context != null) {
            Resource contextURI = context.startsWith("_:") ? repository.getValueFactory().createBNode(context.substring(2)) : repository.getValueFactory().createIRI(context);
            contexts = new Resource[]{contextURI};
        }
        return contexts;
    }
}

