/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclAstLists;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.LogicalOperatorConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;

public class AndConstraintComponent
extends LogicalOperatorConstraintComponent {
    List<Shape> and;

    public AndConstraintComponent(Resource id, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super(id);
        this.and = ShaclAstLists.toList(connection, id, Resource.class).stream().map(r -> new ShaclProperties((Resource)r, connection)).map(p -> {
            if (p.getType() == SHACL.NODE_SHAPE) {
                return NodeShape.getInstance(p, connection, cache, false, shaclSail);
            }
            if (p.getType() == SHACL.PROPERTY_SHAPE) {
                return PropertyShape.getInstance(p, connection, cache, shaclSail);
            }
            throw new IllegalStateException("Unknown shape type for " + p.getId());
        }).collect(Collectors.toList());
    }

    public AndConstraintComponent(AndConstraintComponent andConstraintComponent) {
        super(andConstraintComponent.getId());
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.AND, (Value)this.getId(), new Resource[0]);
        if (!cycleDetection.contains(this.getId())) {
            cycleDetection.add(this.getId());
            this.and.forEach(o -> o.toModel(null, null, model, cycleDetection));
        }
        if (!model.contains(this.getId(), null, null, new Resource[0])) {
            ShaclAstLists.listToRdf(this.and.stream().map(Shape::getId).collect(Collectors.toList()), this.getId(), model);
        }
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain);
        for (Shape shape : this.and) {
            shape.setTargetChain(targetChain.setOptimizable(false));
        }
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.AndConstraintComponent;
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        throw new ShaclUnsupportedException();
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.and.stream().map(a -> a.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, overrideTargetNode, scope)).reduce((xva$0, xva$1) -> UnionNode.getInstance(xva$0, xva$1)).orElse(EmptyNode.getInstance());
        return Unique.getInstance(planNode, false);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.and.stream().map(c -> c.getAllTargetsPlan(connectionsGroup, scope)).distinct().reduce((xva$0, xva$1) -> UnionNode.getInstanceDedupe(xva$0, xva$1)).orElse(EmptyNode.getInstance());
        planNode = Unique.getInstance(planNode, false);
        return planNode;
    }

    @Override
    public ConstraintComponent deepClone() {
        AndConstraintComponent andConstraintComponent = new AndConstraintComponent(this);
        andConstraintComponent.and = this.and.stream().map(ConstraintComponent::deepClone).map(a -> (Shape)a).collect(Collectors.toList());
        return andConstraintComponent;
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.and.stream().anyMatch(c -> c.requiresEvaluation(connectionsGroup, scope));
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return AndConstraintComponent.buildSparqlValidNodes_rsx_targetShape_inner(subject, object, rdfsSubClassOfReasoner, scope, stableRandomVariableProvider, this.and, this.getTargetChain(), SparqlFragment::join, SparqlFragment::and);
    }
}

