/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemStatementIteratorCache {
    private static final Logger logger = LoggerFactory.getLogger(MemStatementIteratorCache.class);
    public final int CACHE_FREQUENCY_THRESHOLD;
    private final ConcurrentHashMap<MemStatementIterator<? extends Exception>, Integer> iteratorFrequencyMap = new ConcurrentHashMap();
    private final Cache<MemStatementIterator<? extends Exception>, List<MemStatement>> iteratorCache = CacheBuilder.newBuilder().softValues().build();

    public MemStatementIteratorCache(int cacheFrequencyThreshold) {
        this.CACHE_FREQUENCY_THRESHOLD = cacheFrequencyThreshold;
    }

    public void invalidateCache() {
        if (!this.iteratorFrequencyMap.isEmpty()) {
            this.iteratorFrequencyMap.clear();
            this.iteratorCache.invalidateAll();
            this.iteratorCache.cleanUp();
            if (logger.isTraceEnabled()) {
                logger.debug("Invalidated cache", new Throwable());
            } else if (logger.isDebugEnabled()) {
                logger.debug("Invalidated cache");
            }
        }
    }

    <X extends Exception> void incrementIteratorFrequencyMap(MemStatementIterator<X> iterator) {
        Integer compute = this.iteratorFrequencyMap.compute(iterator, (key, value) -> {
            if (value == null) {
                return 0;
            }
            return value + 1;
        });
        if (logger.isDebugEnabled()) {
            logger.debug("Incremented iteratorFrequencyMap to {}\n{} \n{}", new Object[]{compute, iterator, iterator.getStats()});
        }
    }

    <X extends Exception> boolean shouldBeCached(MemStatementIterator<X> iterator) {
        if (!this.iteratorFrequencyMap.isEmpty()) {
            Integer integer = this.iteratorFrequencyMap.get(iterator);
            return integer != null && integer > this.CACHE_FREQUENCY_THRESHOLD;
        }
        return false;
    }

    <X extends Exception> CloseableIteration<MemStatement, X> getCachedIterator(MemStatementIterator<X> iterator) throws Exception {
        List cached = (List)this.iteratorCache.getIfPresent(iterator);
        if (cached == null) {
            try (MemStatementIterator<X> memStatementIterator = iterator;){
                logger.debug("Filling cache {}", iterator);
                ArrayList<MemStatement> newCache = new ArrayList<MemStatement>();
                while (iterator.hasNext()) {
                    newCache.add((MemStatement)iterator.next());
                }
                newCache.trimToSize();
                cached = Collections.unmodifiableList(newCache);
            }
            this.iteratorCache.put(iterator, cached);
        }
        return new CloseableIteratorIteration(cached.iterator());
    }
}

