/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

public class SimpleBindingSet
implements BindingSet {
    private static final long serialVersionUID = 1001660194269450975L;
    private final Set<String> bindingNamesSet;
    private final Binding[] bindings;
    private int cachedHashCode = 0;

    public SimpleBindingSet(Set<String> bindingNamesSet, List<String> varNamesList, List<Value> values) {
        assert (varNamesList.size() == values.size());
        this.bindingNamesSet = bindingNamesSet;
        this.bindings = new Binding[varNamesList.size()];
        for (int i = 0; i < varNamesList.size(); ++i) {
            this.bindings[i] = new SimpleBinding(varNamesList.get(i), values.get(i));
        }
    }

    public SimpleBindingSet(Set<String> bindingNamesSet, Binding[] bindings) {
        this.bindingNamesSet = bindingNamesSet;
        this.bindings = bindings;
    }

    @Override
    public Iterator<Binding> iterator() {
        return Arrays.asList(this.bindings).iterator();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.bindingNamesSet;
    }

    @Override
    public Binding getBinding(String bindingName) {
        for (Binding binding : this.bindings) {
            if (!binding.getName().equals(bindingName)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.bindingNamesSet.contains(bindingName);
    }

    @Override
    public Value getValue(String bindingName) {
        Binding binding = this.getBinding(bindingName);
        if (binding != null) {
            return binding.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.bindings.length;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode == 0) {
            int hashCode = 0;
            for (Binding binding : this.bindings) {
                hashCode ^= binding.getName().hashCode() ^ binding.getValue().hashCode();
            }
            this.cachedHashCode = hashCode;
        }
        return this.cachedHashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BindingSet)) {
            return false;
        }
        BindingSet that = (BindingSet)other;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.size() == 1) {
            Binding binding = this.iterator().next();
            Binding thatBinding = that.iterator().next();
            return binding.getName().equals(thatBinding.getName()) && binding.getValue().equals(thatBinding.getValue());
        }
        for (Binding binding : that) {
            Value ownValue = this.getValue(binding.getName());
            if (binding.getValue().equals(ownValue)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32 * this.size());
        sb.append('[');
        Iterator<Binding> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(';');
        }
        sb.append(']');
        return sb.toString();
    }
}

