/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class ReduceTargets
implements PlanNode {
    private final PlanNode parentToReduce;
    private final PlanNode reductionSource;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ReduceTargets(PlanNode parentToReduce, PlanNode reductionSource) {
        this.parentToReduce = PlanNodeHelper.handleSorting(this, parentToReduce);
        this.reductionSource = reductionSource;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            final Set<Value> reductionSourceSet;
            ValidationTuple next;
            {
                this.parentIterator = ReduceTargets.this.parentToReduce.iterator();
                this.reductionSourceSet = new HashSet<Value>();
                try (CloseableIteration<? extends ValidationTuple, SailException> iterator = ReduceTargets.this.reductionSource.iterator();){
                    while (iterator.hasNext()) {
                        this.reductionSourceSet.add(((ValidationTuple)iterator.next()).getActiveTarget());
                    }
                }
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    if (this.reductionSourceSet.contains(temp.getActiveTarget())) continue;
                    this.next = temp;
                }
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public void localClose() throws SailException {
                this.parentIterator.close();
            }
        };
    }

    @Override
    public int depth() {
        return this.parentToReduce.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parentToReduce.receiveLogger(validationExecutionLogger);
        this.reductionSource.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parentToReduce.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public String toString() {
        return "ReduceTargets{parentToReduce=" + this.parentToReduce + ", reductionSource=" + this.reductionSource + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReduceTargets that = (ReduceTargets)o;
        if (!this.parentToReduce.equals(that.parentToReduce)) {
            return false;
        }
        return this.reductionSource.equals(that.reductionSource);
    }

    public int hashCode() {
        return 31 * this.parentToReduce.hashCode() + this.reductionSource.hashCode();
    }
}

