/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iterator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iterator.AbstractCloseableIterator;

public abstract class LookAheadIterator<E>
extends AbstractCloseableIterator<E> {
    private E nextElement;
    private IOException closeException;

    protected LookAheadIterator() {
    }

    protected abstract E getNextElement();

    @Override
    public final boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        this.lookAhead();
        return this.nextElement != null;
    }

    @Override
    public final E next() {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.lookAhead();
        E result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void lookAhead() {
        if (this.nextElement == null && !this.isClosed()) {
            this.nextElement = this.getNextElement();
            if (this.nextElement == null) {
                try {
                    this.close();
                }
                catch (IOException ioe) {
                    this.closeException = ioe;
                }
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws IOException {
        try {
            super.handleClose();
        }
        finally {
            this.nextElement = null;
        }
    }

    @Override
    protected void handleAlreadyClosed() throws IOException {
        IOException toThrowException = this.closeException;
        if (toThrowException != null) {
            throw toThrowException;
        }
    }
}

