/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public final class IfValueEvaluationStep
implements QueryValueEvaluationStep {
    private final QueryValueEvaluationStep result;
    private final QueryValueEvaluationStep condition;
    private final QueryValueEvaluationStep alternative;

    public IfValueEvaluationStep(QueryValueEvaluationStep result, QueryValueEvaluationStep condition, QueryValueEvaluationStep alternative) {
        this.result = result;
        this.condition = condition;
        this.alternative = alternative;
    }

    @Override
    public Value evaluate(BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        boolean conditionIsTrue;
        try {
            Value value = this.condition.evaluate(bindings);
            conditionIsTrue = QueryEvaluationUtil.getEffectiveBooleanValue(value);
        }
        catch (ValueExprEvaluationException e) {
            return null;
        }
        if (conditionIsTrue) {
            return this.result.evaluate(bindings);
        }
        return this.alternative.evaluate(bindings);
    }
}

