/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class FilterTargetIsSubject
extends FilterPlanNode {
    private final SailConnection connection;
    private final Resource[] dataGraph;

    public FilterTargetIsSubject(SailConnection connection, Resource[] dataGraph, PlanNode parent, ConnectionsGroup connectionsGroup) {
        super(parent, connectionsGroup);
        this.connection = connection;
        assert (this.connection != null);
        this.dataGraph = dataGraph;
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        Value target = t.get().getActiveTarget();
        if (target.isResource()) {
            return this.connection.hasStatement((Resource)target, null, null, true, this.dataGraph);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ExternalFilterTargetIsSubject{}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterTargetIsSubject that = (FilterTargetIsSubject)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && Arrays.equals(this.dataGraph, that.dataGraph);
        }
        return Objects.equals(this.connection, that.connection) && Arrays.equals(this.dataGraph, that.dataGraph);
    }

    @Override
    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(super.hashCode(), ((MemoryStoreConnection)this.connection).getSail(), Arrays.hashCode(this.dataGraph));
        }
        return Objects.hash(super.hashCode(), this.connection, Arrays.hashCode(this.dataGraph));
    }
}

