/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.repository;

import org.eclipse.rdf4j.federated.repository.FedXRepositoryConfig;
import org.eclipse.rdf4j.federated.repository.FedXRepositoryWrapper;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXRepositoryFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "fedx:FedXRepository";
    protected static final Logger log = LoggerFactory.getLogger(FedXRepositoryFactory.class);

    @Override
    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    @Override
    public FedXRepositoryConfig getConfig() {
        return new FedXRepositoryConfig();
    }

    @Override
    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        if (!(config instanceof FedXRepositoryConfig)) {
            throw new RepositoryConfigException("Unexpected configuration type: " + String.valueOf(config.getClass()));
        }
        FedXRepositoryConfig fedXConfig = (FedXRepositoryConfig)config;
        log.info("Configuring FedX for the RDF4J repository manager");
        return new FedXRepositoryWrapper(fedXConfig);
    }
}

