/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;

public final class PathTextUtils {
    private PathTextUtils() {
    }

    public static boolean hasTopLevel(String s, char ch) {
        if (s == null) {
            return false;
        }
        String t = s.trim();
        int depth = 0;
        for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            if (c == '(') {
                ++depth;
                continue;
            }
            if (c == ')') {
                --depth;
                continue;
            }
            if (c != ch || depth != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isWrapped(String s) {
        if (s == null) {
            return false;
        }
        String t = s.trim();
        if (t.length() < 2 || t.charAt(0) != '(' || t.charAt(t.length() - 1) != ')') {
            return false;
        }
        int depth = 0;
        for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            }
            if (depth != 0 || i >= t.length() - 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isAtomicPathText(String s) {
        if (s == null) {
            return true;
        }
        String t = s.trim();
        if (t.isEmpty()) {
            return true;
        }
        if (PathTextUtils.isWrapped(t)) {
            return true;
        }
        if (t.startsWith("!(")) {
            return true;
        }
        if (t.startsWith("^")) {
            String rest = t.substring(1).trim();
            return rest.startsWith("(") || !PathTextUtils.hasTopLevel(rest, '|') && !PathTextUtils.hasTopLevel(rest, '/');
        }
        return !PathTextUtils.hasTopLevel(t, '|') && !PathTextUtils.hasTopLevel(t, '/');
    }

    public static String wrapForSequence(String part) {
        if (part == null) {
            return null;
        }
        String t = part.trim();
        if (PathTextUtils.isWrapped(t) || !PathTextUtils.hasTopLevel(t, '|')) {
            return t;
        }
        return "(" + t + ")";
    }

    public static String wrapForInverse(String inner) {
        if (inner == null) {
            return "^()";
        }
        String t = inner.trim();
        return "^" + (String)(PathTextUtils.isAtomicPathText(t) ? t : "(" + t + ")");
    }

    public static String applyQuantifier(String inner, char quant) {
        if (inner == null) {
            return "()" + quant;
        }
        String t = inner.trim();
        return (String)(PathTextUtils.isAtomicPathText(t) ? t : "(" + t + ")") + quant;
    }

    public static String trimSingleOuterParens(String in) {
        String t = in;
        if (t.length() >= 2 && t.charAt(0) == '(' && t.charAt(t.length() - 1) == ')') {
            int depth = 0;
            for (int i = 0; i < t.length(); ++i) {
                char c = t.charAt(i);
                if (c == '(') {
                    ++depth;
                } else if (c == ')') {
                    --depth;
                }
                if (depth != 0 || i >= t.length() - 1) continue;
                return in;
            }
            return t.substring(1, t.length() - 1).trim();
        }
        return in;
    }

    public static List<String> splitTopLevel(String in, char sep) {
        ArrayList<String> out = new ArrayList<String>();
        int depth = 0;
        int last = 0;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '(') {
                ++depth;
                continue;
            }
            if (c == ')') {
                --depth;
                continue;
            }
            if (c != sep || depth != 0) continue;
            out.add(in.substring(last, i));
            last = i + 1;
        }
        if (last <= in.length()) {
            out.add(in.substring(last));
        }
        return out;
    }
}

