/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTask;
import org.eclipse.rdf4j.federated.evaluation.join.ControlledWorkerBindJoinBase;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelBoundJoinTask;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelCheckJoinTask;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelServiceJoinTask;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class ControlledWorkerBindJoin
extends ControlledWorkerBindJoinBase {
    public ControlledWorkerBindJoin(ControlledWorkerScheduler<BindingSet> scheduler, FederationEvalStrategy strategy, CloseableIteration<BindingSet> leftIter, TupleExpr rightArg, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(scheduler, strategy, leftIter, rightArg, bindings, queryInfo);
    }

    @Override
    protected ControlledWorkerBindJoinBase.TaskCreator determineTaskCreator(TupleExpr expr, BindingSet bs) {
        ControlledWorkerBindJoinBase.TaskCreator taskCreator;
        if (expr instanceof StatementTupleExpr) {
            StatementTupleExpr stmt = (StatementTupleExpr)expr;
            taskCreator = new BoundJoinTaskCreator(this.strategy, stmt);
        } else if (expr instanceof FedXService) {
            taskCreator = new FedXServiceJoinTaskCreator(this.strategy, (FedXService)expr);
        } else {
            throw new RuntimeException("Expr is of unexpected type: " + expr.getClass().getCanonicalName() + ". Please report this problem.");
        }
        return taskCreator;
    }

    protected class BoundJoinTaskCreator
    implements ControlledWorkerBindJoinBase.TaskCreator {
        protected final FederationEvalStrategy _strategy;
        protected final StatementTupleExpr _expr;

        public BoundJoinTaskCreator(FederationEvalStrategy strategy, StatementTupleExpr expr) {
            this._strategy = strategy;
            this._expr = expr;
        }

        @Override
        public ParallelTask<BindingSet> getTask(ParallelExecutor<BindingSet> control, List<BindingSet> bindings) {
            return new ParallelBoundJoinTask(control, this._strategy, this._expr, bindings);
        }
    }

    protected class FedXServiceJoinTaskCreator
    implements ControlledWorkerBindJoinBase.TaskCreator {
        protected final FederationEvalStrategy _strategy;
        protected final FedXService _expr;

        public FedXServiceJoinTaskCreator(FederationEvalStrategy strategy, FedXService expr) {
            this._strategy = strategy;
            this._expr = expr;
        }

        @Override
        public ParallelTask<BindingSet> getTask(ParallelExecutor<BindingSet> control, List<BindingSet> bindings) {
            return new ParallelServiceJoinTask(control, this._strategy, this._expr, bindings);
        }
    }

    @Deprecated(forRemoval=true)
    protected class CheckJoinTaskCreator
    implements ControlledWorkerBindJoinBase.TaskCreator {
        protected final FederationEvalStrategy _strategy;
        protected final CheckStatementPattern _expr;

        public CheckJoinTaskCreator(FederationEvalStrategy strategy, CheckStatementPattern expr) {
            this._strategy = strategy;
            this._expr = expr;
        }

        @Override
        public ParallelTask<BindingSet> getTask(ParallelExecutor<BindingSet> control, List<BindingSet> bindings) {
            return new ParallelCheckJoinTask(control, this._strategy, this._expr, bindings);
        }
    }
}

