/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class GroupValuesAndNpsInUnionBranchTransform
extends BaseTransform {
    private GroupValuesAndNpsInUnionBranchTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode n : bgp.getLines()) {
            if (n instanceof IrUnion) {
                out.add(GroupValuesAndNpsInUnionBranchTransform.groupUnionBranches((IrUnion)n));
                continue;
            }
            IrNode m = n.transformChildren(child -> {
                if (child instanceof IrBGP) {
                    return GroupValuesAndNpsInUnionBranchTransform.apply((IrBGP)child);
                }
                return child;
            });
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrUnion groupUnionBranches(IrUnion u) {
        IrUnion u2 = new IrUnion(u.isNewScope());
        for (IrBGP b : u.getBranches()) {
            IrBGP toAdd = GroupValuesAndNpsInUnionBranchTransform.maybeWrapBranch(b, u.isNewScope());
            u2.addBranch(toAdd);
        }
        return u2;
    }

    private static IrBGP maybeWrapBranch(IrBGP branch, boolean unionNewScope) {
        if (branch == null) {
            return null;
        }
        boolean hasTopValues = false;
        boolean hasTopNegPath = false;
        int topCount = branch.getLines().size();
        int valuesCount = 0;
        int negPathCount = 0;
        for (IrNode irNode : branch.getLines()) {
            String s;
            IrPathTriple pt;
            String path;
            IrGraph g;
            if (irNode instanceof IrValues) {
                hasTopValues = true;
                ++valuesCount;
                continue;
            }
            if (irNode instanceof IrPathTriple) {
                String s2;
                IrPathTriple pt2 = (IrPathTriple)irNode;
                String path2 = pt2.getPathText();
                if (path2 == null || !(s2 = path2.trim()).startsWith("!") && !s2.startsWith("!^")) continue;
                hasTopNegPath = true;
                ++negPathCount;
                continue;
            }
            if (!(irNode instanceof IrGraph) || (g = (IrGraph)irNode).getWhere() == null || g.getWhere().getLines().size() != 1 || !(g.getWhere().getLines().get(0) instanceof IrPathTriple) || (path = (pt = (IrPathTriple)g.getWhere().getLines().get(0)).getPathText()) == null || !(s = path.trim()).startsWith("!") && !s.startsWith("!^")) continue;
            hasTopNegPath = true;
            ++negPathCount;
        }
        if (unionNewScope && hasTopValues && hasTopNegPath && topCount == 2 && valuesCount == 1 && negPathCount == 1) {
            IrBGP inner = new IrBGP(false);
            for (IrNode ln : branch.getLines()) {
                inner.add(ln);
            }
            IrBGP irBGP = new IrBGP(inner.isNewScope());
            irBGP.add(inner);
            return irBGP;
        }
        return branch;
    }
}

