/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.app.logging.base;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConverterHandler
extends Handler {
    public LogConverterHandler() {
        this.setLevel(Level.ALL);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        Logger logger = LoggerFactory.getLogger((String)record.getLoggerName());
        int level = record.getLevel().intValue();
        String message = record.getMessage();
        Throwable thrown = record.getThrown();
        if (level >= Level.SEVERE.intValue()) {
            logger.error(message, thrown);
        } else if (level < Level.SEVERE.intValue() && level >= Level.WARNING.intValue()) {
            logger.warn(message, thrown);
        } else if (level < Level.WARNING.intValue() || level >= Level.CONFIG.intValue()) {
            logger.info(message, thrown);
        } else {
            logger.debug(message, thrown);
        }
    }
}

